/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.ui.designsession;

import java.io.File;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DataSourceDesignSessionBase;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class DataSourceDesignSession
extends DataSourceDesignSessionBase {
    public static DataSourceDesignSession startNewDesign(String odaDataSourceId, String newDataSourceName) throws OdaException {
        return DataSourceDesignSession.startNewDesign(odaDataSourceId, newDataSourceName, null, null);
    }

    public static DataSourceDesignSession startNewDesign(String odaDataSourceId, String newDataSourceName, ProfileReference profileRef, DesignSessionRequest request) throws OdaException {
        DataSourceDesignSession newSession = new DataSourceDesignSession(odaDataSourceId);
        newSession.initNewDesign(newDataSourceName, profileRef, request);
        return newSession;
    }

    public void restartNewDesign(String odaDataSourceId, String newDataSourceName, ProfileReference profileRef, DesignSessionRequest request) throws OdaException {
        super.restartNewDesign(odaDataSourceId, newDataSourceName, profileRef, request);
    }

    public static DataSourceDesignSession startEditDesign(DesignSessionRequest request) throws OdaException {
        return DataSourceDesignSession.startEditDesign(request, null);
    }

    public static DataSourceDesignSession startEditDesign(DesignSessionRequest request, DataSourceEditorPage editorPage) throws OdaException {
        String odaDataSourceId = DesignSessionUtil.validateRequestSession(request);
        DataSourceDesignSession newSession = new DataSourceDesignSession(odaDataSourceId);
        newSession.initEditDesign(request, editorPage);
        return newSession;
    }

    public static OdaDesignSession createNewDesignFromProfile(String odaDataSourceId, String newDataSourceName, ProfileReference profileRef) throws OdaException {
        DataSourceDesignSession newSession = DataSourceDesignSession.startNewDesign(odaDataSourceId, newDataSourceName, profileRef, null);
        return newSession.finishNewDesignFromProfile(newDataSourceName, profileRef);
    }

    private DataSourceDesignSession(String odaDataSourceId) {
        super(odaDataSourceId);
    }

    private DataSourceDesignSession() {
    }

    public DesignSessionRequest getRequest() {
        return super.getRequest();
    }

    public OdaDesignSession finish() throws OdaException {
        return super.finish();
    }

    public OdaDesignSession cancel() {
        return super.cancel();
    }

    public IWizard getNewWizard() throws OdaException {
        return super.getNewWizard();
    }

    public IWizardPage getWizardStartingPage() throws OdaException {
        return super.getWizardStartingPage();
    }

    public PropertyPage getEditorPage() throws OdaException {
        return super.getEditorPage();
    }

    public IAdaptable getEditPropertyPageElement() throws OdaException {
        return super.getEditPropertyPageElement();
    }

    public static class ProfileReference
    extends DataSourceDesignSessionBase.ProfileReferenceBase {
        public ProfileReference(String profileInstanceId, File storageFile, boolean maintainExternalLink) {
            super(profileInstanceId, storageFile, maintainExternalLink);
        }
    }
}

