/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.browsers;

import org.eclipse.birt.report.viewer.browsers.BrowserManager;
import org.eclipse.help.browser.IBrowser;

public class CurrentBrowser
implements IBrowser {
    private IBrowser browserAdapter;
    private String browserAdapterId;
    private IBrowser newBrowserAdapter = null;
    private String newBrowserAdapterId = null;
    private boolean locationSet = false;
    private boolean sizeSet = false;
    private int x;
    private int y;
    private int width;
    private int height;
    boolean external;

    public CurrentBrowser(IBrowser iBrowser, String string, boolean bl) {
        this.browserAdapter = iBrowser;
        this.browserAdapterId = string;
        this.external = bl;
    }

    public void close() {
        this.browserAdapter.close();
    }

    public boolean isCloseSupported() {
        return this.browserAdapter.isCloseSupported();
    }

    public void displayURL(String string) throws Exception {
        this.checkDefaultAdapter();
        if (this.newBrowserAdapter != null) {
            this.browserAdapter.close();
            this.browserAdapter = this.newBrowserAdapter;
            this.newBrowserAdapter = null;
            this.browserAdapterId = this.newBrowserAdapterId;
            this.newBrowserAdapterId = null;
            if (this.locationSet) {
                this.browserAdapter.setLocation(this.x, this.y);
            }
            if (this.sizeSet) {
                this.browserAdapter.setSize(this.width, this.height);
            }
        }
        this.browserAdapter.displayURL(string);
    }

    public boolean isSetLocationSupported() {
        this.checkDefaultAdapter();
        if (this.newBrowserAdapterId == null) {
            return this.browserAdapter.isSetLocationSupported();
        }
        return this.browserAdapter.isSetLocationSupported() || this.newBrowserAdapter.isSetLocationSupported();
    }

    public boolean isSetSizeSupported() {
        this.checkDefaultAdapter();
        if (this.newBrowserAdapterId == null) {
            return this.browserAdapter.isSetSizeSupported();
        }
        return this.browserAdapter.isSetSizeSupported() || this.newBrowserAdapter.isSetSizeSupported();
    }

    public void setLocation(int n, int n2) {
        this.checkDefaultAdapter();
        this.browserAdapter.setLocation(n, n2);
        this.locationSet = true;
        this.x = n;
        this.y = n2;
    }

    public void setSize(int n, int n2) {
        this.checkDefaultAdapter();
        this.browserAdapter.setSize(n, n2);
        this.sizeSet = true;
        this.width = n;
        this.height = n2;
    }

    private void checkDefaultAdapter() {
        if (this.external) {
            if (this.browserAdapterId != BrowserManager.getInstance().getCurrentBrowserID()) {
                this.newBrowserAdapter = BrowserManager.getInstance().createBrowser(true);
                this.newBrowserAdapterId = BrowserManager.getInstance().getCurrentBrowserID();
            }
        } else if (this.browserAdapterId != BrowserManager.getInstance().getCurrentInternalBrowserID()) {
            this.newBrowserAdapter = BrowserManager.getInstance().createBrowser(false);
            this.newBrowserAdapterId = BrowserManager.getInstance().getCurrentInternalBrowserID();
        }
    }
}

