/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;

public class DriverInstance {
    private TemplateDescriptor mTemplate;
    private IPropertySet mInstance;
    private Properties mInstanceProps;
    private ClassLoader mClassLoader;

    public DriverInstance(IPropertySet instance) {
        this.mInstance = instance;
        this.mInstanceProps = this.mInstance.getBaseProperties();
        if (this.mInstanceProps != null) {
            String templateId = this.mInstanceProps.getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
            this.mTemplate = TemplateDescriptor.getDriverTemplateDescriptor(templateId);
        }
    }

    public DriverInstance(TemplateDescriptor template, IPropertySet instance) {
        this.mTemplate = template;
        this.mInstance = instance;
        this.mInstanceProps = this.mInstance.getBaseProperties();
    }

    public String getName() {
        return this.mInstance.getName();
    }

    public String getId() {
        return this.mInstance.getID();
    }

    public String getJarList() {
        if (this.mInstanceProps != null && this.mInstanceProps.getProperty("jarList") != null) {
            String jarlist = this.mInstanceProps.getProperty("jarList");
            return jarlist.trim();
        }
        return null;
    }

    public String[] getJarListAsArray() {
        if (this.mInstanceProps != null && this.getJarList() != null) {
            if (this.getJarList().length() == 0) {
                return new String[0];
            }
            String[] paths = this.parseString(this.getJarList(), ",");
            return paths;
        }
        return null;
    }

    public String getNamedProperty(String name) {
        String id;
        String rtnStr = "";
        if (this.mInstanceProps != null && (id = this.getTemplate().getPropertyIDFromName(name)) != null) {
            rtnStr = this.mInstanceProps.getProperty(id);
        }
        if (rtnStr == null) {
            rtnStr = this.getTemplate().getPropertyValue(name);
        }
        return rtnStr;
    }

    public String getProperty(String id) {
        String rtnStr = null;
        if (this.mInstanceProps != null) {
            rtnStr = this.mInstanceProps.getProperty(id);
        }
        return rtnStr == null ? new String() : rtnStr;
    }

    public TemplateDescriptor getTemplate() {
        return this.mTemplate;
    }

    private String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    public IPropertySet getPropertySet() {
        return this.mInstance;
    }

    public ClassLoader getClassLoader() throws Exception {
        if (this.mClassLoader == null) {
            this.mClassLoader = this.createClassLoader(null);
        }
        return this.mClassLoader;
    }

    public ClassLoader createClassLoader(ClassLoader parentCL) throws Exception {
        String jarList = this.getJarList();
        if (!(jarList != null && jarList.trim().length() != 0 || this.getTemplate().getEmptyJarListIsOKFlag())) {
            throw new Exception(DriverMgmtMessages.getString("DriverInstance.error.jarListNotDefined"));
        }
        String[] jarStrings = this.getJarListAsArray();
        URL[] jars = new URL[jarStrings.length];
        int count = jars.length;
        for (int index = 0; index < count; ++index) {
            try {
                jars[index] = new File(jarStrings[index]).toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new Exception(DriverMgmtMessages.getString("DriverInstance.error.invalidClassPath"), e);
            }
        }
        if (parentCL == null) {
            return URLClassLoader.newInstance(jars);
        }
        return URLClassLoader.newInstance(jars, parentCL);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DriverInstance) {
            return obj == this || this.getId().equals(((DriverInstance)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

