/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;

public class CategoryProvider
extends PlatformObject
implements ICategory {
    public static final String ATTR_ID = "id";
    public static final String ATTR_PARENTCATEGORY = "parentCategory";
    public static final String ATTR_NAME = "name";
    private String mName;
    private String mId;
    private String mParentCategory;

    public CategoryProvider(IConfigurationElement element) {
        this.init(element);
    }

    private void init(IConfigurationElement element) {
        this.mId = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        this.mParentCategory = element.getAttribute(ATTR_PARENTCATEGORY);
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public ICategory getParent() {
        return ConnectionProfileManager.getInstance().getCategory(this.mParentCategory);
    }

    public List getChildCategories() {
        Map map = ConnectionProfileManager.getInstance().getCategories();
        Set set = map.keySet();
        ArrayList<ICategory> list = new ArrayList<ICategory>();
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            String id = (String)itr.next();
            ICategory cat = (ICategory)map.get(id);
            if (cat.getParent() == null || !cat.getParent().getId().equalsIgnoreCase(this.mId)) continue;
            list.add(cat);
        }
        return list;
    }

    public List getAssociatedProfiles() {
        return Arrays.asList(ProfileManager.getInstance().getProfilesByCategory(this.mId));
    }
}

