/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionFactoryProvider;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class CreateConnectionJob
extends Job {
    private IConnectionFactoryProvider mFactory;
    private IConnectionProfile mProfile;
    private Object mFamily;
    private IConnection mConnection;

    public CreateConnectionJob(IConnectionFactoryProvider factory, IConnectionProfile profile, Object family) {
        super(ConnectivityPlugin.getDefault().getResourceString("CreateConnectionJob.name", new Object[]{factory.getName(), profile.getName()}));
        this.setUser(true);
        this.mFactory = factory;
        this.mProfile = profile;
        this.mFamily = family;
    }

    public IConnectionFactoryProvider getConnectionFactoryProvider() {
        return this.mFactory;
    }

    public IConnectionProfile getConnectionProfile() {
        return this.mProfile;
    }

    public IConnection getConnection() {
        return this.mConnection;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        monitor.beginTask(this.getName(), -1);
        try {
            this.mConnection = this.mFactory.createConnection(this.mProfile);
            if (this.mConnection.getConnectException() != null) {
                status = new Status(4, ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("CreateConnectionJob.error", new Object[]{this.getConnectionFactoryProvider().getName(), this.getConnectionProfile().getName(), this.mConnection.getConnectException().getMessage()}), this.mConnection.getConnectException());
            }
        }
        catch (Exception e) {
            status = new Status(4, ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), -1, ConnectivityPlugin.getDefault().getResourceString("CreateConnectionJob.error", new Object[]{this.getConnectionFactoryProvider().getName(), this.getConnectionProfile().getName(), e.getMessage()}), (Throwable)e);
        }
        monitor.done();
        return status;
    }

    public boolean belongsTo(Object family) {
        return this.mFamily != null && family == this.mFamily;
    }
}

