/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.ComputedValueHandler;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.IAbsoluteFontSizeValueProvider;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

class CSSLengthValueHandler {
    static final String[] ABSOLUTE_FONT_SIZE_CONSTANTS;
    static DimensionValue defaultFontSizeValue;
    IAbsoluteFontSizeValueProvider provider;
    DimensionHandle dimensionHandle;
    static final /* synthetic */ boolean $assertionsDisabled;

    CSSLengthValueHandler(DimensionHandle dimensionHandle) {
        this.dimensionHandle = dimensionHandle;
        DesignSession session = dimensionHandle.getElementHandle().getModule().getSession();
        this.provider = session.getPredefinedFontSizeProvider();
    }

    DimensionValue getDefaultFontSizeValue() {
        if (defaultFontSizeValue == null) {
            ElementDefn styleDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement("Style");
            ElementPropertyDefn fontSizePropDefn = (ElementPropertyDefn)styleDefn.getProperty("fontSize");
            Object defaultValue = fontSizePropDefn.getDefault();
            if (defaultValue instanceof DimensionValue) {
                defaultFontSizeValue = (DimensionValue)defaultValue;
            }
            defaultFontSizeValue = this.provider.getValueOf((String)defaultValue);
        }
        return defaultFontSizeValue;
    }

    DimensionValue computeRelativeValue(DimensionValue fontSizeValue, DimensionValue relativeValue) {
        if (!$assertionsDisabled && !ComputedValueHandler.isAbsoluteUnit(fontSizeValue.getUnits())) {
            throw new AssertionError();
        }
        if (!ComputedValueHandler.isAbsoluteUnit(fontSizeValue.getUnits())) {
            throw new IllegalArgumentException("The argument \"fontSizeValue\" should be absolute.");
        }
        if (ComputedValueHandler.isAbsoluteUnit(relativeValue.getUnits())) {
            return relativeValue;
        }
        if ("em".equals(relativeValue.getUnits())) {
            return new DimensionValue(fontSizeValue.getMeasure() * relativeValue.getMeasure(), fontSizeValue.getUnits());
        }
        if ("ex".equals(relativeValue.getUnits())) {
            return new DimensionValue(fontSizeValue.getMeasure() * relativeValue.getMeasure() / 2.0, fontSizeValue.getUnits());
        }
        if ("%".equals(relativeValue.getUnits())) {
            return new DimensionValue(fontSizeValue.getMeasure() * relativeValue.getMeasure() / 100.0, fontSizeValue.getUnits());
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    static boolean isAbsoluteUnit(String unit) {
        return DimensionUtil.isAbsoluteUnit(unit) || "px".equalsIgnoreCase(unit);
    }

    static {
        $assertionsDisabled = !CSSLengthValueHandler.class.desiredAssertionStatus();
        ABSOLUTE_FONT_SIZE_CONSTANTS = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"};
        defaultFontSizeValue = null;
    }
}

