/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Structure;

public class StructureIterator
implements Iterator {
    protected final SimpleValueHandle valueHandle;
    protected final ArrayList list;
    protected int index;

    public StructureIterator(SimpleValueHandle handle) {
        this.valueHandle = handle;
        this.list = this.valueHandle.getListValue();
        this.index = 0;
    }

    public void remove() {
        if (!this.hasNext()) {
            return;
        }
        try {
            this.valueHandle.removeItem(this.index);
        }
        catch (PropertyValueException propertyValueException) {
            // empty catch block
        }
    }

    public boolean hasNext() {
        return this.list != null && this.index < this.list.size();
    }

    public Object next() {
        if (!this.hasNext()) {
            return null;
        }
        CachedMemberRef structRef = new CachedMemberRef(this.valueHandle.getReference(), this.index);
        Structure struct = ((MemberRef)structRef).getStructure(this.valueHandle.getModule(), this.valueHandle.getElement());
        return struct.getHandle(this.valueHandle, this.index++);
    }
}

