/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.core.INameManager;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;

public class NameManager
implements INameManager {
    private static final String GROUP_NAME_PREFIX = "group_";
    private NameSpace[] nameSpaces = new NameSpace[8];
    private Module root = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NameManager(Module module) {
        this.initNameSpaces();
        if (!$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
        this.root = module;
    }

    private void initNameSpaces() {
        for (int i = 0; i < 8; ++i) {
            this.nameSpaces[i] = new NameSpace();
        }
    }

    public void clear() {
        this.initNameSpaces();
    }

    public String getUniqueName(DesignElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof GroupElement) {
            String groupName = this.getUniqueGroupName((GroupElement)element);
            return groupName;
        }
        ElementDefn eDefn = (ElementDefn)element.getDefn();
        String name = StringUtil.trimString(element.getName());
        if (eDefn.getNameOption() == 0) {
            return null;
        }
        if (eDefn.getNameOption() == 1 && name == null && this.root instanceof ReportDesign) {
            return null;
        }
        NameSpace nameSpace = this.getNameSpace(eDefn.getNameSpaceID());
        NameSpace moduleNameSpace = this.root.getNameSpace(eDefn.getNameSpaceID());
        if (name != null && !nameSpace.contains(name) && !moduleNameSpace.contains(name)) {
            return name;
        }
        if (name == null) {
            if (element instanceof ExtendedItem) {
                ExtensionElementDefn extDefn = ((ExtendedItem)element).getExtDefn();
                PeerExtensionElementDefn peerDefn = (PeerExtensionElementDefn)extDefn;
                IReportItemFactory peerFactory = peerDefn.getReportItemFactory();
                if (!$assertionsDisabled && peerFactory == null) {
                    throw new AssertionError();
                }
                String extensionDefaultName = null;
                IMessages msgs = peerFactory.getMessages();
                if (msgs != null) {
                    extensionDefaultName = msgs.getMessage((String)extDefn.getDisplayNameKey(), ThreadResources.getLocale());
                }
                if (StringUtil.isBlank(extensionDefaultName)) {
                    extensionDefaultName = peerDefn.getName();
                }
                name = ModelMessages.getMessage("Message.NamePrefixNew");
                name = name + extensionDefaultName;
            } else {
                name = ModelMessages.getMessage("New." + element.getDefn().getName());
                name = name.trim();
            }
        }
        int index = 0;
        String baseName = name;
        while (nameSpace.contains(name) || moduleNameSpace.contains(name)) {
            name = baseName + ++index;
        }
        return name;
    }

    public void makeUniqueName(DesignElement element) {
        String name = this.getUniqueName(element);
        if (name == null) {
            return;
        }
        if (element instanceof GroupElement) {
            this.setUniqueGroupName((GroupElement)element, name);
            return;
        }
        if (name.equals(element.getName())) {
            return;
        }
        ElementDefn eDefn = (ElementDefn)element.getDefn();
        NameSpace nameSpace = this.getNameSpace(eDefn.getNameSpaceID());
        element.setName(name.trim());
        nameSpace.insert(element);
    }

    public Module getHostModule() {
        return this.root;
    }

    NameSpace getNameSpace(int id) {
        if (!($assertionsDisabled || id >= 0 && id < 8)) {
            throw new AssertionError();
        }
        return this.nameSpaces[id];
    }

    public void dropElement(DesignElement element) {
        if (element == null) {
            return;
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        int id = defn.getNameSpaceID();
        NameSpace ns = this.getNameSpace(id);
        if (ns.getElement(element.getName()) == element) {
            ns.remove(element);
        }
    }

    private String getUniqueGroupName(GroupElement group) {
        if (group == null || group.getContainer() == null) {
            return null;
        }
        ListingHandle listing = (ListingHandle)group.getContainer().getHandle(this.root);
        String groupName = (String)group.getLocalProperty(this.root, "groupName");
        if (StringUtil.isBlank(groupName)) {
            for (GroupElement virtualGroup = (GroupElement)group.getVirtualParent(); virtualGroup != null && StringUtil.isBlank(groupName = (String)virtualGroup.getLocalProperty(virtualGroup.getRoot(), "groupName")); virtualGroup = (GroupElement)virtualGroup.getVirtualParent()) {
            }
        }
        String namePrefix = groupName;
        int level = group.getGroupLevel();
        if (StringUtil.isBlank(namePrefix)) {
            namePrefix = ModelMessages.getMessage("New." + group.getDefn().getName());
            if (StringUtil.isBlank(namePrefix = namePrefix.trim())) {
                namePrefix = GROUP_NAME_PREFIX;
            }
            groupName = namePrefix + level;
        }
        while (GroupNameValidator.getInstance().validateForRenamingGroup(listing, (GroupHandle)group.getHandle(this.root), groupName).size() != 0) {
            groupName = namePrefix + level;
            ++level;
        }
        return groupName;
    }

    private void setUniqueGroupName(GroupElement group, String groupName) {
        if (!$assertionsDisabled && groupName == null) {
            throw new AssertionError();
        }
        String localGroupName = (String)group.getLocalProperty(this.root, "groupName");
        if (groupName.equals(localGroupName)) {
            return;
        }
        group.setProperty("groupName", (Object)groupName);
    }

    static {
        $assertionsDisabled = !NameManager.class.desiredAssertionStatus();
    }
}

