/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.StyleEvent;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencable;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public abstract class ReferenceableElement
extends DesignElement
implements IReferencable {
    protected ArrayList clients = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReferenceableElement() {
    }

    public ReferenceableElement(String theName) {
        super(theName);
    }

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        ReferenceableElement element = (ReferenceableElement)super.doClone(policy);
        element.clients = new ArrayList();
        return element;
    }

    public void addClient(DesignElement client, String propName) {
        this.clients.add(new BackRef(client, propName));
    }

    public void dropClient(DesignElement client) {
        for (int i = 0; i < this.clients.size(); ++i) {
            if (((BackRef)this.clients.get((int)i)).element != client) continue;
            this.clients.remove(i);
            return;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public List getClientList() {
        return new ArrayList(this.clients);
    }

    public boolean hasReferences() {
        return !this.clients.isEmpty();
    }

    public void broadcast(NotificationEvent ev, Module module) {
        super.broadcast(ev, module);
        this.adjustDeliveryPath(ev);
        this.broadcastToClients(ev, module);
    }

    protected abstract void adjustDeliveryPath(NotificationEvent var1);

    protected void broadcastToClients(NotificationEvent ev, Module module) {
        for (int i = 0; i < this.clients.size(); ++i) {
            ((BackRef)this.clients.get((int)i)).element.broadcast(ev, module);
        }
    }

    public void updateClientReferences() {
        Iterator backRefIter = new ArrayList(this.clients).iterator();
        while (backRefIter.hasNext()) {
            BackRef ref = (BackRef)backRefIter.next();
            DesignElement client = ref.element;
            Module root = client.getRoot();
            Object value = client.getLocalProperty(root, ref.propName);
            if (value instanceof ElementRefValue) {
                ElementRefValue refValue = (ElementRefValue)value;
                refValue.unresolved(refValue.getName());
                this.dropClient(client);
            } else if (value instanceof List) {
                List valueList = (List)value;
                for (int i = 0; i < valueList.size(); ++i) {
                    ElementRefValue item = (ElementRefValue)valueList.get(i);
                    if (item.getElement() != this) continue;
                    item.unresolved(item.getName());
                    this.dropClient(client);
                }
            }
            if ("style".equalsIgnoreCase(ref.propName)) {
                client.broadcast(new StyleEvent(client));
                continue;
            }
            client.resolveElementReference(root, client.getPropertyDefn(ref.propName));
        }
    }

    public void clearClients() {
        this.clients = new ArrayList();
    }

    static {
        $assertionsDisabled = !ReferenceableElement.class.desiredAssertionStatus();
    }
}

