/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.ValueRequiredValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.elements.interfaces.IGroupElementModel;
import org.eclipse.birt.report.model.elements.strategy.GroupElementPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;

public abstract class GroupElement
extends DesignElement
implements IGroupElementModel {
    private static final int LEVEL_NOT_SET = -1;
    protected int groupLevel = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GroupElement() {
        this.initSlots();
    }

    public ContainerSlot getSlot(int slot) {
        if (!($assertionsDisabled || slot >= 0 && slot < 2)) {
            throw new AssertionError();
        }
        return this.slots[slot];
    }

    public int getGroupLevel() {
        if (this.container == null) {
            this.groupLevel = -1;
        } else {
            ContainerSlot slot = this.container.getSlot(this.containerSlotID);
            this.groupLevel = slot.findPosn(this) + 1;
        }
        return this.groupLevel;
    }

    public String getSelector(int slotID) {
        String slotSelector;
        IElementDefn defn = this.getDefn();
        SlotDefn slotDefn = (SlotDefn)defn.getSlot(slotID);
        if (slotDefn == null) {
            return null;
        }
        int depth = this.getGroupLevel();
        if (depth > 9) {
            depth = 9;
        }
        if (StringUtil.isBlank(slotSelector = slotDefn.getSelector())) {
            return null;
        }
        return slotSelector + "-" + Integer.toString(depth);
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(this.validateStructureList(module, "sort"));
        list.addAll(this.validateStructureList(module, "filter"));
        list.addAll(ValueRequiredValidator.getInstance().validate(module, this, "keyExpr"));
        return list;
    }

    protected String getNameForDisplayLabel() {
        return (String)this.getLocalProperty(null, "groupName");
    }

    public PropertySearchStrategy getStrategy() {
        return GroupElementPropSearchStrategy.getInstance();
    }

    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        if (!prop.isStyleProperty()) {
            return super.getFactoryProperty(module, prop);
        }
        return this.getStrategy().getPropertyFromElement(module, this, prop);
    }

    static {
        $assertionsDisabled = !GroupElement.class.desiredAssertionStatus();
    }
}

