/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.AbstractPropertyState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;

public class TextPropertyState
extends AbstractPropertyState {
    PropertyDefn propDefn = null;
    PropertyDefn keyPropDefn = null;

    TextPropertyState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    TextPropertyState(ModuleParserHandler theHandler, DesignElement element, IStructure struct) {
        super(theHandler, element);
        this.struct = struct;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.name = attrs.getValue("name");
        if (StringUtil.isBlank(this.name)) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.NAME_REQUIRED")));
            this.valid = false;
            return;
        }
        this.nameValue = this.name.toLowerCase().hashCode();
        String keyName = this.name + "ID";
        if (this.struct != null) {
            this.propDefn = (PropertyDefn)this.struct.getDefn().getMember(this.name);
            this.keyPropDefn = (PropertyDefn)this.struct.getDefn().getMember(keyName);
        } else {
            this.propDefn = this.element.getPropertyDefn(this.name);
            this.keyPropDefn = this.element.getPropertyDefn(keyName);
        }
        if (this.propDefn == null) {
            DesignParserException e = new DesignParserException(new String[]{this.name}, "Error.DesignParserException.UNDEFINED_PROPERTY");
            RecoverableError.dealUndefinedProperty(this.handler, e);
            this.valid = false;
            return;
        }
        if (this.keyPropDefn == null) {
            DesignParserException e = new DesignParserException(new String[]{keyName}, "Error.DesignParserException.UNDEFINED_PROPERTY");
            RecoverableError.dealUndefinedProperty(this.handler, e);
            this.valid = false;
            return;
        }
        String keyValue = attrs.getValue("key");
        if (keyValue == null) {
            return;
        }
        if (this.struct != null) {
            this.setMember(this.struct, this.propDefn.getName(), keyName, keyValue);
        } else {
            this.setProperty(keyName, keyValue);
        }
    }

    public void end() {
        String value = this.text.toString();
        if (this.struct != null) {
            this.setMember(this.struct, this.propDefn.getName(), this.name, value);
        } else {
            this.setProperty(this.name, value);
        }
    }
}

