/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.metadata.UserChoice;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ListPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.parser.StructureState;
import org.eclipse.birt.report.model.parser.TextPropertyState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class UserPropertyStructureState
extends StructureState {
    static /* synthetic */ Class class$org$eclipse$birt$report$model$parser$UserPropertyStructureState;

    UserPropertyStructureState(ModuleParserHandler theHandler, DesignElement element, ArrayList theList) {
        super(theHandler, element);
        this.propDefn = new UserPropertyDefn();
        this.struct = (IStructure)((Object)this.propDefn);
        this.list = theList;
    }

    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.PROPERTY_TAG == tagValue) {
            return new UserPropertyState(this.handler, this.element, this.propDefn, this.struct);
        }
        if (ParserSchemaConstants.LIST_PROPERTY_TAG == tagValue) {
            return new ChoiceStructureListState(this.handler, this.element, this.propDefn, this.struct);
        }
        if (ParserSchemaConstants.TEXT_PROPERTY_TAG == tagValue) {
            return new TextPropertyState(this.handler, this.element, this.struct);
        }
        return super.startElement(tagName);
    }

    public void end() throws SAXException {
        try {
            ((UserPropertyDefn)this.struct).checkUserPropertyDefn(this.handler.getModule(), this.element);
            this.element.addUserPropertyDefn((UserPropertyDefn)this.struct);
        }
        catch (UserPropertyException e) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)e));
        }
        catch (MetaDataException e) {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new UserPropertyException(this.element, ((UserPropertyDefn)this.struct).getName(), "Error.UserPropertyException.INVALID_DEFINITION", e)));
        }
    }

    class UserPropertyState
    extends PropertyState {
        UserPropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
            super(theHandler, element, propDefn, struct);
        }

        public void end() throws SAXException {
            String value = this.text.toString();
            if ("type".equalsIgnoreCase(this.name)) {
                PropertyType typeDefn;
                MetaDataDictionary dictionary = MetaDataDictionary.getInstance();
                if (StringUtil.isBlank(value)) {
                    value = "string";
                }
                if ((typeDefn = dictionary.getPropertyType(value)) == null) {
                    this.handler.getErrorHandler().semanticError((Exception)((Object)new UserPropertyException(this.element, ((UserPropertyDefn)this.struct).getName(), "Error.UserPropertyException.INVALID_TYPE")));
                    return;
                }
                ((UserPropertyDefn)this.struct).setType(typeDefn);
            } else if ("default".equalsIgnoreCase(this.name)) {
                try {
                    Object defaultValue = ((UserPropertyDefn)this.struct).validateValue(this.handler.getModule(), value);
                    ((UserPropertyDefn)this.struct).setDefault(defaultValue);
                }
                catch (PropertyValueException e) {
                    this.handler.getErrorHandler().semanticError((Exception)((Object)new UserPropertyException(this.element, this.name, "Error.UserPropertyException.INVALID_DEFAULT_VALUE", e, new String[]{value, ((UserPropertyDefn)this.struct).getType().getName()})));
                }
            } else {
                super.end();
            }
        }
    }

    class ChoiceTextPropertyState
    extends InnerParseState {
        UserChoice choice;
        String displayNamePropName;
        String resourceKeyValue;

        ChoiceTextPropertyState(UserChoice theChoice) {
            this.choice = null;
            this.displayNamePropName = null;
            this.resourceKeyValue = null;
            this.choice = theChoice;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            this.displayNamePropName = attrs.getValue("name");
            this.resourceKeyValue = attrs.getValue("key");
        }

        public void end() throws SAXException {
            String value = this.text.toString();
            if ("displayName".equalsIgnoreCase(this.displayNamePropName)) {
                this.choice.setDisplayName(value);
                this.choice.setDisplayNameKey(this.resourceKeyValue);
            }
        }
    }

    class ChoicePropertyState
    extends InnerParseState {
        UserChoice choice;
        String choiceName;
        static final /* synthetic */ boolean $assertionsDisabled;

        ChoicePropertyState(UserChoice theChoice) {
            this.choice = null;
            this.choiceName = null;
            this.choice = theChoice;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            this.choiceName = attrs.getValue("name");
        }

        public void end() throws SAXException {
            String value = this.text.toString();
            if ("name".equalsIgnoreCase(this.choiceName)) {
                this.choice.setName(value);
            } else if ("value".equalsIgnoreCase(this.choiceName)) {
                UserPropertyDefn propDefn = (UserPropertyDefn)UserPropertyStructureState.this.struct;
                Object objValue = value;
                if (propDefn.getTypeCode() != 5) {
                    try {
                        objValue = propDefn.validateValue(UserPropertyStructureState.this.handler.getModule(), value);
                    }
                    catch (PropertyValueException e) {
                        UserPropertyStructureState.this.handler.getErrorHandler().semanticError((Exception)((Object)new UserPropertyException(UserPropertyStructureState.this.element, UserPropertyStructureState.this.name, "Error.UserPropertyException.INVALID_CHOICE_VALUE")));
                        return;
                    }
                }
                this.choice.setValue(objValue);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$model$parser$UserPropertyStructureState == null ? (class$org$eclipse$birt$report$model$parser$UserPropertyStructureState = UserPropertyStructureState.class$("org.eclipse.birt.report.model.parser.UserPropertyStructureState")) : class$org$eclipse$birt$report$model$parser$UserPropertyStructureState).desiredAssertionStatus();
        }
    }

    class ChoiceStructureState
    extends InnerParseState {
        ArrayList choices;
        UserChoice choice;

        ChoiceStructureState(ArrayList theChoices) {
            this.choices = null;
            this.choice = new UserChoice(null, null);
            this.choices = theChoices;
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.PROPERTY_TAG == tagValue) {
                return new ChoicePropertyState(this.choice);
            }
            if (ParserSchemaConstants.TEXT_PROPERTY_TAG == tagValue) {
                return new ChoiceTextPropertyState(this.choice);
            }
            return super.startElement(tagName);
        }

        public void end() throws SAXException {
            this.choices.add(this.choice);
        }
    }

    class ChoiceStructureListState
    extends ListPropertyState {
        ChoiceStructureListState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
            super(theHandler, element, propDefn, struct);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String name = attrs.getValue("name");
            if (StringUtil.isBlank(name)) {
                this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.NAME_REQUIRED")));
                this.valid = false;
                return;
            }
            if (!"choices".equalsIgnoreCase(name)) {
                DesignParserException e = new DesignParserException(new String[]{name}, "Error.DesignParserException.UNDEFINED_PROPERTY");
                RecoverableError.dealUndefinedProperty(this.handler, e);
                this.valid = false;
                return;
            }
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.STRUCTURE_TAG == tagValue) {
                return new ChoiceStructureState(this.list);
            }
            return super.startElement(tagName);
        }

        public void end() throws SAXException {
            UserChoice[] choiceArray = new UserChoice[this.list.size()];
            this.list.toArray(choiceArray);
            ((UserPropertyDefn)this.struct).setChoices(choiceArray);
        }
    }

    class InnerParseState
    extends AbstractParseState {
        InnerParseState() {
        }

        public XMLParserHandler getHandler() {
            return UserPropertyStructureState.this.handler;
        }
    }
}

