/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ElementStructureUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean updateStructureFromParent(DesignElement child, DesignElement parent) {
        if (child == null || parent == null) {
            return false;
        }
        if (child.getExtendsElement() != parent) {
            return false;
        }
        Map overriddenValues = ElementStructureUtil.collectPropertyValues(child);
        boolean retValue = ElementStructureUtil.duplicateStructure(parent, child);
        ElementStructureUtil.distributeValues(child, overriddenValues);
        return retValue;
    }

    public static void distributeValues(DesignElement element, Map overriddenValues) {
        if (element == null) {
            return;
        }
        ContentIterator contentIterator = new ContentIterator(element);
        while (contentIterator.hasNext()) {
            List values;
            DesignElement content = (DesignElement)contentIterator.next();
            Long baseId = new Long(content.getID());
            if (overriddenValues == null || overriddenValues.isEmpty() || (values = (List)overriddenValues.get(baseId)) == null || values.isEmpty()) continue;
            for (int i = 0; i < values.size(); ++i) {
                Property prop = (Property)values.get(i);
                if ("style".equals(prop.getName())) {
                    ((StyledElement)content).setStyleName((String)prop.getValue());
                    continue;
                }
                content.setProperty(prop.getName(), prop.getValue());
            }
        }
    }

    public static Map collectPropertyValues(DesignElement element) {
        if (element == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap map = new HashMap();
        Module root = element.getRoot();
        ContentIterator contentIterator = new ContentIterator(element);
        while (contentIterator.hasNext()) {
            DesignElement content = (DesignElement)contentIterator.next();
            Long baseId = new Long(content.getBaseId());
            ArrayList<Property> values = (ArrayList<Property>)map.get(baseId);
            if (values == null) {
                values = new ArrayList<Property>();
                map.put(baseId, values);
            }
            List propDefns = null;
            propDefns = content instanceof ExtendedItem ? ((ExtendedItem)content).getExtDefn().getProperties() : content.getPropertyDefns();
            for (int i = 0; i < propDefns.size(); ++i) {
                String propName;
                Object propValue;
                PropertyDefn propDefn = (PropertyDefn)propDefns.get(i);
                if ("name".equalsIgnoreCase(propDefn.getName()) || "extends".equalsIgnoreCase(propDefn.getName()) || content instanceof ExtendedItem && "extensionName".equalsIgnoreCase(propDefn.getName()) || (propValue = content.getLocalProperty(root, propName = propDefn.getName())) == null) continue;
                if ("style".equals(propName)) {
                    ReferenceValue refValue = (ReferenceValue)propValue;
                    propValue = refValue.getName();
                }
                values.add(new Property(propName, propValue));
            }
        }
        return map;
    }

    private static boolean duplicateStructure(DesignElement source, DesignElement target) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("Element can not be null.");
        }
        IElementDefn defn = source.getDefn();
        if (defn != target.getDefn()) {
            throw new IllegalArgumentException("Two element are not the same type.");
        }
        if (!defn.isContainer()) {
            return true;
        }
        for (int i = 0; i < defn.getSlotCount(); ++i) {
            ContainerSlot sourceSlot = source.getSlot(i);
            ContainerSlot targetSlot = target.getSlot(i);
            targetSlot.clear();
            for (int j = 0; j < sourceSlot.getCount(); ++j) {
                DesignElement sourceContent = sourceSlot.getContent(j);
                DesignElement targetContent = null;
                if (sourceContent instanceof ExtendedItem) {
                    ExtendedItem extendedItem = (ExtendedItem)sourceContent;
                    targetContent = new ExtendedItem(sourceContent.getName());
                    targetContent.setProperty("extensionName", extendedItem.getProperty(extendedItem.getRoot(), "extensionName"));
                } else if (!(sourceContent instanceof OdaDataSet) && !(sourceContent instanceof OdaDataSource)) {
                    targetContent = ModelUtil.newElement(sourceContent.getElementName(), sourceContent.getName());
                }
                if (targetContent == null) continue;
                targetContent.setID(sourceContent.getID());
                targetContent.setBaseId(sourceContent.getID());
                targetSlot.add(targetContent);
                targetContent.setContainer(target, i);
                ElementStructureUtil.duplicateStructure(sourceContent, targetContent);
            }
        }
        if (target instanceof TableItem) {
            ((TableItem)target).refreshRenderModel(target.getRoot());
        }
        return true;
    }

    public static void clearStructure(DesignElement element) {
        if (element == null) {
            return;
        }
        if (element.getDefn().getSlotCount() == 0) {
            return;
        }
        for (int i = 0; i < element.getDefn().getSlotCount(); ++i) {
            ContainerSlot sourceSlot = element.getSlot(i);
            sourceSlot.clear();
        }
    }

    public static void addTheVirualElementsToNamesapce(DesignElement element, Module module) {
        ContentIterator contentIter = new ContentIterator(element);
        while (contentIter.hasNext()) {
            DesignElement virtualElement = (DesignElement)contentIter.next();
            if (virtualElement.getName() == null) continue;
            module.makeUniqueName(virtualElement);
            ElementDefn contentDefn = (ElementDefn)virtualElement.getDefn();
            int id = contentDefn.getNameSpaceID();
            NameSpace ns = module.getNameSpace(id);
            ns.insert(virtualElement);
        }
    }

    public static boolean refreshStructureFromParent(Module module, DesignElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Parent element can not be null.");
        }
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return false;
        }
        return ElementStructureUtil.updateStructureFromParent(element, parent);
    }

    public static Map getIdMap(DesignElement element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, DesignElement> idMap = new HashMap<Long, DesignElement>();
        ContentIterator parentIter = new ContentIterator(parent);
        ContentIterator childIter = new ContentIterator(element);
        while (childIter.hasNext()) {
            DesignElement virtualParent = (DesignElement)parentIter.next();
            DesignElement virtualChild = (DesignElement)childIter.next();
            if (!$assertionsDisabled && virtualChild.getDefn().getName() != virtualChild.getDefn().getName()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && virtualParent.getID() <= 0L) {
                throw new AssertionError();
            }
            idMap.put(new Long(virtualParent.getID()), virtualChild);
        }
        return idMap;
    }

    public static void localizeElement(DesignElement element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return;
        }
        ElementStructureUtil.duplicateProperties(parent, element);
        ContentIterator iter1 = new ContentIterator(parent);
        ContentIterator iter2 = new ContentIterator(element);
        while (iter1.hasNext()) {
            DesignElement virtualParent = (DesignElement)iter1.next();
            DesignElement virtualChild = (DesignElement)iter2.next();
            ElementStructureUtil.duplicateProperties(virtualParent, virtualChild);
        }
    }

    private static void duplicateProperties(DesignElement from, DesignElement to) {
        Iterator iter;
        if (from.getDefn().allowsUserProperties()) {
            iter = from.getUserProperties().iterator();
            while (iter.hasNext()) {
                UserPropertyDefn userPropDefn = (UserPropertyDefn)iter.next();
                to.addUserPropertyDefn(userPropDefn);
            }
        }
        iter = from.getDefn().getProperties().iterator();
        while (iter.hasNext()) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)iter.next();
            String propName = propDefn.getName();
            if ("style".equals(propName) || "extends".equals(propName) || "userProperties".equals(propName) || "refTemplateParameter".equals(propName)) continue;
            Object localValue = to.getLocalProperty(from.getRoot(), propDefn);
            Object parentValue = from.getStrategy().getPropertyFromElement(from.getRoot(), from, propDefn);
            if (localValue != null || parentValue == null) continue;
            Object valueToSet = ModelUtil.copyValue(propDefn, parentValue);
            to.setProperty(propDefn, valueToSet);
        }
    }

    static {
        $assertionsDisabled = !ElementStructureUtil.class.desiredAssertionStatus();
    }

    private static class Property {
        private String name;
        private Object value;

        Property(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        Object getValue() {
            return this.value;
        }
    }
}

