/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.aggregation.SummaryAccumulator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalStdDev
implements IAggregation {
    static /* synthetic */ Class class$org$eclipse$birt$data$engine$aggregation$TotalStdDev;

    public String getName() {
        return "STDDEV";
    }

    public int getType() {
        return 0;
    }

    public boolean[] getParameterDefn() {
        return new boolean[]{true};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private double sum = 0.0;
        private double squareSum = 0.0;
        private int count = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.sum = 0.0;
            this.squareSum = 0.0;
            this.count = 0;
        }

        public void onRow(Object[] args) throws DataException {
            if (!$assertionsDisabled && args.length <= 0) {
                throw new AssertionError();
            }
            if (args[0] != null) {
                try {
                    double value = DataTypeUtil.toDouble((Object)args[0]);
                    this.sum += value;
                    this.squareSum += value * value;
                    ++this.count;
                }
                catch (BirtException e) {
                    throw new DataException("data.engine.DataConversionError", e);
                }
            }
        }

        public Object getSummaryValue() {
            return this.count > 1 ? new Double(Math.sqrt(((double)this.count * this.squareSum - this.sum * this.sum) / (double)(this.count * (this.count - 1)))) : null;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$aggregation$TotalStdDev == null ? (class$org$eclipse$birt$data$engine$aggregation$TotalStdDev = TotalStdDev.class$("org.eclipse.birt.data.engine.aggregation.TotalStdDev")) : class$org$eclipse$birt$data$engine$aggregation$TotalStdDev).desiredAssertionStatus();
        }
    }
}

