/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultObject
implements IResultObject {
    private IResultClass resultClass;
    private Object[] fields;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$eclipse$birt$core$data$DataType$AnyType;

    public ResultObject(IResultClass resultClass, Object[] fields) {
        if (resultClass == null || fields == null) {
            throw new NullPointerException("ResultClass and/or fields should not be null.");
        }
        if (!$assertionsDisabled && resultClass.getFieldCount() != fields.length) {
            throw new AssertionError();
        }
        this.resultClass = resultClass;
        try {
            if (resultClass.hasAnyTYpe()) {
                for (int i = 1; i <= resultClass.getFieldCount(); ++i) {
                    if (!resultClass.getFieldValueClass(i).getName().equals((class$org$eclipse$birt$core$data$DataType$AnyType == null ? ResultObject.class$("org.eclipse.birt.core.data.DataType$AnyType") : class$org$eclipse$birt$core$data$DataType$AnyType).getName()) || fields[i - 1] == null) continue;
                    ((ResultClass)resultClass).getFieldMetaData(i).setDataType(fields[i - 1].getClass());
                }
            }
            this.fields = resultClass.hasClobOrBlob() ? this.convertClobAndBlob(fields, resultClass.getClobFieldIndexes(), resultClass.getBlobFieldIndexes()) : fields;
        }
        catch (DataException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private Object[] convertClobAndBlob(Object[] fields, int[] clobIndex, int[] blobIndex) throws DataException {
        int i;
        for (i = 0; i < clobIndex.length; ++i) {
            if (fields[clobIndex[i]] == null || !(fields[clobIndex[i]] instanceof IClob)) continue;
            fields[clobIndex[i]] = this.getClobValue((IClob)fields[clobIndex[i]]);
        }
        for (i = 0; i < blobIndex.length; ++i) {
            if (fields[blobIndex[i]] == null || !(fields[blobIndex[i]] instanceof IBlob)) continue;
            fields[blobIndex[i]] = this.getBlobValue((IBlob)fields[blobIndex[i]]);
        }
        return fields;
    }

    private String getClobValue(IClob clob) throws DataException {
        try {
            int len = (int)clob.length();
            return clob.getSubString(1L, len);
        }
        catch (OdaException e) {
            throw new DataException("data.engine.opencloberror", e);
        }
    }

    private byte[] getBlobValue(IBlob blob) throws DataException {
        try {
            int len = (int)blob.length();
            return blob.getBytes(1L, len);
        }
        catch (OdaException e) {
            throw new DataException("data.engine.openbloberror", e);
        }
    }

    public IResultClass getResultClass() {
        return this.resultClass;
    }

    public Object getFieldValue(String fieldName) throws DataException {
        int fieldIndex = this.resultClass.getFieldIndex(fieldName);
        if (fieldIndex < 1) {
            throw new DataException("data.engine.InvalidFieldName", fieldName);
        }
        return this.getFieldValue(fieldIndex);
    }

    public Object getFieldValue(int fieldIndex) throws DataException {
        return this.fields[fieldIndex - 1];
    }

    public void setCustomFieldValue(String fieldName, Object value) throws DataException {
        int idx = this.resultClass.getFieldIndex(fieldName);
        this.setCustomFieldValue(idx, value);
    }

    public void setCustomFieldValue(int fieldIndex, Object value) throws DataException {
        if (!this.resultClass.isCustomField(fieldIndex)) {
            throw new DataException("data.engine.InvalidCustomFieldIdx", new Integer(fieldIndex));
        }
        this.fields[fieldIndex - 1] = value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.fields.length * 10);
        for (int i = 0; i < this.fields.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.fields[i] == null ? "null" : this.fields[i].toString());
        }
        return buf.toString();
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof IResultObject)) {
            return false;
        }
        IResultObject ob2 = (IResultObject)ob;
        int fieldCount = this.getResultClass().getFieldCount();
        if (fieldCount != ob2.getResultClass().getFieldCount()) {
            return false;
        }
        for (int i = 0; i < fieldCount; ++i) {
            try {
                Object value1 = this.getFieldValue(i + 1);
                Object value2 = ob2.getFieldValue(i + 1);
                if (CacheUtil.compareObjects(value1, value2) == 0) continue;
                return false;
            }
            catch (DataException e) {
                return false;
            }
        }
        return true;
    }

    static {
        $assertionsDisabled = !ResultObject.class.desiredAssertionStatus();
    }
}

