/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ComplexExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompiler;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.mozilla.javascript.Context;

public class ExpressionCompilerUtil {
    private static final String ROWNUM = "__rownum";

    public static CompiledExpression compile(String expr, Context cx) {
        ExpressionCompiler expressionCompiler = new ExpressionCompiler();
        expressionCompiler.setDataSetMode(true);
        return expressionCompiler.compile(expr, null, cx);
    }

    public static boolean hasColumnRow(String name, ExprManager exprManager) {
        if (name == null) {
            return false;
        }
        if (name.equals(ROWNUM)) {
            return true;
        }
        IScriptExpression expr = (IScriptExpression)exprManager.getExpr(name);
        if (expr == null) {
            return false;
        }
        return ExpressionCompilerUtil.compile(expr.getText(), exprManager);
    }

    public static List extractColumnExpression(IBaseExpression expression) throws DataException {
        if (expression == null) {
            return new ArrayList();
        }
        List columnList = null;
        if (expression instanceof IScriptExpression) {
            columnList = ExpressionCompilerUtil.extractColumnExpression((IScriptExpression)expression);
        } else if (expression instanceof IConditionalExpression) {
            columnList = ExpressionCompilerUtil.extractColumnExpression((IConditionalExpression)expression);
        }
        return columnList;
    }

    public static List extractColumnExpression(IScriptExpression expression) throws DataException {
        ArrayList list = new ArrayList();
        if (expression == null) {
            return list;
        }
        ExpressionCompilerUtil.populateColumnList(list, expression, true);
        return list;
    }

    public static List extractColumnExpression(IConditionalExpression expression) throws DataException {
        ArrayList list = new ArrayList();
        if (expression == null) {
            return list;
        }
        ExpressionCompilerUtil.populateColumnList(list, expression.getExpression(), true);
        ExpressionCompilerUtil.populateColumnList(list, expression.getOperand1(), true);
        ExpressionCompilerUtil.populateColumnList(list, expression.getOperand2(), true);
        return list;
    }

    public static List extractDataSetColumnExpression(IBaseExpression expression) throws DataException {
        List columnList = new ArrayList();
        if (expression == null) {
            return columnList;
        }
        if (expression instanceof IScriptExpression) {
            columnList = ExpressionCompilerUtil.extractDataSetColumnExpression((IScriptExpression)expression);
        } else if (expression instanceof IConditionalExpression) {
            columnList = ExpressionCompilerUtil.extractDataSetColumnExpression((IConditionalExpression)expression);
        }
        return columnList;
    }

    public static List extractDataSetColumnExpression(IConditionalExpression expression) throws DataException {
        ArrayList list = new ArrayList();
        if (expression == null) {
            return list;
        }
        ExpressionCompilerUtil.populateColumnList(list, expression.getExpression(), false);
        ExpressionCompilerUtil.populateColumnList(list, expression.getOperand1(), false);
        ExpressionCompilerUtil.populateColumnList(list, expression.getOperand2(), false);
        return list;
    }

    public static List extractDataSetColumnExpression(IScriptExpression expression) throws DataException {
        ArrayList list = new ArrayList();
        if (expression == null) {
            return list;
        }
        ExpressionCompilerUtil.populateColumnList(list, expression, false);
        return list;
    }

    public static boolean hasAggregationInExpr(IBaseExpression expression) {
        if (expression instanceof IScriptExpression) {
            String text = ((IScriptExpression)expression).getText();
            return ExpressionUtil.hasAggregation((String)text);
        }
        if (expression instanceof IConditionalExpression) {
            String expr = ExpressionCompilerUtil.getExprText(((IConditionalExpression)expression).getExpression());
            String oprand1 = ExpressionCompilerUtil.getExprText(((IConditionalExpression)expression).getOperand1());
            String oprand2 = ExpressionCompilerUtil.getExprText(((IConditionalExpression)expression).getOperand2());
            return ExpressionUtil.hasAggregation((String)expr) || ExpressionUtil.hasAggregation((String)oprand1) || ExpressionUtil.hasAggregation((String)oprand2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidExpressionInQueryFilter(IBaseExpression expression) {
        if (expression instanceof IScriptExpression) {
            String text = ((IScriptExpression)expression).getText();
            Context context = Context.enter();
            AggregateRegistry aggrReg = new AggregateRegistry(){

                public int register(AggregateExpression aggregationExpr) {
                    return -1;
                }
            };
            try {
                ExpressionCompiler expressionCompiler = new ExpressionCompiler();
                CompiledExpression expr = expressionCompiler.compile(text, aggrReg, context);
                boolean bl = ExpressionCompilerUtil.flattenFilterExpression(expr);
                return bl;
            }
            finally {
                Context.exit();
            }
        }
        if (expression instanceof IConditionalExpression) {
            IScriptExpression expr = ((IConditionalExpression)expression).getExpression();
            IScriptExpression oprand1 = ((IConditionalExpression)expression).getOperand1();
            IScriptExpression oprand2 = ((IConditionalExpression)expression).getOperand2();
            return ExpressionCompilerUtil.isValidExpressionInQueryFilter(expr) && ExpressionCompilerUtil.isValidExpressionInQueryFilter(oprand1) && ExpressionCompilerUtil.isValidExpressionInQueryFilter(oprand2);
        }
        return true;
    }

    private static String getExprText(IScriptExpression expr) {
        if (expr != null) {
            return expr.getText();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compile(String expression, ExprManager exprManager) {
        Context context = Context.enter();
        AggregateRegistry aggrReg = new AggregateRegistry(){

            public int register(AggregateExpression aggregationExpr) {
                return -1;
            }
        };
        try {
            ExpressionCompiler expressionCompiler = new ExpressionCompiler();
            CompiledExpression expr = expressionCompiler.compile(expression, aggrReg, context);
            boolean bl = ExpressionCompilerUtil.flattenExpression(expr, exprManager);
            return bl;
        }
        finally {
            Context.exit();
        }
    }

    private static boolean flattenExpression(CompiledExpression expr, ExprManager exprManager) {
        int type = expr.getType();
        switch (type) {
            case 3: {
                Iterator col = ((ComplexExpression)expr).getSubExpressions().iterator();
                while (col.hasNext()) {
                    if (ExpressionCompilerUtil.flattenExpression((CompiledExpression)col.next(), exprManager)) continue;
                    return false;
                }
                break;
            }
            case 1: {
                String columnName = ((ColumnReferenceExpression)expr).getColumnName();
                if (ROWNUM.equals(columnName)) {
                    return true;
                }
                if (exprManager.getExpr(columnName) != null) {
                    String expression = ((IScriptExpression)exprManager.getExpr(columnName)).getText();
                    return ExpressionCompilerUtil.compile(expression, exprManager);
                }
                return false;
            }
            case 2: {
                Iterator args = ((AggregateExpression)expr).getArguments().iterator();
                while (args.hasNext()) {
                    if (ExpressionCompilerUtil.flattenExpression((CompiledExpression)args.next(), exprManager)) continue;
                    return false;
                }
            }
            case 4: 
            case 5: {
                return true;
            }
        }
        return true;
    }

    private static boolean flattenFilterExpression(CompiledExpression expr) {
        int type = expr.getType();
        switch (type) {
            case 3: {
                Iterator col = ((ComplexExpression)expr).getSubExpressions().iterator();
                while (col.hasNext()) {
                    if (ExpressionCompilerUtil.flattenFilterExpression((CompiledExpression)col.next())) continue;
                    return false;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                String aggName = ((AggregateExpression)expr).getAggregation().getName();
                if (ExpressionCompilerUtil.isTopBottomN(aggName)) break;
                return false;
            }
        }
        return true;
    }

    private static boolean isTopBottomN(String aggName) {
        return "ISBOTTOMN".equals(aggName) || "ISBOTTOMNPERCENT".equals(aggName) || "ISTOPN".equals(aggName) || "ISTOPNPERCENT".equals(aggName);
    }

    private static void populateColumnList(List list, IScriptExpression expression, boolean rowMode) throws DataException {
        if (expression != null) {
            List l;
            try {
                l = ExpressionUtil.extractColumnExpressions((String)expression.getText(), (boolean)rowMode);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            for (int i = 0; i < l.size(); ++i) {
                IColumnBinding cb = (IColumnBinding)l.get(i);
                if (list.contains(cb.getResultSetColumnName()) || cb.getOuterLevel() != 0) continue;
                list.add(cb.getResultSetColumnName());
            }
        }
    }
}

