/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.expression.AggregateObject;
import org.eclipse.birt.data.engine.expression.ExpressionInfo;
import org.eclipse.birt.data.engine.expression.MultiPassExpressionCompiler;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.impl.aggregation.JSAggrValueObject;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ExpressionProcessor
implements IExpressionProcessor {
    private List availabeAggrList;
    private DataSetRuntime dataset;
    private ResultSetPopulator rsPopulator;
    private boolean isDataSetMode = true;
    private IResultIterator resultIterator;
    private BaseQuery baseQuery;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExpressionProcessor(DataSetRuntime dataSet) {
        this.dataset = dataSet;
        this.availabeAggrList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateMultiPassExprOnCmp(IComputedColumnsState iccState, boolean useResultSetMeta) throws DataException {
        if (!$assertionsDisabled && iccState == null) {
            throw new AssertionError();
        }
        Context context = Context.enter();
        try {
            int i;
            int exprType = 0;
            int currentGroupLevel = 0;
            MultiPassExpressionCompiler helper = new MultiPassExpressionCompiler(this.rsPopulator, this.baseQuery, this.dataset.getScriptScope(), this.availabeAggrList);
            helper.setDataSetMode(this.isDataSetMode);
            for (i = 0; i < iccState.getCount(); ++i) {
                if (!iccState.isValueAvailable(i)) continue;
                this.compileBaseExpression(iccState.getExpression(i), helper);
                helper.addAvailableCmpColumn(iccState.getName(i));
            }
            for (i = 0; i < iccState.getCount(); ++i) {
                if (iccState.isValueAvailable(i)) continue;
                IBaseExpression baseExpression = iccState.getExpression(i);
                String name = iccState.getName(i);
                if (useResultSetMeta && name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E")) {
                    exprType = 2;
                    currentGroupLevel = this.getCurrentGroupLevel(name, currentGroupLevel, this.rsPopulator.getQuery());
                    iccState.setValueAvailable(i);
                }
                if (baseExpression instanceof IScriptExpression) {
                    ExpressionInfo exprInfo = new ExpressionInfo((IScriptExpression)baseExpression, exprType, currentGroupLevel, useResultSetMeta);
                    baseExpression.setHandle(helper.compileExpression(exprInfo, context));
                } else if (baseExpression instanceof IConditionalExpression) {
                    this.compileConditionalExpression((IConditionalExpression)baseExpression, helper, this.rsPopulator, exprType, currentGroupLevel, context);
                }
                if (exprType == 2) {
                    return;
                }
                if (helper.getExpressionPassLevel() > 1) break;
                iccState.setValueAvailable(i);
            }
            this.calculate(helper);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateMultiPassExprOnGroup(Object[] exprArray, int[] currentGroupLevel, int arrayType) throws DataException {
        if (!$assertionsDisabled && exprArray == null) {
            throw new AssertionError();
        }
        IBaseExpression baseExpression = null;
        Context context = Context.enter();
        MultiPassExpressionCompiler helper = new MultiPassExpressionCompiler(this.rsPopulator, this.baseQuery, this.dataset.getScriptScope(), this.availabeAggrList);
        helper.setDataSetMode(this.isDataSetMode);
        try {
            for (int i = 0; i < exprArray.length; ++i) {
                baseExpression = (IBaseExpression)exprArray[i];
                if (baseExpression instanceof IConditionalExpression) {
                    this.compileConditionalExpression((IConditionalExpression)baseExpression, helper, this.rsPopulator, arrayType, currentGroupLevel[i], context);
                    continue;
                }
                if (!(baseExpression instanceof IScriptExpression)) continue;
                ExpressionInfo exprInfo = new ExpressionInfo((IScriptExpression)baseExpression, arrayType, currentGroupLevel[i], true);
                baseExpression.setHandle(helper.compileExpression(exprInfo, context));
            }
        }
        finally {
            Context.exit();
        }
        this.calculate(helper);
    }

    public boolean hasAggregateExpr(List list) throws DataException {
        boolean hasAggregate = false;
        MultiPassExpressionCompiler helper = new MultiPassExpressionCompiler(this.rsPopulator, this.baseQuery, this.dataset.getScriptScope(), this.availabeAggrList);
        helper.setDataSetMode(this.isDataSetMode);
        IBaseExpression baseExpression = null;
        for (int i = 0; i < list.size(); ++i) {
            baseExpression = (IBaseExpression)list.get(i);
            this.compileBaseExpression(baseExpression, helper);
        }
        hasAggregate = helper.getAggregateStatus();
        this.clear();
        return hasAggregate;
    }

    public boolean hasAggregation(IBaseExpression expression) throws DataException {
        boolean hasAggregate = false;
        MultiPassExpressionCompiler helper = new MultiPassExpressionCompiler(this.rsPopulator, this.baseQuery, null, null);
        helper.setDataSetMode(this.isDataSetMode);
        IBaseExpression baseExpression = expression;
        this.compileBaseExpression(baseExpression, helper);
        hasAggregate = helper.getAggregateStatus();
        this.clear();
        return hasAggregate;
    }

    private void calculate(MultiPassExpressionCompiler helper) throws DataException {
        List aggrList = helper.getAggregateList(1);
        AggregateTable table = helper.getAggregateTable();
        if (aggrList == null || table == null) {
            return;
        }
        if (helper.hasNestedAggregate()) {
            table.calculate(this.resultIterator, this.dataset.getScriptScope(), (JSAggrValueObject)this.dataset.getJSTempAggrValueObject());
        } else {
            table.calculate(this.resultIterator, this.dataset.getScriptScope());
        }
        Scriptable aggrObj = table.getJSAggrValueObject();
        this.dataset.setJSTempAggrValueObject(aggrObj);
        for (int i = 0; i < aggrList.size(); ++i) {
            AggregateObject obj = (AggregateObject)aggrList.get(i);
            obj.setAvailable(true);
            if (this.availabeAggrList == null) {
                this.availabeAggrList = new ArrayList();
            }
            this.availabeAggrList.add(obj);
        }
    }

    private void compileConditionalExpression(IConditionalExpression baseExpression, MultiPassExpressionCompiler helper, ResultSetPopulator rsPopulator, int exprType, int currentGroupLevel, Context context) throws DataException {
        ExpressionInfo exprInfo = null;
        if (baseExpression instanceof IConditionalExpression) {
            IConditionalExpression condition = baseExpression;
            IScriptExpression op = condition.getExpression();
            IScriptExpression op1 = condition.getOperand1();
            IScriptExpression op2 = condition.getOperand2();
            if (op != null) {
                exprInfo = new ExpressionInfo(op, exprType, currentGroupLevel, true);
                op.setHandle(helper.compileExpression(exprInfo, context));
            }
            if (op1 != null) {
                exprInfo = new ExpressionInfo(op1, exprType, currentGroupLevel, true);
                op1.setHandle(helper.compileExpression(op1, context));
            }
            if (op2 != null) {
                exprInfo = new ExpressionInfo(op2, exprType, currentGroupLevel, true);
                op2.setHandle(helper.compileExpression(op2, context));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileBaseExpression(IBaseExpression baseExpression, MultiPassExpressionCompiler helper) throws DataException {
        Context context = Context.enter();
        try {
            if (baseExpression instanceof IConditionalExpression) {
                IConditionalExpression condition = (IConditionalExpression)baseExpression;
                IScriptExpression op = condition.getExpression();
                IScriptExpression op1 = condition.getOperand1();
                IScriptExpression op2 = condition.getOperand2();
                if (op != null) {
                    helper.compileExpression(op, context);
                }
                if (op1 != null) {
                    helper.compileExpression(op1, context);
                }
                if (op2 != null) {
                    helper.compileExpression(op2, context);
                }
            } else if (baseExpression instanceof IScriptExpression) {
                IScriptExpression scriptExpr = (IScriptExpression)baseExpression;
                helper.compileExpression(scriptExpr, context);
            }
        }
        finally {
            Context.exit();
        }
    }

    private int getCurrentGroupLevel(String groupText, int start, BaseQuery query) {
        if (!$assertionsDisabled && groupText == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && query == null) {
            throw new AssertionError();
        }
        IQuery.GroupSpec[] groups = query.getGrouping();
        for (int i = start; i < groups.length; ++i) {
            IQuery.GroupSpec group = groups[i];
            if (!groupText.equals(group.getName()) && !groupText.equals(group.getKeyColumn())) continue;
            return i + 1;
        }
        return -1;
    }

    public Scriptable getScope() {
        return this.dataset.getScriptScope();
    }

    public void setResultSetPopulator(ResultSetPopulator rsPopulator) {
        this.rsPopulator = rsPopulator;
    }

    public void setDataSetMode(boolean isDataSetMode) {
        this.isDataSetMode = isDataSetMode;
    }

    public void setQuery(BaseQuery query) {
        this.baseQuery = query;
    }

    public void setResultIterator(IResultIterator resultIterator) {
        this.resultIterator = resultIterator;
        this.dataset.setResultSet(this.resultIterator, false);
    }

    public void clear() {
        if (this.availabeAggrList != null) {
            this.availabeAggrList.clear();
        }
        this.availabeAggrList = null;
    }

    static {
        $assertionsDisabled = !ExpressionProcessor.class.desiredAssertionStatus();
    }
}

