/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelperInstance;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;

public class ComputedColumnHelper
implements IResultObjectEvent {
    private ComputedColumnHelperInstance dataSetInstance;
    private ComputedColumnHelperInstance resultSetInstance;
    private int currentModel;
    private List allCC;

    ComputedColumnHelper(DataSetRuntime dataSet, List dataSetCCList, List resultSetCCList) {
        this.dataSetInstance = new ComputedColumnHelperInstance(dataSet, dataSetCCList);
        this.resultSetInstance = new ComputedColumnHelperInstance(dataSet, resultSetCCList);
        this.currentModel = 0;
        this.allCC = new ArrayList();
        this.allCC.addAll(dataSetCCList);
        this.allCC.addAll(resultSetCCList);
    }

    private ComputedColumnHelperInstance getCurrentInstance() {
        if (this.currentModel == 0) {
            return this.dataSetInstance;
        }
        if (this.currentModel == 1) {
            return this.resultSetInstance;
        }
        return null;
    }

    public boolean process(IResultObject resultObject, int rowIndex) throws DataException {
        if (this.getCurrentInstance() != null) {
            return this.getCurrentInstance().process(resultObject, rowIndex);
        }
        return true;
    }

    public boolean isComputedColumnExist(int model) {
        if (model == 0) {
            return this.dataSetInstance.getComputedColumnList().size() > 0;
        }
        if (model == 1) {
            return this.resultSetInstance.getComputedColumnList().size() > 0;
        }
        if (model == 2) {
            return this.allCC.size() > 0;
        }
        return false;
    }

    public List getComputedColumnList() {
        if (this.getCurrentInstance() != null) {
            return this.getCurrentInstance().getComputedColumnList();
        }
        return this.allCC;
    }

    public void setRePrepare(boolean rePrepare) {
        if (this.getCurrentInstance() != null) {
            this.getCurrentInstance().setRePrepare(rePrepare);
        }
    }

    public void setModel(int model) {
        this.currentModel = model;
    }
}

