/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.GroupComputedColumn;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;

class ComputedColumnHelperInstance {
    private DataSetRuntime dataSet;
    private List ccList = new ArrayList();
    private IComputedColumn[] computedColumn;
    private int[] columnIndexArray;
    private boolean isPrepared;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ComputedColumnHelperInstance(DataSetRuntime dataSet, List computedColumns) {
        for (int i = 0; i < computedColumns.size(); ++i) {
            this.ccList.add(computedColumns.get(i));
        }
        this.isPrepared = false;
        this.dataSet = dataSet;
    }

    public List getComputedColumnList() {
        return this.ccList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(IResultObject resultObject, int rowIndex) throws DataException {
        logger.entering(ComputedColumnHelper.class.getName(), "process");
        if (!$assertionsDisabled && resultObject == null) {
            throw new AssertionError();
        }
        IResultClass resultClass = resultObject.getResultClass();
        if (!this.isPrepared) {
            this.prepare(resultClass);
        }
        if (this.computedColumn.length == 0) {
            logger.exiting(ComputedColumnHelper.class.getName(), "process");
            return true;
        }
        this.dataSet.setRowObject(resultObject, true);
        this.dataSet.setCurrentRowIndex(rowIndex);
        Context cx = Context.enter();
        try {
            for (int i = 0; i < this.computedColumn.length; ++i) {
                Object value;
                if (this.computedColumn[i].getExpression() != null) {
                    value = null;
                    try {
                        value = this.computedColumn[i].getExpression().getHandle() != null ? ((CompiledExpression)this.computedColumn[i].getExpression().getHandle()).evaluate(cx, this.dataSet.getScriptScope()) : ScriptEvalUtil.evaluateJSAsExpr(cx, this.dataSet.getJSDataSetObject(), ((IScriptExpression)this.computedColumn[i].getExpression()).getText(), "ComputedColumn", 0);
                        if (this.computedColumn[i] instanceof GroupComputedColumn) {
                            try {
                                value = ((GroupComputedColumn)this.computedColumn[i]).calculate(value);
                            }
                            catch (BirtException e) {
                                throw DataException.wrap(e);
                            }
                        }
                        value = DataTypeUtil.convert((Object)value, (Class)resultClass.getFieldValueClass(this.columnIndexArray[i]));
                    }
                    catch (BirtException e) {
                        if (resultClass.wasAnyType(this.columnIndexArray[i])) {
                            throw new DataException("data.engine.possibleMixedDataTypeInColumn");
                        }
                        String fieldName = resultClass.getFieldName(this.columnIndexArray[i]);
                        if (fieldName != null && fieldName.startsWith("_{$TEMP_")) {
                            throw new DataException("data.engine.ScriptResult.WrongDataType", (Throwable)e, new Object[]{resultClass.getFieldValueClass(this.columnIndexArray[i]).getName(), value == null ? value : value.toString()});
                        }
                        throw new DataException("data.engine.CompCol.WrongDataType", (Throwable)e, new Object[]{resultClass.getFieldName(this.columnIndexArray[i]), resultClass.getFieldValueClass(this.columnIndexArray[i]).getName(), value == null ? value : value.toString()});
                    }
                }
                throw new DataException("data.engine.BadCompColExpr", resultObject.getResultClass().getFieldName(this.columnIndexArray[i]));
                resultObject.setCustomFieldValue(this.columnIndexArray[i], value);
            }
        }
        finally {
            Context.exit();
        }
        logger.exiting(ComputedColumnHelper.class.getName(), "process");
        return true;
    }

    public void setRePrepare(boolean rePrepare) {
        this.isPrepared = !rePrepare;
    }

    private void prepare(IResultClass resultClass) throws DataException {
        if (!$assertionsDisabled && resultClass == null) {
            throw new AssertionError();
        }
        ArrayList<Integer> cmptList = new ArrayList<Integer>();
        for (int i = 0; i < this.ccList.size(); ++i) {
            IComputedColumn cmptdColumn = (IComputedColumn)this.ccList.get(i);
            int cmptdColumnIdx = resultClass.getFieldIndex(cmptdColumn.getName());
            if (cmptdColumnIdx < 1 || !resultClass.isCustomField(cmptdColumnIdx)) continue;
            cmptList.add(new Integer(i));
        }
        int size = cmptList.size();
        this.columnIndexArray = new int[size];
        this.computedColumn = new IComputedColumn[size];
        for (int i = 0; i < size; ++i) {
            IComputedColumn cmptdColumn;
            int pos = (Integer)cmptList.get(i);
            this.computedColumn[i] = cmptdColumn = (IComputedColumn)this.ccList.get(pos);
            this.columnIndexArray[i] = resultClass.getFieldIndex(cmptdColumn.getName());
        }
        this.isPrepared = true;
    }

    static {
        $assertionsDisabled = !ComputedColumnHelperInstance.class.desiredAssertionStatus();
        logger = Logger.getLogger(ComputedColumnHelper.class.getName());
    }
}

