/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.IScriptDataSourceDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.DataEngineContextExt;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSourceManager;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.LogUtil;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResults;
import org.eclipse.birt.data.engine.script.JSDataSources;
import org.mozilla.javascript.Scriptable;

public class DataEngineImpl
extends DataEngine {
    private HashMap dataSources = new HashMap();
    private HashMap dataSetDesigns = new HashMap();
    private Scriptable dataSourcesJSObject;
    private DataEngineContext context;
    private DataEngineSession session;
    private DataSourceManager dataSourceManager;
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataEngineImpl(DataEngineContext context) {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        logger.entering(DataEngineImpl.class.getName(), "DataEngineImpl", context);
        this.context = context;
        DataEngineContextExt.getInstance().setTmpdir(context.getTmpdir());
        this.dataSourceManager = new DataSourceManager(logger);
        this.session = new DataEngineSession(context);
        logger.exiting(DataEngineImpl.class.getName(), "DataEngineImpl");
        logger.log(Level.INFO, "Data Engine starts up");
    }

    public DataEngineContext getContext() {
        return this.context;
    }

    public IQueryResults getQueryResults(String queryResultID) throws DataException {
        if (this.context.getMode() != 2) {
            throw new DataException("data.engine.wrongStatus");
        }
        return new QueryResults(this.context, queryResultID);
    }

    public void defineDataSource(IBaseDataSourceDesign dataSource) throws DataException {
        Object existingDefn;
        logger.entering(DataEngineImpl.class.getName(), "defineDataSource", dataSource == null ? null : dataSource.getName());
        if (dataSource == null) {
            NullPointerException e = new NullPointerException("dataSource param cannot be null");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSource", "dataSource param cannot be null", e);
            throw e;
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        String name = dataSource.getName();
        if (name == null || name.length() == 0) {
            IllegalArgumentException e = new IllegalArgumentException("Data source has no name");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSource", "Data source has no name", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, DataEngineImpl.class.getName(), "defineDataSource", "DataEngine.defineDataSource: " + LogUtil.toString(dataSource));
        }
        if ((existingDefn = this.dataSources.get(dataSource.getName())) != null) {
            this.dataSourceManager.addDataSource((DataSourceRuntime)existingDefn);
        }
        DataSourceRuntime newDefn = DataSourceRuntime.newInstance(dataSource, this);
        this.dataSources.put(newDefn.getName(), newDefn);
        logger.exiting(DataEngineImpl.class.getName(), "defineDataSource");
    }

    /*
     * WARNING - void declaration
     */
    public void defineDataSet(IBaseDataSetDesign dataSet) throws DataException {
        logger.entering(DataEngineImpl.class.getName(), "defineDataSet", dataSet == null ? null : dataSet.getName());
        if (dataSet == null) {
            NullPointerException e = new NullPointerException("dataSource param cannot be null");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "dataSource param cannot be null", e);
            throw e;
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "DataEngine has been shutdown", e);
            throw e;
        }
        String name = dataSet.getName();
        if (name == null || name.length() == 0) {
            IllegalArgumentException e = new IllegalArgumentException("Data source has no name");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "Data source has no name", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, DataEngineImpl.class.getName(), "defineDataSet", "DataEngine.defineDataSet: " + LogUtil.toString(dataSet));
        }
        if (!(dataSet instanceof IJointDataSetDesign)) {
            void var5_9;
            Class dSourceClass;
            String dataSourceName = dataSet.getDataSourceName();
            DataSourceRuntime dsource = this.getDataSourceRuntime(dataSourceName);
            if (dsource == null) {
                DataException e = new DataException("data.engine.UndefinedDataSource", dataSourceName);
                logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "Data source {" + dataSourceName + "} is not defined", (Throwable)((Object)e));
                throw e;
            }
            if (dataSet instanceof IOdaDataSetDesign) {
                dSourceClass = IOdaDataSourceDesign.class;
            } else if (dataSet instanceof IScriptDataSetDesign) {
                dSourceClass = IScriptDataSourceDesign.class;
            } else {
                DataException e = new DataException("data.engine.UnsupportedDataSetType");
                logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "Unsupported data set type: " + dataSet.getName(), (Throwable)((Object)e));
                throw e;
            }
            if (!var5_9.isInstance(dsource.getDesign())) {
                DataException e = new DataException("data.engine.UnsupportedDataSourceType", dsource.getName());
                logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "Unsupported data source type: " + dsource.getName(), (Throwable)((Object)e));
                throw e;
            }
        }
        this.dataSetDesigns.put(name, dataSet);
        logger.exiting(DataEngineImpl.class.getName(), "defineDataSet");
    }

    public void clearCache(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        if (dataSource == null || dataSet == null) {
            return;
        }
        DataSetCacheManager dscManager = this.getSession().getDataSetCacheManager();
        if (dscManager == null) {
            return;
        }
        dscManager.clearCache(dataSource, dataSet);
    }

    DataSourceRuntime getDataSourceRuntime(String name) {
        return (DataSourceRuntime)this.dataSources.get(name);
    }

    IBaseDataSetDesign getDataSetDesign(String name) {
        return (IBaseDataSetDesign)this.dataSetDesigns.get(name);
    }

    public IPreparedQuery prepare(IQueryDefinition querySpec) throws DataException {
        return this.prepare(querySpec, null);
    }

    public IPreparedQuery prepare(IQueryDefinition querySpec, Map appContext) throws DataException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(DataEngineImpl.class.getName(), "prepare", LogUtil.toString(querySpec));
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "prepare", "DataEngine has been shutdown", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Start to prepare query: " + LogUtil.toString(querySpec));
        }
        IPreparedQuery result = PreparedQueryUtil.newInstance(this, querySpec, appContext);
        logger.fine("Finished preparing query.");
        logger.exiting(DataEngineImpl.class.getName(), "prepare");
        return result;
    }

    public void closeDataSource(String dataSourceName) throws DataException {
        logger.entering("DataEngineImpl", "closeDataSource", dataSourceName);
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "closeDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        logger.logp(Level.FINE, DataEngineImpl.class.getName(), "closeDataSource", "Close DataSource :" + dataSourceName);
        DataSourceRuntime ds = this.getDataSourceRuntime(dataSourceName);
        if (ds != null) {
            DataEngineImpl.closeDataSource(ds);
        }
        logger.exiting(DataEngineImpl.class.getName(), "closeDataSource");
    }

    private static void closeDataSource(DataSourceRuntime ds) throws DataException {
        if (!$assertionsDisabled && ds == null) {
            throw new AssertionError();
        }
        if (ds.isOpen()) {
            ds.beforeClose();
            ds.closeOdiDataSource();
            ds.afterClose();
        }
    }

    public DataEngineSession getSession() {
        return this.session;
    }

    public void shutdown() {
        logger.entering("DataEngineImpl", "shutdown");
        if (this.dataSources == null) {
            logger.fine("The data engine has already been shutdown");
            return;
        }
        Collection col = this.dataSources.values();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            DataSourceRuntime ds = (DataSourceRuntime)it.next();
            try {
                DataEngineImpl.closeDataSource(ds);
            }
            catch (DataException e) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "The data source (" + ds + ") fails to shut down", (Throwable)((Object)e));
            }
        }
        this.dataSourceManager.close();
        logger.logp(Level.INFO, DataEngineImpl.class.getName(), "shutdown", "Data engine shuts down");
        this.dataSetDesigns = null;
        this.dataSources = null;
        logger.exiting(DataEngineImpl.class.getName(), "shutdown");
    }

    public Scriptable getDataSourcesScriptObject() {
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "closeDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        if (this.dataSourcesJSObject == null) {
            this.dataSourcesJSObject = new JSDataSources(this.dataSources);
        }
        return this.dataSourcesJSObject;
    }

    public IResultMetaData getCachedDataSetMetaData(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        return this.session.getDataSetCacheManager().getCachedResultMetadata(dataSource, dataSet);
    }

    static {
        $assertionsDisabled = !DataEngineImpl.class.desiredAssertionStatus();
        logger = Logger.getLogger(DataEngineImpl.class.getName());
    }
}

