/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;

public class ExprUtil {
    private static final int NULL_EXPRESSION = 0;
    private static final int SCRIPT_EXPRESSION = 1;
    private static final int CONDITIONAL_EXPRESSION = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void saveBaseExpr(DataOutputStream dos, IBaseExpression baseExpr) throws IOException {
        if (baseExpr == null) {
            IOUtil.writeInt((OutputStream)dos, (int)0);
        } else if (baseExpr instanceof IScriptExpression) {
            IOUtil.writeInt((OutputStream)dos, (int)1);
            ExprUtil.saveScriptExpr(dos, (IScriptExpression)baseExpr);
        } else if (baseExpr instanceof IConditionalExpression) {
            IOUtil.writeInt((OutputStream)dos, (int)2);
            IConditionalExpression condExpr = (IConditionalExpression)baseExpr;
            ExprUtil.saveBaseExpr(dos, condExpr.getExpression());
            IOUtil.writeInt((OutputStream)dos, (int)condExpr.getOperator());
            ExprUtil.saveBaseExpr(dos, condExpr.getOperand1());
            ExprUtil.saveBaseExpr(dos, condExpr.getOperand2());
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private static void saveScriptExpr(DataOutputStream dos, IScriptExpression scriptExpr) throws IOException {
        IOUtil.writeString((DataOutputStream)dos, (String)scriptExpr.getText());
        IOUtil.writeInt((OutputStream)dos, (int)scriptExpr.getDataType());
        IOUtil.writeString((DataOutputStream)dos, (String)scriptExpr.getGroupName());
    }

    public static IBaseExpression loadBaseExpr(DataInputStream dis) throws IOException {
        int exprType = IOUtil.readInt((InputStream)dis);
        if (exprType == 0) {
            return null;
        }
        if (exprType == 1) {
            return ExprUtil.loadScriptExpr(dis);
        }
        if (exprType == 2) {
            IScriptExpression expr = (IScriptExpression)ExprUtil.loadBaseExpr(dis);
            int operator = IOUtil.readInt((InputStream)dis);
            IScriptExpression op1 = (IScriptExpression)ExprUtil.loadBaseExpr(dis);
            IScriptExpression op2 = (IScriptExpression)ExprUtil.loadBaseExpr(dis);
            return new ConditionalExpression(expr, operator, op1, op2);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private static IScriptExpression loadScriptExpr(DataInputStream dis) throws IOException {
        ScriptExpression scriptExpr = new ScriptExpression(IOUtil.readString((DataInputStream)dis));
        scriptExpr.setDataType(IOUtil.readInt((InputStream)dis));
        scriptExpr.setGroupName(IOUtil.readString((DataInputStream)dis));
        return scriptExpr;
    }

    public static boolean isEqualExpression(IBaseExpression be, IBaseExpression be2) {
        if (be == be2) {
            return true;
        }
        if (be == null || be2 == null) {
            return false;
        }
        if (be instanceof IScriptExpression && be2 instanceof IScriptExpression) {
            IScriptExpression se = (IScriptExpression)be;
            IScriptExpression se2 = (IScriptExpression)be2;
            return ExprUtil.isEqualExpression2(se, se2);
        }
        if (be instanceof IConditionalExpression && be2 instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)be;
            IConditionalExpression ce2 = (IConditionalExpression)be2;
            return ce.getDataType() == ce2.getDataType() && ce.getOperator() == ce2.getOperator() && ExprUtil.isEqualExpression2(ce.getExpression(), ce2.getExpression()) && ExprUtil.isEqualExpression2(ce.getOperand1(), ce2.getOperand1()) && ExprUtil.isEqualExpression2(ce.getOperand2(), ce2.getOperand2());
        }
        return false;
    }

    private static boolean isEqualExpression2(IScriptExpression se, IScriptExpression se2) {
        if (se == se2) {
            return true;
        }
        if (se == null || se2 == null) {
            return false;
        }
        return se.getDataType() == se2.getDataType() && ExprUtil.isEqualObject(se.getText(), se2.getText());
    }

    private static boolean isEqualObject(Object ob1, Object ob2) {
        if (ob1 == ob2) {
            return true;
        }
        if (ob1 == null || ob2 == null) {
            return false;
        }
        return ob1.equals(ob2);
    }

    public static int hashCode(IBaseExpression be) {
        if (be == null) {
            return 0;
        }
        if (be instanceof IScriptExpression) {
            return ExprUtil.hashCode2((IScriptExpression)be);
        }
        if (be instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)be;
            return ce.getDataType() + ce.getOperator() + ExprUtil.hashCode2(ce.getExpression()) + ExprUtil.hashCode2(ce.getOperand1()) + ExprUtil.hashCode2(ce.getOperand2());
        }
        return 0;
    }

    private static int hashCode2(IScriptExpression se) {
        if (se == null) {
            return 0;
        }
        return se.getDataType() + se.getText().trim().hashCode();
    }

    static {
        $assertionsDisabled = !ExprUtil.class.desiredAssertionStatus();
    }
}

