/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;

public class RowSaveUtil {
    public static Integer EXCEPTION_INDICATOR = new Integer(2147483547);
    private int lastRowIndex;
    private int currentOffset;
    private int rowCount;
    private DataOutputStream rowExprsDos;
    private DataOutputStream rowLenDos;
    private boolean inited;
    private Set exprNameSet;

    RowSaveUtil(int rowCount, OutputStream rowExprsOs, OutputStream rowLenOs, Set exprNameSet) {
        this.rowCount = rowCount;
        this.rowExprsDos = new DataOutputStream(rowExprsOs);
        this.rowLenDos = new DataOutputStream(rowLenOs);
        this.lastRowIndex = -1;
        this.exprNameSet = exprNameSet;
    }

    void saveExprValue(int currIndex, Map valueMap) throws DataException {
        try {
            this.initSave(false);
            this.saveNullRowsBetween(this.lastRowIndex, currIndex);
            int rowBytes = this.saveExprValue(valueMap);
            IOUtil.writeInt((OutputStream)this.rowLenDos, (int)this.currentOffset);
            this.currentOffset += rowBytes;
            this.lastRowIndex = currIndex;
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    private int saveExprValue(Map valueMap) throws DataException {
        ByteArrayOutputStream tempBaos = new ByteArrayOutputStream();
        BufferedOutputStream tempBos = new BufferedOutputStream(tempBaos);
        DataOutputStream tempDos = new DataOutputStream(tempBos);
        try {
            IOUtil.writeInt((OutputStream)tempDos, (int)valueMap.size());
            Iterator it = this.exprNameSet.iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object value = valueMap.get(key);
                if (value instanceof DataException) {
                    value = EXCEPTION_INDICATOR;
                }
                IOUtil.writeObject((DataOutputStream)tempDos, value);
            }
            tempDos.flush();
            tempBos.flush();
            tempBaos.flush();
            byte[] bytes = tempBaos.toByteArray();
            int rowBytes = bytes.length;
            IOUtil.writeRawBytes((DataOutputStream)this.rowExprsDos, (byte[])bytes);
            tempBaos = null;
            tempBos = null;
            tempDos = null;
            return rowBytes;
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    Set getExprNameSet() {
        return this.exprNameSet;
    }

    void saveFinish(int currIndex) throws DataException {
        this.initSave(true);
        try {
            this.saveNullRowsBetween(this.lastRowIndex, currIndex);
            this.rowExprsDos.close();
            this.rowLenDos.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    private void initSave(boolean finish) throws DataException {
        if (this.inited) {
            return;
        }
        this.inited = true;
        try {
            int totalRowCount = this.rowCount;
            IOUtil.writeInt((OutputStream)this.rowExprsDos, (int)totalRowCount);
            HashMap map = new HashMap();
            Iterator it = this.exprNameSet.iterator();
            while (it.hasNext()) {
                Object value = it.next();
                map.put(value, value);
            }
            int rowBytes = this.saveExprValue(map);
            IOUtil.writeInt((OutputStream)this.rowExprsDos, (int)rowBytes);
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    private void saveNullRowsBetween(int lastRowIndex, int currIndex) throws IOException {
        int gapRows = currIndex - lastRowIndex - 1;
        for (int i = 0; i < gapRows; ++i) {
            IOUtil.writeInt((OutputStream)this.rowExprsDos, (int)0);
            IOUtil.writeInt((OutputStream)this.rowLenDos, (int)this.currentOffset);
            this.currentOffset += 4;
        }
    }
}

