/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import java.io.IOException;
import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.ExecutorHelper;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.document.GroupInfoUtil;
import org.eclipse.birt.data.engine.impl.document.RDGroupUtil;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.BaseCachedResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.DummyEventHandler;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprTotalDataResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.RowIndexUtil;
import org.eclipse.birt.data.engine.impl.document.viewing.ViewingUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Scriptable;

public class CachedExprResultSet
extends BaseCachedResultSet {
    private DataEngineSession session;
    private Scriptable jsRowObject;
    private ExecutorHelper executorHelper;

    public CachedExprResultSet(BaseQuery query, IExprDataResultSet exprDataResultSet, RDGroupUtil rdGroupUtil, DataEngineSession session) throws DataException {
        this.resultClass = exprDataResultSet.getResultClass();
        this.rdGroupUtil = rdGroupUtil;
        this.session = session;
        this.doPrepare(query, exprDataResultSet);
        this.next();
    }

    private void doPrepare(BaseQuery query, IExprDataResultSet exprDataResultSet) throws DataException {
        this.smartCache = new SmartCache(new CacheRequest(query.getMaxRows(), query.getFetchEvents(), null, new DummyEventHandler()), new OdiAdapter(exprDataResultSet), this.resultClass, this.session);
        this.updateGroupUtil(this.smartCache);
        this.rowCount = this.smartCache.getCount();
        this.rdGroupUtil.setCacheProvider(this);
        SortSpec sortSpec = ViewingUtil.getSortSpec(null, query.getOrdering(), this.resultClass);
        if (sortSpec != null && sortSpec.length() > 0) {
            int innerGroupLevel = this.rdGroupUtil.getGroupLevel();
            int[] groupRowIndex = this.rdGroupUtil.getGroupStartAndEndIndex(innerGroupLevel);
            this.smartCache = new SmartCache(new CacheRequest(0, null, null, new DummyEventHandler()), new OdiAdapter(new ExprTotalDataResultSet(this.smartCache, this.resultClass, sortSpec, groupRowIndex, this.rowCount, this.session)), this.resultClass, this.session);
        }
        exprDataResultSet.close();
    }

    private void updateGroupUtil(ResultSetCache smartCache) throws DataException {
        int[] validIndex = new int[smartCache.getCount()];
        int indexColumn = this.resultClass.getFieldCount();
        int index = 0;
        while (smartCache.next()) {
            IResultObject resultObject = smartCache.getCurrentResult();
            validIndex[index++] = (Integer)resultObject.getFieldValue(indexColumn);
        }
        smartCache.reset();
        List[] oldGroups = this.rdGroupUtil.getGroups();
        List[] newGroups = GroupInfoUtil.getGroupInfo(oldGroups, validIndex);
        this.rdGroupUtil.setGroups(newGroups);
    }

    public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
        int currIndex = this.getCurrentIndex();
        this.smartCache.moveTo(0);
        this.saveExprResult(streamsWrapper);
        this.smartCache.moveTo(currIndex);
        try {
            this.rdGroupUtil.saveGroupsToStream(streamsWrapper.getStreamForGroupInfo());
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Group Information");
        }
    }

    private void saveExprResult(StreamWrapper streamsWrapper) throws DataException {
        int idColumnPos = ExprMetaUtil.getIdColumnPos(this.resultClass);
        RowIndexUtil rowInfoUtil = new RowIndexUtil(streamsWrapper.getStreamForRowIndexInfo());
        for (int i = 0; i < this.getCount(); ++i) {
            IResultObject resultObject = this.smartCache.getCurrentResult();
            int index = (Integer)resultObject.getFieldValue(idColumnPos);
            rowInfoUtil.write(index);
            this.smartCache.next();
        }
        rowInfoUtil.close();
    }

    public void setJSRowObject(Scriptable jsRowObject) {
        this.jsRowObject = jsRowObject;
    }

    public IExecutorHelper getExecutorHelper() {
        if (this.executorHelper == null) {
            this.executorHelper = new ExecutorHelper(null);
            this.executorHelper.setJSRowObject(this.jsRowObject);
        }
        return this.executorHelper;
    }
}

