/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.adapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.report.engine.adapter.ColumnBinding;
import org.eclipse.birt.report.engine.adapter.IColumnBinding;
import org.eclipse.birt.report.engine.adapter.ITotalExprBindings;
import org.eclipse.birt.report.engine.adapter.ParseIndicator;
import org.eclipse.birt.report.engine.adapter.TotalExprBinding;

public final class ExpressionUtil {
    private static final String TOTAL_PREFIX = "TOTAL_COLUMN_";
    private int totalColumnSuffix = 0;

    public ITotalExprBindings prepareTotalExpressions(List exprs) {
        return this.prepareTotalExpressions(exprs, null);
    }

    public ITotalExprBindings prepareTotalExpressions(List exprs, String groupName) {
        TotalExprBinding result = new TotalExprBinding();
        ArrayList l = new ArrayList();
        for (int i = 0; i < exprs.size(); ++i) {
            Object key = exprs.get(i);
            result.addColumnBindings(l);
            if (key instanceof String) {
                String expr = key == null ? null : key.toString();
                String newExpr = this.prepareTotalExpression(expr, l, groupName);
                result.addColumnBindings(l);
                result.addNewExpression(newExpr);
                continue;
            }
            if (key instanceof IConditionalExpression) {
                this.addConditionalExprBindings(result, (IConditionalExpression)key, l, groupName);
                continue;
            }
            if (key != null) continue;
            result.addNewExpression(null);
        }
        return result;
    }

    public static IConditionalExpression transformConditionalExpression(IConditionalExpression ce) {
        String prefix = null;
        switch (ce.getOperator()) {
            case 14: {
                prefix = "Total.isTopN";
                break;
            }
            case 16: {
                prefix = "Total.isTopNPercent";
                break;
            }
            case 15: {
                prefix = "Total.isBottomN";
                break;
            }
            case 17: {
                prefix = "Total.isBottomNPercent";
            }
        }
        if (prefix != null) {
            ce = new ConditionalExpression(prefix + "(" + ce.getExpression().getText() + "," + ce.getOperand1().getText() + ")", 11);
        }
        return ce;
    }

    private void addConditionalExprBindings(TotalExprBinding result, IConditionalExpression key, List bindings, String groupName) {
        IConditionalExpression ce = key;
        if (groupName != null) {
            ce.setGroupName(groupName);
        }
        String bindingName = TOTAL_PREFIX + this.totalColumnSuffix;
        ++this.totalColumnSuffix;
        ColumnBinding columnBinding = new ColumnBinding(bindingName, (IBaseExpression)ce);
        ArrayList<ColumnBinding> allColumnBindings = new ArrayList<ColumnBinding>();
        allColumnBindings.add(columnBinding);
        result.addColumnBindings(allColumnBindings);
        result.addNewExpression(org.eclipse.birt.core.data.ExpressionUtil.createJSRowExpression((String)bindingName));
    }

    private String prepareTotalExpression(String oldExpression, List columnBindings, String groupName) {
        if (oldExpression == null) {
            return null;
        }
        char[] chars = oldExpression.toCharArray();
        if (chars.length < 8) {
            return oldExpression;
        }
        ParseIndicator indicator = new ParseIndicator(0, 0, false, false, true, true);
        for (int i = 0; i < chars.length; ++i) {
            if ((i = (indicator = ExpressionUtil.getParseIndicator(chars, i, indicator.omitNextQuote(), indicator.getCandidateKey1(), indicator.getCandidateKey2())).getNewIndex()) < indicator.getRetrieveSize() + 6 || !indicator.isCandidateKey() || chars[i - indicator.getRetrieveSize() - 6] != 'T' || chars[i - indicator.getRetrieveSize() - 5] != 'o' || chars[i - indicator.getRetrieveSize() - 4] != 't' || chars[i - indicator.getRetrieveSize() - 3] != 'a' || chars[i - indicator.getRetrieveSize() - 2] != 'l' || chars[i - indicator.getRetrieveSize() - 1] != '.' || i - indicator.getRetrieveSize() - 7 > 0 && !ExpressionUtil.isValidProceeding(chars[i - indicator.getRetrieveSize() - 7])) continue;
            String firstPart = oldExpression.substring(0, i - indicator.getRetrieveSize() - 6);
            int startIndex = i - indicator.getRetrieveSize() - 6;
            i = ExpressionUtil.advanceToNextValidEncloser(chars, i);
            String secondPart = "";
            String name = "";
            String expr = "";
            if (i < chars.length) {
                int endIndex = i + 1;
                expr = oldExpression.substring(startIndex, endIndex);
                secondPart = this.prepareTotalExpression(oldExpression.substring(i + 1 - indicator.getRetrieveSize()), columnBindings, groupName);
            } else {
                expr = oldExpression.substring(startIndex);
            }
            boolean shouldAddToList = true;
            for (int j = 0; j < columnBindings.size(); ++j) {
                IBaseExpression expression = ((IColumnBinding)columnBindings.get(j)).getBoundExpression();
                if (!(expression instanceof IScriptExpression) || !oldExpression.equals(((IScriptExpression)expression).getText())) continue;
                shouldAddToList = false;
                name = ((IColumnBinding)columnBindings.get(j)).getResultSetColumnName();
                break;
            }
            if (shouldAddToList) {
                name = TOTAL_PREFIX + this.totalColumnSuffix;
                ++this.totalColumnSuffix;
                columnBindings.add(new ColumnBinding(name, expr, groupName));
            }
            String newExpression = firstPart + org.eclipse.birt.core.data.ExpressionUtil.createJSRowExpression((String)name) + secondPart;
            return newExpression;
        }
        return oldExpression;
    }

    private static int advanceToNextValidEncloser(char[] chars, int i) {
        boolean isTotalConstants = true;
        int numberOfOpenBracket = 0;
        while (i < chars.length) {
            ParseIndicator pid = ExpressionUtil.getParseIndicator(chars, i, false, true, true);
            i = pid.getNewIndex();
            if (pid.isCandidateKey() && chars[i] == '(') {
                isTotalConstants = false;
                ++numberOfOpenBracket;
            }
            if (isTotalConstants) {
                if (ExpressionUtil.isValidProceeding(chars[i])) break;
                ++i;
                continue;
            }
            if (chars[i] != ')') {
                ++i;
                continue;
            }
            if (chars[i] == ')') {
                --numberOfOpenBracket;
            }
            if (numberOfOpenBracket == 0) break;
            ++i;
        }
        if (isTotalConstants) {
            --i;
        }
        return i;
    }

    private static ParseIndicator getParseIndicator(char[] chars, int i, boolean omitNextQuote, boolean candidateKey1, boolean candidateKey2) {
        int retrieveSize = 0;
        if (chars[i] == '/') {
            if (i > 0 && chars[i - 1] == '/') {
                ++retrieveSize;
                while (i < chars.length - 2) {
                    ++retrieveSize;
                    if (chars[++i] != '\n') continue;
                }
                ++retrieveSize;
                ++i;
            }
        } else if (chars[i] == '*' && i > 0 && chars[i - 1] == '/') {
            ++i;
            retrieveSize += 2;
            while (i < chars.length - 2) {
                ++retrieveSize;
                if (chars[++i - 1] != '*' || chars[i] != '/') continue;
            }
            ++retrieveSize;
            ++i;
        }
        if (!omitNextQuote && chars[i] == '\"') {
            boolean bl = candidateKey1 = !candidateKey1;
            if (candidateKey1) {
                candidateKey2 = true;
            }
        }
        if (!omitNextQuote && chars[i] == '\'') {
            boolean bl = candidateKey2 = !candidateKey2;
            if (candidateKey2) {
                candidateKey1 = true;
            }
        }
        omitNextQuote = chars[i] == '\\';
        return new ParseIndicator(retrieveSize, i, candidateKey1, omitNextQuote, candidateKey1, candidateKey2);
    }

    private static boolean isValidProceeding(char operator) {
        return !(operator >= 'A' && operator <= 'Z' || operator >= 'a' && operator <= 'z') && operator != '_';
    }
}

