/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.api.impl.ResultSetItem;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.data.dte.DteDataEngine;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.mozilla.javascript.Scriptable;

public class DataExtractionTaskV1
extends EngineTask
implements IDataExtractionTask {
    protected IReportDocument reportDocReader;
    protected Report report;
    protected InstanceID instanceId;
    protected String resultSetName;
    protected String[] selectedColumns;
    protected IExtractionResults currentResult = null;
    protected IFilterDefinition[] filterExpressions = null;
    protected boolean isMetaDataPrepared = false;
    protected HashMap rsetName2IdMapping = new HashMap();
    protected HashMap rsetId2queryIdMapping = new HashMap();
    protected HashMap queryId2NameMapping = new HashMap();
    protected HashMap queryId2QueryMapping = new HashMap();
    protected ArrayList resultMetaList = new ArrayList();
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataExtractionTaskV1(IReportEngine engine, IReportRunnable runnable, IReportDocument reader) throws EngineException {
        super(engine, runnable);
        this.report = ((ReportRunnable)runnable).getReportIR();
        this.reportDocReader = reader;
        this.executionContext.setReportDocument(this.reportDocReader);
        this.executionContext.setFactoryMode(false);
        this.executionContext.setPresentationMode(true);
        this.setParameterValues(this.reportDocReader.getParameterValues());
        this.usingParameterValues();
        this.executionContext.registerGlobalBeans(this.reportDocReader.getGlobalVariables(null));
        IDataEngine dataEngine = this.executionContext.getDataEngine();
        dataEngine.prepare(this.report, this.appContext);
    }

    private void prepareMetaData() {
        if (this.isMetaDataPrepared) {
            return;
        }
        HashMap queryIds = this.report.getQueryIDs();
        HashMap query2itemMapping = this.report.getReportItemToQueryMap();
        Iterator iter = queryIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IBaseQueryDefinition baseQuery = (IBaseQueryDefinition)entry.getKey();
            if (!(baseQuery instanceof IQueryDefinition)) continue;
            IQueryDefinition query = (IQueryDefinition)baseQuery;
            String queryId = (String)entry.getValue();
            ReportItemDesign item = (ReportItemDesign)query2itemMapping.get(query);
            String queryName = item.getName();
            if (queryName == null) {
                queryName = "ELEMENT_" + item.getID();
            }
            this.queryId2NameMapping.put(queryId, queryName);
            this.queryId2QueryMapping.put(queryId, query);
        }
        try {
            this.loadResultSetMetaData();
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        this.isMetaDataPrepared = true;
    }

    private String getQueryName(String queryId) {
        return (String)this.queryId2NameMapping.get(queryId);
    }

    private IQueryDefinition getQuery(String queryId) {
        return (IQueryDefinition)this.queryId2QueryMapping.get(queryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResultSetMetaData() throws EngineException {
        block9: {
            try {
                IDocArchiveReader reader = this.reportDocReader.getArchive();
                if (reader.exists("/Data/snap_hierarchy")) {
                    RAInputStream in = reader.getStream("/Data/snap_hierarchy");
                    try {
                        this.loadResultSetMetaData((InputStream)in);
                        break block9;
                    }
                    finally {
                        in.close();
                    }
                }
                if (!reader.exists("/Data/hierarchy")) break block9;
                RAInputStream in = reader.getStream("/Data/hierarchy");
                try {
                    this.loadResultSetMetaData((InputStream)in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private void loadResultSetMetaData(InputStream in) throws IOException {
        try {
            HashMap query2ResultMetaData = this.report.getResultMetaData();
            DataInputStream dis = new DataInputStream(in);
            HashMap<String, Integer> queryCounts = new HashMap<String, Integer>();
            while (true) {
                ResultMetaData metaData;
                IOUtil.readString((DataInputStream)dis);
                IOUtil.readLong((DataInputStream)dis);
                String queryId = IOUtil.readString((DataInputStream)dis);
                String rsetId = IOUtil.readString((DataInputStream)dis);
                IQueryDefinition query = this.getQuery(queryId);
                this.rsetId2queryIdMapping.put(rsetId, queryId);
                int count = -1;
                Integer countObj = (Integer)queryCounts.get(queryId);
                if (countObj != null) {
                    count = countObj;
                }
                String rsetName = this.getQueryName(queryId);
                if (++count > 0) {
                    rsetName = rsetName + "_" + count;
                }
                queryCounts.put(queryId, new Integer(count));
                this.rsetName2IdMapping.put(rsetName, rsetId);
                if (null == query2ResultMetaData || (metaData = (ResultMetaData)query2ResultMetaData.get(query)).getColumnCount() <= 0) continue;
                ResultSetItem resultItem = new ResultSetItem(rsetName, metaData);
                this.resultMetaList.add(resultItem);
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    InstanceID[] getAncestors(InstanceID id) {
        LinkedList<InstanceID> iids = new LinkedList<InstanceID>();
        while (id != null) {
            iids.addFirst(id);
            id = id.getParentID();
        }
        return iids.toArray(new InstanceID[0]);
    }

    IResultSet executeQuery(IResultSet prset, InstanceID iid) throws BirtException {
        IBaseQueryDefinition query;
        long id;
        ReportItemDesign design;
        DataID dataId = iid.getDataID();
        if (dataId != null && prset != null) {
            prset.skipTo(dataId.getRowID());
        }
        if ((design = (ReportItemDesign)this.report.getReportItemByID(id = iid.getComponentID())) != null && (query = design.getQuery()) != null) {
            return this.executionContext.getDataEngine().execute(prset, query);
        }
        return prset;
    }

    protected String instanceId2RsetName(InstanceID iid) {
        int i;
        InstanceID[] iids = this.getAncestors(iid);
        ArrayList<IResultSet> rsets = new ArrayList<IResultSet>();
        IResultSet prset = null;
        IResultSet rset = null;
        String rsetName = null;
        try {
            for (i = 0; i < iids.length; ++i) {
                rset = this.executeQuery(prset, iids[i]);
                if (rset != null && rset != prset) {
                    rsets.add(rset);
                }
                prset = rset;
            }
            if (rset != null) {
                rsetName = rset.getID().getDataSetName();
            }
        }
        catch (BirtException ex) {
            logger.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        for (i = 0; i < rsets.size(); ++i) {
            rset = (IResultSet)rsets.get(i);
            rset.close();
        }
        if (rsetName != null) {
            return this.rsetId2Name(rsetName);
        }
        return rsetName;
    }

    protected String queryId2rsetId(String id) {
        Iterator iter = this.rsetId2queryIdMapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String queryId = (String)entry.getValue();
            String rsetId = (String)entry.getKey();
            if (!queryId.equals(id)) continue;
            return rsetId;
        }
        return null;
    }

    protected String rsetId2Name(String id) {
        Iterator iter = this.rsetName2IdMapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String rsetId = (String)entry.getValue();
            String rsetName = (String)entry.getKey();
            if (!rsetId.equals(id)) continue;
            return rsetName;
        }
        return null;
    }

    protected String rsetName2Id(String name) {
        return (String)this.rsetName2IdMapping.get(name);
    }

    public void setInstanceID(InstanceID iid) {
        if (!$assertionsDisabled && iid == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        this.instanceId = iid;
        this.resultSetName = null;
        this.selectedColumns = null;
    }

    public void selectResultSet(String displayName) {
        if (!$assertionsDisabled && displayName == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        if (displayName.startsWith("InstanceId:")) {
            this.resultSetName = null;
            this.instanceId = InstanceID.parse(displayName.substring(11));
        } else {
            this.resultSetName = displayName;
            this.instanceId = null;
        }
        this.selectedColumns = null;
    }

    public List getMetaData() throws EngineException {
        return this.getResultSetList();
    }

    public List getResultSetList() throws EngineException {
        this.prepareMetaData();
        if (this.instanceId != null) {
            ArrayList<ResultSetItem> rsetList = new ArrayList<ResultSetItem>();
            IResultMetaData metaData = this.getMetaDateByInstanceID(this.instanceId);
            if (metaData != null) {
                rsetList.add(new ResultSetItem("InstanceId:" + this.instanceId.toUniqueString(), metaData));
            }
            return rsetList;
        }
        return this.resultMetaList;
    }

    protected IResultMetaData getResultMetaData(String rsetName) {
        Iterator iter = this.resultMetaList.iterator();
        while (iter.hasNext()) {
            IResultSetItem rsetItem = (IResultSetItem)iter.next();
            if (!rsetItem.getResultSetName().equals(rsetName)) continue;
            return rsetItem.getResultMetaData();
        }
        return null;
    }

    public void selectColumns(String[] columnNames) {
        this.selectedColumns = columnNames;
    }

    public IExtractionResults extract() throws EngineException {
        try {
            String rsetName = this.resultSetName;
            if (rsetName == null && this.instanceId != null) {
                rsetName = this.instanceId2RsetName(this.instanceId);
            }
            if (rsetName != null) {
                return this.extractByResultSetName(rsetName);
            }
            if (this.instanceId != null) {
                return this.extractByInstanceID(this.instanceId);
            }
            return null;
        }
        catch (BirtException ex) {
            throw new EngineException(ex.getLocalizedMessage(), ex);
        }
    }

    private IExtractionResults extractByResultSetName(String rsetName) throws BirtException {
        if (!$assertionsDisabled && rsetName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.executionContext.getDataEngine() == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        DataEngine dataEngine = this.executionContext.getDataEngine().getDataEngine();
        String rsetId = this.rsetName2Id(rsetName);
        if (rsetId != null) {
            IResultMetaData metaData;
            IQueryResults results = null;
            if (null == this.filterExpressions) {
                results = dataEngine.getQueryResults(rsetId);
            } else {
                String queryId = (String)this.rsetId2queryIdMapping.get(rsetId);
                QueryDefinition query = (QueryDefinition)this.getQuery(queryId);
                QueryDefinition newQuery = this.cloneQuery(query);
                if (null == newQuery) {
                    return null;
                }
                for (int iNum = 0; iNum < this.filterExpressions.length; ++iNum) {
                    newQuery.getFilters().add(this.filterExpressions[iNum]);
                }
                this.filterExpressions = null;
                newQuery.setQueryResultsID(rsetId);
                Scriptable scope = this.executionContext.getSharedScope();
                IPreparedQuery preparedQuery = dataEngine.prepare((IQueryDefinition)newQuery);
                results = preparedQuery.execute(scope);
            }
            if (null != results && (metaData = this.getResultMetaData(rsetName)) != null) {
                return new ExtractionResults(results, metaData, this.selectedColumns);
            }
        }
        return null;
    }

    private IExtractionResults extractByInstanceID(InstanceID instanceId) throws BirtException {
        for (InstanceID iid = instanceId; iid != null; iid = iid.getParentID()) {
            long id = iid.getComponentID();
            ReportItemDesign design = (ReportItemDesign)this.report.getReportItemByID(id);
            IBaseQueryDefinition query = design.getQuery();
            if (query == null) continue;
            if (this.filterExpressions != null) {
                query = this.cloneQuery(query);
                for (int i = 0; i < this.filterExpressions.length; ++i) {
                    query.getFilters().add(this.filterExpressions[i]);
                }
            }
            while (iid != null) {
                DataID dataId = iid.getDataID();
                if (dataId != null) {
                    DataSetID dataSetId = dataId.getDataSetID();
                    long rowId = dataId.getRowID();
                    IResultIterator dataIter = this.executeSubQuery(dataSetId, rowId, (ISubqueryDefinition)query);
                    IResultMetaData metaData = this.getMetaDateByInstanceID(instanceId);
                    if (dataIter != null && metaData != null) {
                        return new ExtractionResults(dataIter, metaData, this.selectedColumns);
                    }
                    return null;
                }
                iid = iid.getParentID();
            }
            return null;
        }
        return null;
    }

    private IResultMetaData getMetaDateByInstanceID(InstanceID iid) {
        while (iid != null) {
            long id = iid.getComponentID();
            ReportItemDesign design = (ReportItemDesign)this.report.getReportItemByID(id);
            IBaseQueryDefinition query = design.getQuery();
            if (query != null) {
                HashMap query2ResultMetaData = this.report.getResultMetaData();
                if (null != query2ResultMetaData) {
                    return (ResultMetaData)query2ResultMetaData.get(query);
                }
                return null;
            }
            iid = iid.getParentID();
        }
        return null;
    }

    private IResultIterator executeQuery(String rset, QueryDefinition query) throws BirtException {
        query.setQueryResultsID(rset);
        DataEngine dataEngine = this.executionContext.getDataEngine().getDataEngine();
        Scriptable scope = this.executionContext.getSharedScope();
        Map appContext = this.executionContext.getAppContext();
        dataEngine.prepare((IQueryDefinition)query, appContext);
        IPreparedQuery pQuery = dataEngine.prepare((IQueryDefinition)query);
        IQueryResults results = pQuery.execute(scope);
        return results.getResultIterator();
    }

    private IResultIterator executeSubQuery(DataSetID dataSet, long rowId, ISubqueryDefinition query) throws BirtException {
        IResultIterator rsetIter = null;
        String rset = dataSet.getDataSetName();
        rsetIter = rset != null ? this.executeQuery(rset, (QueryDefinition)query.getParentQuery()) : this.executeSubQuery(dataSet.getParentID(), dataSet.getRowID(), (ISubqueryDefinition)query.getParentQuery());
        rsetIter.moveTo((int)rowId);
        String queryName = query.getName();
        Scriptable scope = this.executionContext.getSharedScope();
        return rsetIter.getSecondaryIterator(queryName, scope);
    }

    private BaseQueryDefinition cloneQuery(IBaseQueryDefinition query) {
        if (query instanceof SubqueryDefinition) {
            return this.cloneQuery((SubqueryDefinition)query);
        }
        if (query instanceof QueryDefinition) {
            return this.cloneQuery((QueryDefinition)query);
        }
        return null;
    }

    private SubqueryDefinition cloneQuery(SubqueryDefinition query) {
        BaseQueryDefinition parent = this.cloneQuery(query.getParentQuery());
        SubqueryDefinition newQuery = new SubqueryDefinition(query.getName(), parent);
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getSubqueries().addAll(query.getSubqueries());
        newQuery.getResultSetExpressions().putAll(query.getResultSetExpressions());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        newQuery.setMaxRows(query.getMaxRows());
        parent.getSubqueries().add(newQuery);
        return newQuery;
    }

    private QueryDefinition cloneQuery(QueryDefinition query) {
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getResultSetExpressions().putAll(query.getResultSetExpressions());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        newQuery.setMaxRows(query.getMaxRows());
        newQuery.setDataSetName(query.getDataSetName());
        newQuery.setAutoBinding(query.needAutoBinding());
        newQuery.setColumnProjection(query.getColumnProjection());
        return newQuery;
    }

    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.filterExpressions = simpleFilterExpression;
    }

    static {
        $assertionsDisabled = !DataExtractionTaskV1.class.desiredAssertionStatus();
        logger = Logger.getLogger(DteDataEngine.class.getName());
    }
}

