/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;

public class ParameterDefnBase
implements IParameterDefnBase,
Cloneable {
    private static final String SCALAR = "scalar";
    private static final String FILTER = "filter";
    private static final String LIST = "list";
    private static final String TABLE = "table";
    private static final String GROUP = "group";
    protected int parameterType;
    protected String displayName;
    protected String displayNameKey;
    protected String helpText;
    protected String helpTextKey;
    protected String name;
    protected String promptTextKey;
    protected String promptText;
    protected Map customProperties = new HashMap();
    protected String typeName;
    protected ReportDesignHandle reportDesignHandle;
    protected Locale locale = null;
    protected ReportElementHandle handle = null;

    public void setReportDesign(ReportDesignHandle reportDesignHandle) {
        this.reportDesignHandle = reportDesignHandle;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(int parameterType) {
        this.parameterType = parameterType;
        switch (parameterType) {
            case 1: {
                this.typeName = FILTER;
                break;
            }
            case 2: {
                this.typeName = LIST;
                break;
            }
            case 3: {
                this.typeName = TABLE;
                break;
            }
            case 4: {
                this.typeName = GROUP;
                break;
            }
            default: {
                this.typeName = SCALAR;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        if (this.displayNameKey == null) {
            return this.displayName;
        }
        String ret = this.reportDesignHandle.getMessage(this.displayNameKey, this.locale == null ? Locale.getDefault() : this.locale);
        if (ret == null || ret.length() == 0) {
            return this.displayName;
        }
        return ret;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDisplayNameKey(String displayNameKey) {
        this.displayNameKey = displayNameKey;
    }

    public String getHelpText() {
        if (this.helpTextKey == null) {
            return this.helpText;
        }
        String ret = this.reportDesignHandle.getMessage(this.helpTextKey, this.locale == null ? Locale.getDefault() : this.locale);
        if (ret == null || ret.length() == 0) {
            return this.helpText;
        }
        return ret;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public void setHelpTextKey(String helpTextKey) {
        this.helpTextKey = helpTextKey;
    }

    public void setPromptTextKey(String promptTextKey) {
        this.promptTextKey = promptTextKey;
    }

    public Map getUserPropertyValues() {
        return null;
    }

    public String getUserPropertyValue(String name) {
        Object value;
        if (this.customProperties.containsKey(name) && (value = this.customProperties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void addUserProperty(String name, Object value) {
        this.customProperties.put(name, value);
    }

    public ReportElementHandle getHandle() {
        return this.handle;
    }

    public void setHandle(ReportElementHandle handle) {
        this.handle = handle;
    }

    public String getPromptText() {
        if (this.promptTextKey == null) {
            return this.promptText;
        }
        Locale theLocale = this.locale == null ? Locale.getDefault() : this.locale;
        return this.handle.getExternalizedValue("promptTextID", "promptText", theLocale);
    }

    public void setPromptText(String promptText) {
        this.promptText = promptText;
    }
}

