/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.engine.api.script.element.IReportDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.parser.ReportParser;
import org.eclipse.birt.report.engine.script.internal.element.ReportDesign;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

public class ReportRunnable
implements IReportRunnable {
    protected ReportDesignHandle designHandle;
    protected Report reportIR;
    protected String reportName;
    protected IReportEngine engine = null;

    ReportRunnable(ReportDesignHandle designHandle) {
        this.designHandle = designHandle;
    }

    public void setReportName(String name) {
        this.reportName = name;
    }

    public String getReportName() {
        return this.reportName;
    }

    public ReportDesignHandle getReport() {
        return this.designHandle;
    }

    public IImage getImage(String name) {
        EmbeddedImage embeddedImage = this.designHandle.findImage(name);
        if (embeddedImage != null) {
            Image image = new Image(embeddedImage.getData(this.designHandle.getModule()), name);
            image.setReportRunnable(this);
            return image;
        }
        return null;
    }

    public Object getProperty(String propertyName) {
        FactoryPropertyHandle handle = this.getDesignHandle().getFactoryPropertyHandle(propertyName);
        if (handle != null) {
            return handle.getStringValue();
        }
        return null;
    }

    public Object getProperty(String path, String propertyName) {
        return null;
    }

    public DesignElementHandle getDesignHandle() {
        return this.designHandle;
    }

    public Collection getParameterDefns(boolean includeParameterGroups) {
        ArrayList params = new ReportParser(this.engine).getParameters(this.designHandle, includeParameterGroups);
        return params;
    }

    public HashMap getTestConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        Iterator iter = this.designHandle.configVariablesIterator();
        if (iter != null) {
            while (iter.hasNext()) {
                ConfigVariableHandle handle = (ConfigVariableHandle)iter.next();
                String name = handle.getName();
                String value = handle.getValue();
                configs.put(name, value);
            }
        }
        return configs;
    }

    public IReportEngine getReportEngine() {
        return this.engine;
    }

    public void setReportEngine(IReportEngine engine) {
        this.engine = engine;
    }

    public void setDesignHandle(ReportDesignHandle handle) {
        this.designHandle = handle;
        this.reportIR = null;
    }

    public IReportDesign getDesignInstance() {
        ReportDesign design = new ReportDesign(this.designHandle);
        return design;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Report getReportIR() {
        if (this.reportIR != null) {
            return this.reportIR;
        }
        ReportRunnable reportRunnable = this;
        synchronized (reportRunnable) {
            if (this.reportIR != null) {
                return this.reportIR;
            }
            this.reportIR = new ReportParser().parse(this.designHandle);
        }
        return this.reportIR;
    }

    public void setReportIR(Report reportIR) {
        this.reportIR = reportIR;
    }
}

