/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.GroupExecutor;
import org.eclipse.birt.report.engine.executor.IPageBreakListener;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.executor.SuppressDuplicateUtil;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public abstract class ListingElementExecutor
extends QueryItemExecutor
implements IPageBreakListener {
    protected int rsetCursor;
    protected boolean needPageBreak;
    protected int pageRowCount = 0;
    protected int pageBreakInterval = -1;
    ReportItemDesign[] executableElements;
    int totalElements;
    int currentElement;
    boolean endOfListing;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ListingElementExecutor(ExecutorManager manager) {
        super(manager);
    }

    protected void initializeContent(ReportElementDesign design, IContent content) {
        super.initializeContent(design, content);
        if (this.isPageBreakIntervalValid((ListingDesign)design)) {
            this.pageBreakInterval = ((ListingDesign)design).getPageBreakInterval();
            this.context.addPageBreakListener(this);
        }
    }

    boolean isPageBreakIntervalValid(ListingDesign design) {
        BandDesign detailBand = design.getDetail();
        if (detailBand == null || detailBand.getContentCount() == 0) {
            return false;
        }
        for (int i = 0; i < design.getGroupCount(); ++i) {
            if (!design.getGroup(i).getHideDetail()) continue;
            return false;
        }
        return true;
    }

    public void close() {
        if (this.pageBreakInterval != -1) {
            this.context.removePageBreakListener(this);
        }
        this.rsetCursor = -1;
        this.needPageBreak = false;
        this.pageRowCount = 0;
        this.pageBreakInterval = -1;
        this.executableElements = null;
        this.totalElements = 0;
        this.currentElement = 0;
        this.endOfListing = false;
        super.close();
    }

    void nextRow() {
        if (this.pageBreakInterval > 0) {
            ++this.pageRowCount;
        }
    }

    boolean needSoftBreakBefore() {
        return this.pageBreakInterval > 0 && this.pageBreakInterval <= this.pageRowCount;
    }

    public boolean hasNextChild() {
        if (this.currentElement < this.totalElements) {
            return true;
        }
        if (this.endOfListing) {
            return false;
        }
        while (!this.endOfListing) {
            int endGroup = this.rset.getEndingGroupLevel();
            if (endGroup <= 0) {
                ListingDesign listingDesign = (ListingDesign)this.getDesign();
                this.totalElements = 0;
                this.currentElement = 0;
                if (listingDesign.getFooter() != null) {
                    this.executableElements[this.totalElements++] = listingDesign.getFooter();
                }
                this.endOfListing = true;
                return this.currentElement < this.totalElements;
            }
            if (!this.rset.next()) continue;
            this.nextRow();
            this.collectExecutableElements();
            if (this.currentElement >= this.totalElements) continue;
            return true;
        }
        return false;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            ReportItemDesign nextDesign;
            ReportItemExecutor nextExecutor;
            if (!$assertionsDisabled && this.currentElement >= this.totalElements) {
                throw new AssertionError();
            }
            if ((nextExecutor = this.manager.createExecutor(this, nextDesign = this.executableElements[this.currentElement++])) instanceof GroupExecutor) {
                GroupExecutor groupExecutor = (GroupExecutor)nextExecutor;
                groupExecutor.setLisingExecutor(this);
            }
            return nextExecutor;
        }
        return null;
    }

    protected void prepareToExecuteChildren() {
        ListingDesign listingDesign = (ListingDesign)this.getDesign();
        this.executableElements = new ReportItemDesign[3];
        if (this.rset == null || this.rsetEmpty) {
            BandDesign footer;
            BandDesign header = listingDesign.getHeader();
            if (header != null) {
                this.executableElements[this.totalElements++] = header;
            }
            if ((footer = listingDesign.getFooter()) != null) {
                this.executableElements[this.totalElements++] = footer;
            }
            this.endOfListing = true;
        } else {
            this.collectExecutableElements();
        }
        SuppressDuplicateUtil.clearDuplicateFlags(listingDesign);
    }

    void collectExecutableElements() {
        BandDesign header;
        this.currentElement = 0;
        this.totalElements = 0;
        this.endOfListing = false;
        ListingDesign listingDesign = (ListingDesign)this.getDesign();
        int groupCount = listingDesign.getGroupCount();
        int startGroup = this.rset.getStartingGroupLevel();
        if (startGroup == 0 && (header = listingDesign.getHeader()) != null) {
            this.executableElements[this.totalElements++] = header;
        }
        if (groupCount > 0) {
            this.executableElements[this.totalElements++] = listingDesign.getGroup(0);
        } else {
            BandDesign detail = listingDesign.getDetail();
            if (detail != null) {
                this.executableElements[this.totalElements++] = detail;
            }
        }
        int endGroup = this.rset.getEndingGroupLevel();
        if (endGroup <= 0) {
            BandDesign footer = listingDesign.getFooter();
            if (footer != null) {
                this.executableElements[this.totalElements++] = footer;
            }
            this.endOfListing = true;
        }
    }

    public void onPageBreak() {
        this.pageRowCount = 0;
    }

    static {
        $assertionsDisabled = !ListingElementExecutor.class.desiredAssertionStatus();
    }
}

