/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.internal.document.ReportExecutorWrapper;
import org.eclipse.birt.report.engine.internal.document.v3.ReportPageExecutorV3;
import org.eclipse.birt.report.engine.internal.document.v4.ReportPageExecutorV4;

public class ReportPageExecutor
extends ReportExecutorWrapper {
    public ReportPageExecutor(ExecutionContext context, List pages, boolean paged) throws BirtException {
        try {
            int version = ReportPageExecutor.getVersion(context.getReportDocument());
            switch (version) {
                case 3: {
                    this.executor = new ReportPageExecutorV3(context, pages, paged);
                    break;
                }
                case 4: {
                    this.executor = new ReportPageExecutorV4(context, pages, paged);
                    break;
                }
                default: {
                    throw new EngineException("unsupported document version:" + version);
                }
            }
        }
        catch (IOException ex) {
            throw new EngineException(ex.getLocalizedMessage(), ex);
        }
    }
}

