/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v2;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;

public class PageHintReaderV2
implements IPageHintReader {
    protected IDocArchiveReader reader;
    protected RAInputStream indexStream;
    protected RAInputStream hintsStream;
    protected long totalPage = -1L;
    protected int version;

    public PageHintReaderV2(IDocArchiveReader reader) throws IOException {
        this.reader = reader;
        try {
            this.hintsStream = reader.getStream("/pages");
            this.indexStream = reader.getStream("/pages_index");
            this.version = PageHintReaderV2.readHintVersion(this.hintsStream);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public static int readHintVersion(RAInputStream hintStream) throws IOException {
        hintStream.seek(0L);
        int version = hintStream.readInt();
        if (version == 0) {
            return 1;
        }
        return version;
    }

    public void close() {
        try {
            if (this.hintsStream != null) {
                this.hintsStream.close();
                this.hintsStream = null;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (this.indexStream != null) {
                this.indexStream.close();
                this.indexStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized long getTotalPage() throws IOException {
        this.indexStream.refresh();
        this.indexStream.seek(0L);
        this.totalPage = this.indexStream.readLong();
        return this.totalPage;
    }

    public synchronized IPageHint getPageHint(long pageNumber) throws IOException {
        this.indexStream.seek(pageNumber * 8L);
        long offset = this.indexStream.readLong();
        this.hintsStream.seek(offset);
        return this.readPageHint(this.version, new DataInputStream((InputStream)this.hintsStream));
    }

    protected IPageHint readPageHint(int version, DataInputStream in) throws IOException {
        switch (version) {
            case 1: {
                return this.readPageHintV1(in);
            }
            case 2: {
                return this.readPageHintV2(in);
            }
        }
        throw new IOException("Unsupported page hint version " + version);
    }

    public IPageHint readPageHintV1(DataInputStream in) throws IOException {
        long pageNumber = IOUtil.readLong((DataInputStream)in);
        long offset = IOUtil.readLong((DataInputStream)in);
        PageHint hint = new PageHint(pageNumber, offset);
        int sectionCount = IOUtil.readInt((InputStream)in);
        for (int i = 0; i < sectionCount; ++i) {
            long startOffset = IOUtil.readLong((DataInputStream)in);
            long endOffset = IOUtil.readLong((DataInputStream)in);
            PageSection section = new PageSection();
            section.startOffset = startOffset;
            section.endOffset = endOffset;
            hint.addSection(section);
        }
        return hint;
    }

    public IPageHint readPageHintV2(DataInputStream in) throws IOException {
        long pageNumber = IOUtil.readLong((DataInputStream)in);
        long offset = IOUtil.readLong((DataInputStream)in);
        PageHint hint = new PageHint(pageNumber, offset);
        int sectionCount = IOUtil.readInt((InputStream)in);
        for (int i = 0; i < sectionCount; ++i) {
            PageSection section = new PageSection();
            section.starts = this.readInstanceIndex(in);
            section.ends = this.readInstanceIndex(in);
            section.startOffset = section.starts[section.starts.length - 1].getOffset();
            section.endOffset = section.ends[section.ends.length - 1].getOffset();
            hint.addSection(section);
        }
        return hint;
    }

    protected InstanceIndex[] readInstanceIndex(DataInputStream in) throws IOException {
        int length = IOUtil.readInt((InputStream)in);
        InstanceIndex[] indexes = new InstanceIndex[length];
        for (int i = 0; i < length; ++i) {
            String id = IOUtil.readString((DataInputStream)in);
            long offset = IOUtil.readLong((DataInputStream)in);
            indexes[i] = new InstanceIndex(InstanceID.parse(id), offset);
        }
        return indexes;
    }
}

