/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v3;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.AutoTextContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.content.impl.DataContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.ListBandContent;
import org.eclipse.birt.report.engine.content.impl.ListContent;
import org.eclipse.birt.report.engine.content.impl.ListGroupContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.content.impl.TableBandContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.content.impl.TableGroupContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;

public class ReportContentReaderV3 {
    protected static Logger logger = Logger.getLogger(ReportContentReaderV3.class.getName());
    protected ReportContent reportContent;
    protected RAInputStream stream;
    protected int version = -1;
    protected static final int INDEX_ENTRY_SIZE_V0 = 40;
    protected static final int INDEX_ENTRY_SIZE_V1 = 24;
    protected static final int VERSION_0 = 0;
    protected static final int VERSION_1 = 1;
    protected static final int VERSION_SIZE = 4;
    protected long offset;
    protected boolean isEmpty = false;

    public ReportContentReaderV3(ReportContent reportContent, RAInputStream stream) throws IOException {
        this.reportContent = reportContent;
        this.stream = stream;
        long length = stream.length();
        if (this.stream.length() >= 4L) {
            stream.seek(0L);
            int iVersion = stream.readInt();
            if (-1 == iVersion) {
                this.version = 0;
            } else {
                this.version = iVersion;
                if (this.version == 1 && length == 4L) {
                    this.isEmpty = true;
                }
            }
        } else {
            throw new IOException("unrecognized stream version!");
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to close the reader", ex);
            }
            this.stream = null;
        }
    }

    protected IContent readObject(long offset) throws IOException {
        if (0 == this.version) {
            this.stream.seek(offset);
        } else if (1 == this.version) {
            this.stream.seek(4L + offset);
        } else {
            throw new IOException("unrecognized stream version!");
        }
        int size = this.stream.readInt();
        byte[] buffer = new byte[size];
        this.stream.readFully(buffer, 0, size);
        DataInputStream oi = new DataInputStream(new ByteArrayInputStream(buffer));
        AbstractContent object = null;
        int contentType = IOUtil.readInt((InputStream)oi);
        switch (contentType) {
            case 1: {
                object = new CellContent(this.reportContent);
                break;
            }
            case 2: {
                object = new ContainerContent(this.reportContent);
                break;
            }
            case 3: {
                object = new DataContent(this.reportContent);
                break;
            }
            case 4: {
                object = new ForeignContent(this.reportContent);
                break;
            }
            case 5: {
                object = new ImageContent(this.reportContent);
                break;
            }
            case 6: {
                object = new LabelContent(this.reportContent);
                break;
            }
            case 7: {
                object = new PageContent(this.reportContent);
                break;
            }
            case 8: {
                object = new RowContent(this.reportContent);
                break;
            }
            case 9: {
                object = new TableBandContent(this.reportContent);
                break;
            }
            case 10: {
                object = new TableContent(this.reportContent);
                break;
            }
            case 11: {
                object = new TextContent(this.reportContent);
                break;
            }
            case 12: {
                object = new AutoTextContent(this.reportContent);
                break;
            }
            case 13: {
                object = new ListContent(this.reportContent);
                break;
            }
            case 14: {
                object = new ListBandContent(this.reportContent);
                break;
            }
            case 16: {
                object = new ListGroupContent(this.reportContent);
                break;
            }
            case 17: {
                object = new TableGroupContent(this.reportContent);
                break;
            }
            default: {
                throw new IOException("Found invalid contentType" + contentType + " at object offset " + offset);
            }
        }
        object.setVersion(this.version);
        object.readContent(oi);
        return object;
    }

    public IContent readContent() throws IOException {
        long index = this.offset;
        IContent content = this.readContent(index);
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt.getFirstChild() != -1L) {
            this.offset = docExt.getFirstChild();
            return content;
        }
        if (docExt.getNext() != -1L) {
            this.offset = docExt.getNext();
            return content;
        }
        docExt = this.readDocumentExtension(docExt.getParent());
        while (docExt != null) {
            if (docExt.getNext() != -1L) {
                this.offset = docExt.getNext();
                return content;
            }
            docExt = this.readDocumentExtension(docExt.getParent());
        }
        this.offset = -1L;
        return content;
    }

    public IContent readContent(long index) throws IOException {
        if (0 == this.version) {
            return this.readContentV0(index);
        }
        if (1 == this.version) {
            return this.readContentV1(index);
        }
        throw new IOException("unrecognized stream version!");
    }

    private IContent readContentV0(long index) throws IOException {
        if (index >= this.stream.length() || index < 0L) {
            throw new IOException("Invalid content offset:" + index);
        }
        DocumentExtension docExt = this.readDocumentExtensionV0(index);
        IContent content = this.readObject(index + 40L);
        if (content != null) {
            content.setExtension(0, docExt);
        }
        return content;
    }

    private IContent readContentV1(long index) throws IOException {
        DocumentExtension docExt = this.readDocumentExtensionV1(index);
        IContent content = this.readObject(index + 24L);
        if (content != null) {
            content.setExtension(0, docExt);
        }
        return content;
    }

    private DocumentExtension readDocumentExtension(long index) throws IOException {
        if (0 == this.version) {
            return this.readDocumentExtensionV0(index);
        }
        if (1 == this.version) {
            return this.readDocumentExtensionV1(index);
        }
        throw new IOException("unrecognized stream version!");
    }

    private DocumentExtension readDocumentExtensionV0(long index) throws IOException {
        this.stream.seek(index);
        index = this.stream.readLong();
        long parent = this.stream.readLong();
        long previous = this.stream.readLong();
        long next = this.stream.readLong();
        long child = this.stream.readLong();
        DocumentExtension docExt = new DocumentExtension(index);
        docExt.setParent(parent);
        docExt.setPrevious(previous);
        docExt.setNext(next);
        docExt.setFirstChild(child);
        return docExt;
    }

    private DocumentExtension readDocumentExtensionV1(long index) throws IOException {
        this.stream.seek(4L + index);
        long parent = this.stream.readLong();
        long next = this.stream.readLong();
        long child = this.stream.readLong();
        DocumentExtension docExt = new DocumentExtension(index);
        docExt.setParent(parent);
        docExt.setNext(next);
        docExt.setFirstChild(child);
        return docExt;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

