/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;

public abstract class ContainerExecutor
extends ReportItemExecutor {
    private boolean needPrepareNext = true;
    private Object[][] sections = null;
    private boolean useNextSection = true;
    private int nextSection = -1;
    protected long nextOffset = -1L;
    private IReportItemExecutor childExecutor;

    protected ContainerExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    public void close() {
        if (this.nextOffset != -1L) {
            this.reader.unloadContent(this.nextOffset);
            this.nextOffset = -1L;
        }
        this.needPrepareNext = true;
        this.sections = null;
        this.useNextSection = true;
        this.nextSection = -1;
        this.nextOffset = -1L;
        super.close();
    }

    public boolean hasNextChild() {
        if (this.needPrepareNext) {
            try {
                this.childExecutor = this.prepareChildExecutor();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.needPrepareNext = false;
        }
        return this.childExecutor != null;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            this.needPrepareNext = true;
            return this.childExecutor;
        }
        return null;
    }

    protected IReportItemExecutor prepareChildExecutor() throws Exception {
        IContent childContent;
        ReportItemExecutor childExecutor;
        DocumentExtension docExt;
        if (this.fragment == null && this.nextOffset == -1L && (docExt = (DocumentExtension)this.content.getExtension(0)) != null) {
            this.nextOffset = docExt.getFirstChild();
        }
        if (this.fragment != null) {
            if (this.sections == null) {
                this.sections = this.fragment.getSections();
                this.nextSection = -1;
                this.useNextSection = true;
            }
            if (this.useNextSection) {
                this.useNextSection = false;
                ++this.nextSection;
                if (this.sections == null || this.nextSection >= this.sections.length) {
                    return null;
                }
                Object leftEdge = this.sections[this.nextSection][0];
                if (leftEdge == Segment.LEFT_MOST_EDGE) {
                    DocumentExtension docExt2 = (DocumentExtension)this.content.getExtension(0);
                    if (docExt2 != null) {
                        this.nextOffset = docExt2.getFirstChild();
                    }
                } else {
                    DocumentExtension docExt3;
                    InstanceIndex leftIndex = (InstanceIndex)leftEdge;
                    long leftOffset = leftIndex.getOffset();
                    if (leftOffset == -1L && (docExt3 = (DocumentExtension)this.content.getExtension(0)) != null) {
                        leftOffset = docExt3.getFirstChild();
                    }
                    if (leftOffset != -1L) {
                        IContent leftContent = this.reader.loadContent(leftOffset);
                        if (this.isSameInstance(leftContent.getInstanceID(), leftIndex.getInstanceID())) {
                            this.nextOffset = leftIndex.getOffset();
                        } else {
                            DocumentExtension docExt4 = (DocumentExtension)leftContent.getExtension(0);
                            if (docExt4 != null) {
                                this.nextOffset = docExt4.getNext();
                            }
                        }
                    }
                    this.doSkipToExecutor(leftIndex.getInstanceID(), this.nextOffset);
                    this.uniqueId = leftIndex.getInstanceID().getUniqueID();
                }
            }
        }
        if ((childExecutor = this.doCreateExecutor(this.nextOffset)) != null && (childContent = childExecutor.execute()) != null) {
            DocumentExtension docExt5;
            if (this.fragment != null) {
                InstanceIndex rightIndex;
                Object rightEdge;
                InstanceID childId = childContent.getInstanceID();
                Fragment childFragment = this.fragment.getFragment(childId);
                if (childFragment != null) {
                    childExecutor.setFragment(childFragment);
                }
                if ((rightEdge = this.sections[this.nextSection][1]) != Segment.RIGHT_MOST_EDGE && this.isSameInstance((rightIndex = (InstanceIndex)rightEdge).getInstanceID(), childContent.getInstanceID())) {
                    this.useNextSection = true;
                }
            }
            if ((docExt5 = (DocumentExtension)childContent.getExtension(0)) != null && docExt5.getIndex() == this.nextOffset) {
                this.nextOffset = docExt5.getNext();
            }
        }
        return childExecutor;
    }

    protected abstract ReportItemExecutor doCreateExecutor(long var1) throws Exception;

    protected abstract void doSkipToExecutor(InstanceID var1, long var2) throws Exception;
}

