/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.executor.SuppressDuplicateUtil;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.GroupExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ListingElementExecutorUtil;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public abstract class ListingElementExecutor
extends ContainerExecutor {
    private ReportItemDesign[] executableElements = null;
    private int totalElements = 0;
    private int currentElement = 0;
    private ListingElementExecutorUtil executorUtil = null;

    protected ListingElementExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    public void close() {
        SuppressDuplicateUtil.clearDuplicateFlags(this.design);
        this.executableElements = null;
        this.totalElements = 0;
        this.currentElement = 0;
        this.executorUtil = null;
        super.close();
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        if (this.currentElement >= this.totalElements) {
            this.collectExecutables();
        }
        if (this.currentElement < this.totalElements) {
            ReportItemDesign childDesign = this.executableElements[this.currentElement];
            ++this.currentElement;
            ReportItemExecutor childExecutor = this.manager.createExecutor(this, childDesign, offset);
            if (childExecutor instanceof GroupExecutor) {
                GroupExecutor groupExecutor = (GroupExecutor)childExecutor;
                groupExecutor.setLisingExecutor(this);
            }
            return childExecutor;
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID iid, long offset) throws Exception {
        long uid = iid.getUniqueID();
        DataID dataId = iid.getDataID();
        long rowId = dataId.getRowID();
        long rsetPosition = this.rset.getCurrentPosition();
        if (rsetPosition == rowId) {
            if (this.currentElement >= this.totalElements) {
                this.collectExecutables(uid == 0L, true);
            }
        } else {
            this.rset.skipTo(rowId);
            this.collectExecutables(uid == 0L, true);
        }
        for (int i = 0; i < this.totalElements; ++i) {
            if (this.executableElements[i].getID() != iid.getComponentID()) continue;
            this.currentElement = i;
            return;
        }
        this.currentElement = this.totalElements;
    }

    protected void collectExecutables() {
        this.collectExecutables(true, false);
    }

    protected void collectExecutables(boolean includeHeader, boolean useCurrentRow) {
        this.currentElement = 0;
        this.totalElements = 0;
        if (this.executableElements == null) {
            ListingDesign listing = (ListingDesign)this.getDesign();
            this.executableElements = new ReportItemDesign[3];
            if (this.rset == null || this.rsetEmpty) {
                BandDesign footer;
                BandDesign header = listing.getHeader();
                if (header != null) {
                    this.executableElements[this.totalElements++] = header;
                }
                if ((footer = listing.getFooter()) != null) {
                    this.executableElements[this.totalElements++] = footer;
                }
            } else {
                this.executorUtil = new ListingElementExecutorUtil(0, listing.getHeader(), listing.getFooter(), listing.getGroupCount() == 0 ? listing.getDetail() : listing.getGroup(0), this.rset, includeHeader);
            }
        }
        if (this.executorUtil != null) {
            if (useCurrentRow) {
                this.executorUtil.startFromCurrentRow();
            }
            this.totalElements = this.executorUtil.collectExecutableElements(this.executableElements);
        }
    }
}

