/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;

public class ReportBodyExecutor
extends ContainerExecutor {
    private Report reportDesign;
    private int nextItem;

    ReportBodyExecutor(ExecutorManager manager, Fragment fragment) {
        super(manager, -1);
        this.reportDesign = this.context.getReport();
        this.reader = manager.getReportReader();
        this.nextItem = 0;
        if (fragment == null) {
            this.nextOffset = 0L;
        } else {
            this.setFragment(fragment);
            Object[][] sections = fragment.getSections();
            if (sections != null && sections.length > 0) {
                Object[] edges = sections[0];
                if (edges[0] == Segment.LEFT_MOST_EDGE) {
                    if (!this.reader.isEmpty()) {
                        this.nextOffset = 0L;
                    }
                } else {
                    InstanceIndex leftEdge = (InstanceIndex)edges[0];
                    if (leftEdge.getOffset() == -1L && !this.reader.isEmpty()) {
                        this.nextOffset = 0L;
                    }
                }
            }
        }
        this.content = this.report.getRoot();
    }

    public void close() {
        this.nextItem = 0;
        super.close();
    }

    public IContent execute() {
        return this.content;
    }

    protected InstanceID getInstanceID() {
        return null;
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        int itemCount = this.reportDesign.getContentCount();
        if (this.nextItem < itemCount) {
            ReportItemDesign itemDesign = this.reportDesign.getContent(this.nextItem);
            ++this.nextItem;
            return this.manager.createExecutor(this, itemDesign, offset);
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID id, long offset) throws Exception {
        int itemCount = this.reportDesign.getContentCount();
        long designId = id.getComponentID();
        for (int i = 0; i < itemCount; ++i) {
            ReportItemDesign itemDesign = this.reportDesign.getContent(i);
            if (designId != itemDesign.getID()) continue;
            this.nextItem = i;
            return;
        }
        this.nextItem = itemCount;
    }

    protected void doExecute() throws Exception {
    }
}

