/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.l18n;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportItemExecutorManager;
import org.eclipse.birt.report.engine.presentation.LocalizedContentVisitor;

class LocalizedReportItemExecutor
implements IReportItemExecutor {
    LocalizedContentVisitor l18nVisitor;
    LocalizedReportItemExecutorManager manager;
    IReportItemExecutor executor;

    LocalizedReportItemExecutor(LocalizedReportItemExecutorManager manager) {
        this.manager = manager;
        this.l18nVisitor = manager.l18nVisitor;
    }

    void setExecutor(IReportItemExecutor executor) {
        this.executor = executor;
    }

    public void close() {
        this.executor.close();
        this.manager.releaseExecutor(this);
    }

    public IContent execute() {
        IContent content = this.executor.execute();
        if (content != null) {
            content = this.l18nVisitor.localize(content);
        }
        return content;
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor childExecutor = this.executor.getNextChild();
        if (childExecutor != null) {
            return this.manager.createExecutor(childExecutor);
        }
        return childExecutor;
    }

    public boolean hasNextChild() {
        return this.executor.hasNextChild();
    }
}

