/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.internal.content.wrap.CellContentWrapper;
import org.eclipse.birt.report.engine.presentation.WrappedEmitter;

public class TableNormalizeEmitter
extends WrappedEmitter {
    protected Stack tables = new Stack();
    protected int[] spans;
    protected int nextCellId;
    protected boolean[] columns;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TableNormalizeEmitter(IContentEmitter emitter) {
        super(emitter);
    }

    public void startTable(ITableContent table) {
        super.startTable(table);
        this.tables.push(this.spans);
        this.tables.push(new Integer(this.nextCellId));
        this.tables.push(this.columns);
        this.spans = new int[table.getColumnCount()];
        this.columns = this.getColumnVisibility(table);
    }

    public void endTable(ITableContent table) {
        this.columns = (boolean[])this.tables.pop();
        this.nextCellId = (Integer)this.tables.pop();
        this.spans = (int[])this.tables.pop();
        super.endTable(table);
    }

    public void startRow(IRowContent row) {
        super.startRow(row);
        this.nextCellId = 0;
    }

    public void endRow(IRowContent row) {
        int i;
        for (i = this.nextCellId; i < this.spans.length; ++i) {
            if (this.spans[i] > 0 || !this.columns[i]) continue;
            ICellContent emptyCell = row.getReportContent().createCellContent();
            emptyCell.setColumn(i);
            emptyCell.setColSpan(1);
            emptyCell.setRowSpan(1);
            emptyCell.setParent(row);
            super.startCell(emptyCell);
            super.endCell(emptyCell);
            this.spans[i] = 1;
        }
        i = 0;
        while (i < this.spans.length) {
            int n = i++;
            this.spans[n] = this.spans[n] - 1;
        }
        super.endRow(row);
    }

    public void startCell(ICellContent cell) {
        int cellId = cell.getColumn();
        if (!$assertionsDisabled && !this.columns[cellId]) {
            throw new AssertionError();
        }
        if (cellId < this.spans.length) {
            for (int i = this.nextCellId; i < cellId; ++i) {
                if (this.spans[i] >= 1 || !this.columns[i]) continue;
                ICellContent emptyCell = cell.getReportContent().createCellContent();
                emptyCell.setColumn(i);
                emptyCell.setColSpan(1);
                emptyCell.setRowSpan(1);
                emptyCell.setParent(cell.getParent());
                super.startCell(emptyCell);
                super.endCell(emptyCell);
                this.spans[i] = 1;
            }
        }
        int colSpan = cell.getColSpan();
        int rowSpan = cell.getRowSpan();
        this.nextCellId = cellId + colSpan;
        if (this.nextCellId > this.spans.length) {
            this.nextCellId = this.spans.length;
        }
        int realColSpan = colSpan;
        for (int i = cellId; i < cellId + colSpan; ++i) {
            if (this.columns[i]) continue;
            --realColSpan;
        }
        if (realColSpan != colSpan) {
            CellContentWrapper cellWrapper = new CellContentWrapper(cell);
            cellWrapper.setColSpan(realColSpan);
            super.startCell(cellWrapper);
        } else {
            super.startCell(cell);
        }
        for (int i = cellId; i < this.nextCellId; ++i) {
            this.spans[i] = rowSpan;
        }
    }

    private boolean isColumnHidden(IColumn column) {
        String formats = column.getVisibleFormat();
        return formats != null && (formats.indexOf("viewer") >= 0 || formats.indexOf("all") >= 0);
    }

    private boolean[] getColumnVisibility(ITableContent table) {
        int count = table.getColumnCount();
        boolean[] columns = new boolean[count];
        for (int i = 0; i < count; ++i) {
            IColumn column = table.getColumn(i);
            columns[i] = !this.isColumnHidden(column);
        }
        return columns;
    }

    static {
        $assertionsDisabled = !TableNormalizeEmitter.class.desiredAssertionStatus();
    }
}

