/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Locale;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFReportLayoutEngine;

public class PDFLayoutEngineContext {
    protected int pageNumber = 1;
    protected PDFLayoutManagerFactory factory = null;
    protected StartVisitor start;
    protected EndVisitor end;
    protected String masterPage = null;
    protected boolean allowPageBreak = true;
    protected IContent unresolvedContent = null;
    protected PDFReportLayoutEngine engine;
    protected int maxWidth;
    protected int maxHeight;
    protected String format;
    protected boolean cancel = false;
    protected IReportContent report;
    protected Locale locale;
    protected boolean fitToPage = false;
    protected boolean pageBreakPaginationOnly = false;
    protected int preferenceWidth = 0;

    public IReportContent getReport() {
        return this.report;
    }

    public void setReport(IReportContent report) {
        this.report = report;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public String getMasterPage() {
        return this.masterPage;
    }

    public void setMasterPage(String masterPage) {
        this.masterPage = masterPage;
    }

    public PDFLayoutEngineContext(PDFReportLayoutEngine engine) {
        this.engine = engine;
        this.start = new StartVisitor();
        this.end = new EndVisitor();
    }

    public void setFactory(PDFLayoutManagerFactory factory) {
        this.factory = factory;
    }

    public IContentVisitor getStart() {
        return this.start;
    }

    public IContentVisitor getEnd() {
        return this.end;
    }

    public PDFLayoutManagerFactory getFactory() {
        return this.factory;
    }

    public boolean allowPageBreak() {
        return this.allowPageBreak;
    }

    public void setAllowPageBreak(boolean allowPageBreak) {
        this.allowPageBreak = allowPageBreak;
    }

    public PDFReportLayoutEngine getLayoutEngine() {
        return this.engine;
    }

    public void addUnresolvedContent(IContent content) {
        this.unresolvedContent = content;
    }

    public IContent getUnresolvedContent() {
        return this.unresolvedContent;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    public void setFitToPage(boolean fitToPage) {
        this.fitToPage = fitToPage;
    }

    public boolean fitToPage() {
        return this.fitToPage;
    }

    public void setPagebreakPaginationOnly(boolean samePagination) {
        this.pageBreakPaginationOnly = samePagination;
    }

    public boolean pagebreakPaginationOnly() {
        return this.pageBreakPaginationOnly;
    }

    public void setPreferenceWidth(int preferenceWidth) {
        this.preferenceWidth = preferenceWidth;
    }

    public int getPreferenceWidth() {
        return this.preferenceWidth;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    private class EndVisitor
    implements IContentVisitor {
        private EndVisitor() {
        }

        public Object visit(IContent content, Object value) {
            ((IContentEmitter)value).endContent(content);
            return null;
        }

        public Object visitContent(IContent content, Object value) {
            ((IContentEmitter)value).endContent(content);
            return null;
        }

        public Object visitPage(IPageContent page, Object value) {
            ((IContentEmitter)value).endPage(page);
            return null;
        }

        public Object visitContainer(IContainerContent container, Object value) {
            ((IContentEmitter)value).endContainer(container);
            return null;
        }

        public Object visitTable(ITableContent table, Object value) {
            ((IContentEmitter)value).endTable(table);
            return null;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            return null;
        }

        public Object visitRow(IRowContent row, Object value) {
            ((IContentEmitter)value).endRow(row);
            return null;
        }

        public Object visitCell(ICellContent cell, Object value) {
            ((IContentEmitter)value).endCell(cell);
            return null;
        }

        public Object visitText(ITextContent text, Object value) {
            return null;
        }

        public Object visitLabel(ILabelContent label, Object value) {
            return null;
        }

        public Object visitData(IDataContent data, Object value) {
            return null;
        }

        public Object visitImage(IImageContent image, Object value) {
            return null;
        }

        public Object visitForeign(IForeignContent foreign, Object value) {
            return null;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            return null;
        }

        public Object visitList(IListContent list, Object value) {
            ((IContentEmitter)value).endList(list);
            return null;
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            return null;
        }

        public Object visitGroup(IGroupContent group, Object value) {
            return null;
        }

        public Object visitListGroup(IListGroupContent group, Object value) {
            return null;
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) {
            return null;
        }
    }

    private class StartVisitor
    implements IContentVisitor {
        private StartVisitor() {
        }

        public Object visit(IContent content, Object value) {
            ((IContentEmitter)value).startContent(content);
            return null;
        }

        public Object visitContent(IContent content, Object value) {
            ((IContentEmitter)value).startContent(content);
            return null;
        }

        public Object visitPage(IPageContent page, Object value) {
            ((IContentEmitter)value).startPage(page);
            return null;
        }

        public Object visitContainer(IContainerContent container, Object value) {
            ((IContentEmitter)value).startContainer(container);
            return null;
        }

        public Object visitTable(ITableContent table, Object value) {
            ((IContentEmitter)value).startTable(table);
            return null;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            return null;
        }

        public Object visitRow(IRowContent row, Object value) {
            ((IContentEmitter)value).startRow(row);
            return null;
        }

        public Object visitCell(ICellContent cell, Object value) {
            ((IContentEmitter)value).startCell(cell);
            return null;
        }

        public Object visitText(ITextContent text, Object value) {
            ((IContentEmitter)value).startText(text);
            return null;
        }

        public Object visitLabel(ILabelContent label, Object value) {
            ((IContentEmitter)value).startLabel(label);
            return null;
        }

        public Object visitData(IDataContent data, Object value) {
            ((IContentEmitter)value).startData(data);
            return null;
        }

        public Object visitImage(IImageContent image, Object value) {
            ((IContentEmitter)value).startImage(image);
            return null;
        }

        public Object visitForeign(IForeignContent foreign, Object value) {
            ((IContentEmitter)value).startForeign(foreign);
            return null;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            ((IContentEmitter)value).startAutoText(autoText);
            return null;
        }

        public Object visitList(IListContent list, Object value) {
            ((IContentEmitter)value).startList(list);
            return null;
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            return null;
        }

        public Object visitGroup(IGroupContent group, Object value) {
            return null;
        }

        public Object visitListGroup(IListGroupContent group, Object value) {
            return null;
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) {
            return null;
        }
    }
}

