/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.HashSet;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.dom.AreaStyle;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ITextLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLeafItemLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLineAreaLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.DummyHyphenationManager;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Hyphenation;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.ICUWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.IWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class PDFTextLM
extends PDFLeafItemLM
implements ITextLayoutManager {
    private PDFLineAreaLM lineLM;
    private boolean pause = false;
    private Compositor comp = null;
    private ITextContent textContent = null;
    private static final char maxHighChar = 'P';
    static /* synthetic */ Class class$org$eclipse$birt$report$engine$layout$pdf$PDFTextLM;

    public PDFTextLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.lineLM = (PDFLineAreaLM)parent;
        ITextContent textContent = (ITextContent)content;
        String text = textContent.getText();
        if (text != null && text.length() != 0) {
            this.transform(textContent);
            this.textContent = textContent;
            this.comp = new Compositor();
        }
    }

    protected boolean layoutChildren() {
        if (null == this.textContent) {
            return false;
        }
        this.pause = false;
        return this.comp.compose();
    }

    public void addSpaceHolder(IArea con) {
        this.lineLM.addArea(con);
    }

    public boolean needPause() {
        return this.pause;
    }

    public void addTextLine(IArea textLine) {
        this.lineLM.addArea(textLine);
    }

    public void newLine() {
        this.pause = !this.lineLM.endLine();
    }

    public int getFreeSpace() {
        int freeSpace = this.lineLM.getMaxAvaWidth() - this.lineLM.getCurrentIP();
        return freeSpace;
    }

    public void setBaseLevel(int baseLevel) {
        this.lineLM.setBaseLevel(baseLevel);
    }

    public void transform(ITextContent textContent) {
        String transformType = textContent.getComputedStyle().getTextTransform();
        if (transformType.equalsIgnoreCase("uppercase")) {
            textContent.setText(textContent.getText().toUpperCase());
        } else if (transformType.equalsIgnoreCase("lowercase")) {
            textContent.setText(textContent.getText().toLowerCase());
        } else if (transformType.equalsIgnoreCase("capitalize")) {
            textContent.setText(this.capitalize(textContent.getText()));
        }
    }

    private String capitalize(String text) {
        HashSet<Character> splitChar = new HashSet<Character>();
        splitChar.add(new Character(' '));
        splitChar.add(new Character('\n'));
        char[] array = text.toCharArray();
        int index = 0;
        while (index < array.length) {
            Character c = new Character(text.charAt(index));
            while (splitChar.contains(c)) {
                if (++index == array.length) {
                    return new String(array);
                }
                c = new Character(text.charAt(index));
            }
            array[index] = Character.toUpperCase(array[index]);
            while (!splitChar.contains(c) && ++index != array.length) {
                c = new Character(text.charAt(index));
            }
        }
        return new String(array);
    }

    private class Compositor {
        private ChunkGenerator cg = null;
        private Chunk chunk = null;
        private ITextContent content;
        private boolean isInline;
        private boolean isNew = true;
        private int leftSpaceHolder = 0;
        private int rightSpaceHolder = 0;
        private int vestigeIndex = -1;
        private int vestigeLength = 0;
        private int currentPos = 0;
        private int areaStartPos = 0;
        private int letterSpacing = 0;
        private int wordSpacing = 0;
        private int maxLineSpace = 0;
        private IWordRecognizer wr = null;
        private boolean addByForce = false;
        private boolean nothingSplitted = false;
        private int leftMargin;
        private int leftBorder;
        private int leftPadding;
        private int rightMargin;
        private int rightBorder;
        private int rightPadding;
        private int topBorder;
        private int topPadding;
        private int bottomBorder;
        private int bottomPadding;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Compositor() {
            this.content = PDFTextLM.this.textContent;
            this.cg = new ChunkGenerator(this.content);
            this.isInline = PropertyUtil.isInlineElement(this.content);
            this.maxLineSpace = PDFTextLM.this.lineLM.getMaxAvaWidth();
            IStyle style = this.content.getComputedStyle();
            this.letterSpacing = PDFTextLM.this.getDimensionValue(style.getProperty(25));
            this.wordSpacing = PDFTextLM.this.getDimensionValue(style.getProperty(44));
            AreaStyle boxStyle = new AreaStyle((ComputedStyle)style);
            PDFTextLM.this.validateBoxProperty(boxStyle, this.maxLineSpace, PDFTextLM.this.context.getMaxHeight());
            this.leftMargin = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(31));
            this.leftBorder = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(17));
            this.leftPadding = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(36));
            this.rightMargin = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(32));
            this.rightBorder = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(18));
            this.rightPadding = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(37));
            this.topBorder = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(15));
            this.topPadding = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(56));
            this.bottomBorder = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(19));
            this.bottomPadding = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(55));
        }

        public boolean compose() {
            while (this.hasMore()) {
                this.handleNext();
                if (!PDFTextLM.this.needPause()) continue;
                return true;
            }
            return false;
        }

        private boolean hasMore() {
            if (this.cg.hasMore()) {
                return true;
            }
            if (null == this.chunk) {
                return false;
            }
            if (this.currentPos < this.chunk.getText().length()) {
                return true;
            }
            if (this.isInline) {
                ContainerArea con = (ContainerArea)PDFTextLM.this.createInlineContainer(this.content, false, true);
                con.setWidth(this.rightBorder + this.rightPadding);
                if (null == this.chunk.getFontInfo()) {
                    IStyle style = this.content.getComputedStyle();
                    con.setHeight(PDFTextLM.this.getDimensionValue(style.getProperty(38)) + this.topBorder + this.topPadding + this.bottomBorder + this.bottomPadding);
                } else {
                    con.setHeight((int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f) + this.topBorder + this.topPadding + this.bottomBorder + this.bottomPadding);
                }
                PDFTextLM.this.addSpaceHolder(con);
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void handleNext() {
            int length;
            int freeSpace = PDFTextLM.this.getFreeSpace();
            if (this.isNew || this.currentPos == this.chunk.getText().length()) {
                if (!this.cg.hasMore()) {
                    return;
                }
                this.chunk = this.cg.getNext();
                if (this.chunk == Chunk.HARD_LINE_BREAK) {
                    FontHandler handler = new FontHandler(this.content);
                    handler.selectFont('P');
                    ContainerArea con = (ContainerArea)PDFTextLM.this.createInlineContainer(this.content, false, true);
                    con.setWidth(0);
                    con.setHeight((int)(handler.getFontInfo().getWordHeight() * 1000.0f) + this.topBorder + this.topPadding + this.bottomBorder + this.bottomPadding);
                    PDFTextLM.this.addSpaceHolder(con);
                    this.currentPos = this.chunk.getText().length();
                    PDFTextLM.this.newLine();
                    this.vestigeIndex = -1;
                    return;
                }
                this.currentPos = 0;
                this.vestigeIndex = -1;
                this.vestigeLength = 0;
                this.wr = new ICUWordRecognizer(this.chunk.getText(), PDFTextLM.this.context.getLocale());
            }
            if (this.isNew) {
                this.isNew = false;
                if (this.isInline) {
                    AbstractArea con = (AbstractArea)((Object)PDFTextLM.this.createInlineContainer(this.content, true, false));
                    con.setWidth(this.leftBorder + this.leftPadding);
                    con.setHeight((int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f) + this.topBorder + this.topPadding + this.bottomBorder + this.bottomPadding);
                    PDFTextLM.this.addSpaceHolder(con);
                    this.leftSpaceHolder = this.leftMargin + this.leftBorder + this.leftPadding;
                    freeSpace -= this.leftSpaceHolder;
                }
            }
            String str = null;
            Word currentWord = null;
            if (-1 == this.vestigeIndex) {
                currentWord = this.wr.getNextWord();
                if (null == currentWord) {
                    Dimension d = new Dimension(0, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
                    IArea builtArea = this.buildArea("", this.content, this.chunk.getFontInfo(), d);
                    PDFTextLM.this.addTextLine(builtArea);
                    return;
                }
                str = currentWord.getValue();
                this.areaStartPos = this.chunk.getOffset() + currentWord.getStart();
            } else {
                str = this.chunk.getText().substring(this.vestigeIndex, this.vestigeIndex + this.vestigeLength);
                this.areaStartPos = this.chunk.getOffset() + this.vestigeIndex;
            }
            int prevAreaWidth = 0;
            int areaWidth = (int)(this.chunk.getFontInfo().getWordWidth(this.chunk.getText().substring(this.currentPos, this.currentPos + str.length())) * 1000.0f) + this.letterSpacing * str.length() + this.wordSpacing;
            if (this.isInline && this.isAtLast(this.chunk.getOffset() + this.currentPos + str.length())) {
                this.rightSpaceHolder = this.rightMargin + this.rightBorder + this.rightPadding;
                freeSpace -= this.rightSpaceHolder;
            }
            while (freeSpace >= areaWidth) {
                this.currentPos += str.length();
                currentWord = this.wr.getNextWord();
                if (null == currentWord) {
                    str = null;
                    break;
                }
                str = currentWord.getValue();
                prevAreaWidth = areaWidth;
                areaWidth += (int)(this.chunk.getFontInfo().getWordWidth(this.chunk.getText().substring(this.currentPos, this.currentPos + str.length())) * 1000.0f) + this.letterSpacing * str.length() + this.wordSpacing;
                if (!this.isAtLast(this.chunk.getOffset() + this.currentPos + str.length())) continue;
                this.rightSpaceHolder = this.rightMargin + this.rightBorder + this.rightPadding;
                freeSpace -= this.rightSpaceHolder;
            }
            if (this.currentPos == (length = this.chunk.getText().length())) {
                Dimension d = new Dimension(areaWidth, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
                String originalText = this.chunk.getText().substring(this.areaStartPos - this.chunk.getOffset(), this.chunk.getText().length());
                IArea builtArea = this.buildArea(this.getReverseText(originalText), this.content, this.chunk.getFontInfo(), d);
                PDFTextLM.this.addTextLine(builtArea);
                this.vestigeIndex = -1;
                this.vestigeLength = 0;
                return;
            }
            if ((float)this.maxLineSpace < this.chunk.getFontInfo().getWordWidth(str) * 1000.0f + (float)(this.letterSpacing * str.length()) + (float)this.wordSpacing) {
                block19: {
                    if (0 == str.length()) {
                        this.vestigeIndex = -1;
                        this.vestigeLength = 0;
                        return;
                    }
                    DummyHyphenationManager hm = new DummyHyphenationManager();
                    Hyphenation hyph = hm.getHyphenation(str);
                    int endHyphenIndex = this.hyphen(0, freeSpace - prevAreaWidth, hyph, this.chunk.getFontInfo());
                    if (endHyphenIndex == 0) {
                        if (this.nothingSplitted) {
                            str = hyph.getHyphenText(0, endHyphenIndex + 1);
                            this.addByForce = true;
                            this.nothingSplitted = false;
                            break block19;
                        } else {
                            this.nothingSplitted = true;
                            this.vestigeIndex = this.currentPos;
                            this.vestigeLength = null == currentWord ? this.vestigeLength : currentWord.getLength();
                            return;
                        }
                    }
                    str = hyph.getHyphenText(0, endHyphenIndex);
                }
                this.currentPos += str.length();
                this.vestigeIndex = this.currentPos;
                this.vestigeLength = null == currentWord ? this.vestigeLength - str.length() : currentWord.getLength() - str.length();
                Dimension d = null;
                if (this.addByForce) {
                    d = new Dimension(freeSpace, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
                    this.addByForce = false;
                } else {
                    d = new Dimension(prevAreaWidth + (int)(this.chunk.getFontInfo().getWordWidth(str) * 1000.0f) + this.letterSpacing * str.length(), (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
                }
                String originalText = this.chunk.getText().substring(this.areaStartPos - this.chunk.getOffset(), this.vestigeIndex);
                IArea builtArea = this.buildArea(this.getReverseText(originalText), this.content, this.chunk.getFontInfo(), d);
                PDFTextLM.this.addTextLine(builtArea);
                PDFTextLM.this.newLine();
                return;
            }
            Dimension d = new Dimension(prevAreaWidth, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
            String originalText = this.chunk.getText().substring(this.areaStartPos - this.chunk.getOffset(), this.currentPos);
            IArea builtArea = this.buildArea(this.getReverseText(originalText), this.content, this.chunk.getFontInfo(), d);
            PDFTextLM.this.addTextLine(builtArea);
            PDFTextLM.this.newLine();
            this.vestigeIndex = null == currentWord ? -1 : currentWord.getStart();
            this.vestigeLength = null == currentWord ? 0 : currentWord.getLength();
        }

        private IArea buildArea(String text, ITextContent content, FontInfo fi, Dimension dimension) {
            if (this.isInline) {
                return this.createInlineTextArea(text, content, fi, dimension);
            }
            return PDFTextLM.this.createBlockTextArea(text, content, fi, dimension);
        }

        private int hyphen(int startIndex, int width, Hyphenation hyphenation, FontInfo fi) {
            if (!$assertionsDisabled && startIndex < 0) {
                throw new AssertionError();
            }
            if (startIndex > hyphenation.length() - 1) {
                return -1;
            }
            int last = 0;
            int current = 0;
            for (int i = startIndex + 1; i < hyphenation.length(); ++i) {
                last = current;
                String pre = hyphenation.getHyphenText(startIndex, i);
                current = (int)(fi.getWordWidth(pre) * 1000.0f) + this.letterSpacing * pre.length();
                if (width <= last || width > current) continue;
                return i - 1;
            }
            return hyphenation.length() - 1;
        }

        private String getReverseText(String text) {
            if (this.chunk.getRunDirection() == 0) {
                return text;
            }
            return this.flip(text);
        }

        private String flip(String text) {
            char[] indexChars = text.toCharArray();
            int start = 0;
            int end = indexChars.length;
            int mid = (start + end) / 2;
            --end;
            while (start < mid) {
                char temp = indexChars[start];
                indexChars[start] = indexChars[end];
                indexChars[end] = temp;
                ++start;
                --end;
            }
            return new String(indexChars);
        }

        private boolean isAtLast(int index) {
            return index >= this.content.getText().length();
        }

        private IArea createInlineTextArea(String text, ITextContent content, FontInfo fi, Dimension contentDimension) {
            ContainerArea con = (ContainerArea)PDFTextLM.this.createInlineContainer(content, false, false);
            int textHeight = contentDimension.getHeight();
            int textWidth = contentDimension.getWidth();
            con.setWidth(textWidth);
            con.setHeight(textHeight + this.topPadding + this.topBorder + this.bottomPadding + this.bottomBorder);
            AbstractArea textArea = (AbstractArea)AreaFactory.createTextArea(content, text, fi);
            con.addChild(textArea);
            textArea.setHeight(textHeight);
            textArea.setWidth(textWidth);
            textArea.setPosition(0, this.topPadding + this.topBorder);
            return con;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$engine$layout$pdf$PDFTextLM == null ? (class$org$eclipse$birt$report$engine$layout$pdf$PDFTextLM = PDFTextLM.class$("org.eclipse.birt.report.engine.layout.pdf.PDFTextLM")) : class$org$eclipse$birt$report$engine$layout$pdf$PDFTextLM).desiredAssertionStatus();
        }
    }
}

