/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.util.ArrayList;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;

public class PageHint
implements IPageHint {
    ArrayList sections = new ArrayList();
    protected long pageNumber;
    protected long offset;

    public PageHint() {
        this.pageNumber = 0L;
        this.offset = -1L;
    }

    public PageHint(long pageNumber, long pageOffset) {
        this.pageNumber = pageNumber;
        this.offset = pageOffset;
    }

    public PageHint(long pageNumber, long pageOffset, long pageStart, long pageEnd) {
        this.pageNumber = pageNumber;
        this.offset = pageOffset;
        this.addSection(pageStart, pageEnd);
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public int getSectionCount() {
        return this.sections.size();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSectionStart(int i) {
        PageSection section = (PageSection)this.sections.get(i);
        return section.startOffset;
    }

    public long getSectionEnd(int i) {
        PageSection section = (PageSection)this.sections.get(i);
        return section.endOffset;
    }

    public void addSection(long start, long end) {
        PageSection section = new PageSection();
        section.startOffset = start;
        section.endOffset = end;
        this.sections.add(section);
    }

    public PageSection getSection(int i) {
        return (PageSection)this.sections.get(i);
    }

    public void addSection(PageSection section) {
        this.sections.add(section);
    }
}

