/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.element;

import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IHighLightRule;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;

public class HighLightRuleImpl
implements IHighLightRule {
    private HighlightRuleHandle rule;
    private ReportItemHandle handle;

    public HighLightRuleImpl(HighlightRuleHandle rule, ReportItemHandle handle) {
        this.handle = handle;
        this.rule = rule;
    }

    public String getColor() {
        return this.rule.getColor().getStringValue();
    }

    public String getDateTimeFormat() {
        return this.rule.getDateTimeFormat();
    }

    public String getFontStyle() {
        return this.rule.getFontStyle();
    }

    public String getFontWeight() {
        return this.rule.getFontWeight();
    }

    public String getStringFormat() {
        return this.rule.getStringFormat();
    }

    public String getTestExpression() {
        return this.rule.getTestExpression();
    }

    public void setColor(String color) throws ScriptException {
        this.checkHandle();
        try {
            this.rule.getColor().setStringValue(color);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setDateTimeFormat(String format) throws ScriptException {
        this.checkHandle();
        this.rule.setDateTimeFormat(format);
    }

    public void setFontStyle(String style) throws ScriptException {
        this.checkHandle();
        try {
            this.rule.setFontStyle(style);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setFontWeight(String weight) throws ScriptException {
        this.checkHandle();
        try {
            this.rule.setFontWeight(weight);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setStringFormat(String format) throws ScriptException {
        this.checkHandle();
        this.rule.setStringFormat(format);
    }

    public void setTestExpression(String expression) throws ScriptException {
        this.checkHandle();
        this.rule.setTestExpression(expression);
    }

    private void checkHandle() throws ScriptException {
        if (this.rule != null) {
            return;
        }
        HighlightRule r = new HighlightRule();
        PropertyHandle propHandle = this.handle.getPropertyHandle("highlightRules");
        try {
            this.rule = (HighlightRuleHandle)propHandle.addItem((IStructure)r);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }
}

