/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class AddElementtoReport
extends Action {
    private StructuredViewer viewer;
    private Object element;
    private static final String ACTION_TEXT = Messages.getString((String)"AddElementtoAction.Text");
    private int canContain;
    private Object target;

    public void setSelectedElement(Object element) {
        this.element = element;
    }

    public AddElementtoReport(StructuredViewer viewer) {
        super(ACTION_TEXT);
        this.viewer = viewer;
        this.canContain = 0;
    }

    public boolean isEnabled() {
        Object target;
        this.target = target = this.getTarget();
        return this.canContain(target, this.element);
    }

    public Object getTarget() {
        StructuredSelection strSelection;
        IViewPart viewPart = UIUtil.getView((String)"org.eclipse.ui.views.ContentOutline");
        if (!(viewPart instanceof ContentOutline)) {
            return null;
        }
        ContentOutline outlineView = (ContentOutline)viewPart;
        ISelection selection = outlineView.getSelection();
        if (selection instanceof StructuredSelection && (strSelection = (StructuredSelection)selection).size() == 1) {
            return strSelection.getFirstElement();
        }
        return null;
    }

    public void run() {
        this.copyData(this.target, this.element);
    }

    protected boolean canContain(Object target, Object transfer) {
        if (DNDUtil.handleValidateTargetCanContainMore((Object)target, (int)DNDUtil.getObjectLength((Object)transfer))) {
            this.canContain = DNDUtil.handleValidateTargetCanContain((Object)target, (Object)transfer, (boolean)true);
            return this.canContain == 1;
        }
        return false;
    }

    private int getPosition(Object target) {
        int position = DNDUtil.calculateNextPosition((Object)target, (int)this.canContain);
        if (position > -1) {
            this.target = DNDUtil.getDesignElementHandle((Object)target).getContainerSlotHandle();
        }
        return position;
    }

    protected boolean copyData(Object target, Object transfer) {
        boolean result;
        block10: {
            int position = this.getPosition(target);
            result = false;
            if (transfer != null && transfer instanceof DesignElementHandle) {
                DesignElementHandle sourceHandle = (DesignElementHandle)transfer;
                if (sourceHandle.getRoot() instanceof LibraryHandle) {
                    LibraryHandle library = (LibraryHandle)sourceHandle.getRoot();
                    ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                    try {
                        if (moduleHandle != library) {
                            if (UIUtil.includeLibrary((ModuleHandle)moduleHandle, (LibraryHandle)library)) {
                                DNDUtil.addElementHandle((Object)this.target, (DesignElementHandle)moduleHandle.getElementFactory().newElementFrom(sourceHandle, sourceHandle.getName()));
                                result = true;
                            }
                            break block10;
                        }
                        result = DNDUtil.copyHandles((Object)transfer, (Object)this.target, (int)position);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else {
                    result = DNDUtil.copyHandles((Object)transfer, (Object)this.target, (int)position);
                }
            } else if (transfer != null && transfer instanceof EmbeddedImageHandle) {
                result = DNDUtil.copyHandles((Object)transfer, (Object)target, (int)position);
            }
        }
        if (result) {
            this.viewer.reveal(this.target);
        }
        return result;
    }
}

