/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public class AddSelectedLibToCurrentReportDesignAction
extends Action {
    private StructuredViewer viewer;
    private static final String ACTION_TEXT = Messages.getString((String)"UseLibraryAction.Text");

    public AddSelectedLibToCurrentReportDesignAction(StructuredViewer viewer) {
        super(ACTION_TEXT);
        this.viewer = viewer;
    }

    public boolean isEnabled() {
        boolean enabled;
        LibraryHandle library = this.getSelectedLibrary();
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        boolean bl = enabled = library != null && moduleHandle != null && !moduleHandle.isInclude(library);
        if (library != null) {
            library.close();
        }
        return enabled;
    }

    public void run() {
        if (this.isEnabled()) {
            LibraryHandle library = this.getSelectedLibrary();
            try {
                UIUtil.includeLibrary((LibraryHandle)library);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    private LibraryHandle getSelectedLibrary() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null && selection.getFirstElement() instanceof LibraryHandle) {
            return (LibraryHandle)selection.getFirstElement();
        }
        return null;
    }
}

