/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DeleteLibraryAction
extends Action {
    private static final String ACTION_TEXT = Messages.getString((String)"DeleteLibraryAction.Text");
    private LibraryExplorerTreeViewPage viewerPage;
    private static final String BUNDLE_PROTOCOL = "bundleresource://";

    public DeleteLibraryAction(LibraryExplorerTreeViewPage page) {
        super(ACTION_TEXT);
        this.viewerPage = page;
    }

    public boolean isEnabled() {
        return this.getSelectedLibraries() != null;
    }

    private List getSelectedLibraries() {
        if (this.viewerPage.getTreeViewer().getSelection() == null || this.viewerPage.getTreeViewer().getSelection().isEmpty()) {
            return null;
        }
        ArrayList<LibraryHandle> libraries = new ArrayList<LibraryHandle>();
        List files = ((IStructuredSelection)this.viewerPage.getTreeViewer().getSelection()).toList();
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof LibraryHandle) {
                LibraryHandle library = (LibraryHandle)element;
                if (library.getFileName().startsWith(BUNDLE_PROTOCOL)) {
                    return null;
                }
                libraries.add(library);
                continue;
            }
            return null;
        }
        return libraries.size() > 0 ? libraries : null;
    }

    public void run() {
        List libraries = this.getSelectedLibraries();
        Iterator iter = libraries.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof LibraryHandle)) continue;
            LibraryHandle node = (LibraryHandle)obj;
            try {
                File file = new File(new URL(node.getFileName()).getPath());
                if (!file.exists()) continue;
                file.delete();
            }
            catch (Exception e) {}
        }
        this.viewerPage.refreshRoot();
    }
}

