/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CachePreferencePage
extends AbstractDescriptionPropertyPage {
    private int rowCount = 0;
    private transient PropertyHandle rowCountHandle = null;
    private transient IBaseDataSetDesign dataSetDesign;
    private transient IBaseDataSourceDesign dataSourceDesign;
    private static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.settings");

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString((String)"SettingsPage.label.text"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        Label lab1 = new Label(composite, 0);
        lab1.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 3;
        data = new GridData();
        data.widthHint = 50;
        final Text numText = new Text(composite, 2048);
        numText.setLayoutData((Object)data);
        numText.setData((Object)this.rowCountHandle);
        numText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CachePreferencePage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                CachePreferencePage.this.setRowCount(numText.getText());
            }
        });
        this.initCachePreference();
        numText.setText(Integer.toString(this.rowCount));
        return composite;
    }

    private void setRowCount(String count) {
        try {
            this.rowCount = Integer.parseInt(count);
        }
        catch (NumberFormatException ex) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.settings.errorNumberFormat"), 3);
            this.rowCount = -1;
        }
        if (this.rowCount < 0) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.settings.errorNumberFormat"), 3);
        }
    }

    private void initCachePreference() {
        this.rowCount = ((DataSetHandle)this.getContainer().getModel()).getRowFetchLimit();
        this.rowCountHandle = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("rowFetchLimit");
    }

    public boolean clearCache() {
        try {
            DataEngine dataEngine = DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, null, null, null));
            dataEngine.clearCache(this.dataSourceDesign, this.dataSetDesign);
        }
        catch (BirtException e) {
            e.printStackTrace();
            return true;
        }
        return true;
    }

    public void pageActivated() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean canLeave() {
        if (this.canFinish()) {
            return super.performOk();
        }
        return false;
    }

    public boolean canFinish() {
        if (this.rowCount < 0) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.settings.errorNumberFormat"), 3);
            return false;
        }
        if (this.rowCountHandle != null) {
            try {
                this.rowCountHandle.clearValue();
                this.rowCountHandle.setIntValue(this.rowCount);
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean performOk() {
        if (this.canFinish()) {
            return super.performOk();
        }
        return false;
    }

    public void setBaseDesign(IBaseDataSetDesign baseDataSetDesign, IBaseDataSourceDesign baseDataSourceDesign) {
        this.dataSetDesign = baseDataSetDesign;
        this.dataSourceDesign = baseDataSourceDesign;
    }
}

