/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExpressionProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class DataSetComputedColumnsPage
extends AbstractDescriptionPropertyPage
implements ITableLabelProvider {
    private transient PropertyHandle computedColumns = null;
    private transient PropertyHandleTableViewer viewer = null;
    private ComputedColumn originalStructure = null;
    private static String[] dataTypes = new String[]{"any", "date-time", "decimal", "float", "integer", "string"};
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString((String)"datatypes.any"), Messages.getString((String)"datatypes.dateTime"), Messages.getString((String)"datatypes.decimal"), Messages.getString((String)"datatypes.float"), Messages.getString((String)"datatypes.integer"), Messages.getString((String)"datatypes.string")};
    private static String[] cellLabels = new String[]{Messages.getString((String)"dataset.editor.title.columnName"), Messages.getString((String)"dataset.editor.title.dataType"), Messages.getString((String)"dataset.editor.title.expression")};
    private static String[] cellProperties = new String[]{"name", "dataType", "expression"};

    public Control createContents(Composite parent) {
        this.computedColumns = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("computedColumns");
        this.viewer = new PropertyHandleTableViewer(parent, true, true, true);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[Utility.findIndex(cellProperties, "name")]);
        column.setWidth(150);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[Utility.findIndex(cellProperties, "dataType")]);
        column.setWidth(200);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[Utility.findIndex(cellProperties, "expression")]);
        column.setWidth(200);
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList computedColumnsList = new ArrayList(10);
                Iterator iter = DataSetComputedColumnsPage.this.computedColumns.iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        computedColumnsList.add(iter.next());
                    }
                }
                return computedColumnsList.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)this);
        this.viewer.getViewer().setInput((Object)this.computedColumns);
        this.addListeners();
        this.setToolTips();
        return this.viewer.getControl();
    }

    public void pageActivated() {
        this.refreshColumnNames();
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.computedColumns"), 0);
        this.setPageProperties();
        this.computedColumns = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("computedColumns");
        this.viewer.getViewer().setInput((Object)this.computedColumns);
        this.viewer.getViewer().getTable().select(0);
    }

    private void refreshColumnNames() {
        ((DataSetEditor)this.getContainer()).getCurrentItemModel(true, true);
    }

    private void addListeners() {
        this.viewer.getNewButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.doNew();
            }
        });
        this.viewer.getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DataSetComputedColumnsPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetComputedColumnsPage.this.setPageProperties();
                }
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    private void doNew() {
        this.doEdit(new ComputedColumn());
    }

    private void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        ComputedColumnHandle handle = (ComputedColumnHandle)this.viewer.getViewer().getTable().getItem(index).getData();
        this.originalStructure = (ComputedColumn)handle.getStructure().copy();
        Utility.setStructureProperty(handle.getStructure(), "dataType", this.getTypeDisplayName(Utility.getStructureProperty(handle.getStructure(), "dataType")));
        this.doEdit(handle);
    }

    private void doEdit(Object structureOrHandle) {
        ComputedColumnInputDialog dlg = new ComputedColumnInputDialog(structureOrHandle);
        if (dlg.open() == 0) {
            this.update(structureOrHandle);
        }
    }

    private void update(Object structureOrHandle) {
        ComputedColumn structure = this.getStructure(structureOrHandle);
        try {
            Utility.setProperty(structureOrHandle, "dataType", this.getTypeName(Utility.getStructureProperty((IStructure)structure, "dataType")));
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        if (structureOrHandle instanceof ComputedColumn) {
            ComputedColumn column = (ComputedColumn)structureOrHandle;
            try {
                this.computedColumns.addItem((IStructure)column);
                this.viewer.getViewer().refresh();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        } else {
            this.viewer.getViewer().update(structureOrHandle, null);
        }
        if (this.validateAllComputedColumns()) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.computedColumns"), 0);
        }
    }

    private ComputedColumn getStructure(Object structureOrHandle) {
        ComputedColumn structure = null;
        structure = structureOrHandle instanceof ComputedColumn ? (ComputedColumn)structureOrHandle : (ComputedColumn)((ComputedColumnHandle)structureOrHandle).getStructure();
        return structure;
    }

    private final String getTypeName(String typeDisplayName) {
        for (int n = 0; n < dataTypeDisplayNames.length; ++n) {
            if (!dataTypeDisplayNames[n].equals(typeDisplayName)) continue;
            return dataTypes[n];
        }
        return dataTypes[0];
    }

    private final String getTypeDisplayName(String typeName) {
        for (int n = 0; n < dataTypes.length; ++n) {
            if (!dataTypes[n].equals(typeName)) continue;
            return dataTypeDisplayNames[n];
        }
        return dataTypeDisplayNames[0];
    }

    private void setToolTips() {
        this.viewer.getNewButton().setToolTipText(Messages.getString((String)"DataSetComputedColumnsPage.toolTipText.New"));
        this.viewer.getEditButton().setToolTipText(Messages.getString((String)"DataSetComputedColumnsPage.toolTipText.Edit"));
        this.viewer.getRemoveButton().setToolTipText(Messages.getString((String)"DataSetComputedColumnsPage.toolTipText.Remove"));
        this.viewer.getUpButton().setToolTipText(Messages.getString((String)"DataSetComputedColumnsPage.toolTipText.Up"));
        this.viewer.getDownButton().setToolTipText(Messages.getString((String)"DataSetComputedColumnsPage.toolTipText.Down"));
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = null;
        ComputedColumn computedColumn = this.getStructure(element);
        try {
            switch (columnIndex) {
                case 0: {
                    value = Utility.getStructureProperty((IStructure)computedColumn, "name");
                    break;
                }
                case 1: {
                    value = this.getTypeDisplayName(Utility.getStructureProperty((IStructure)computedColumn, "dataType"));
                    break;
                }
                case 2: {
                    value = Utility.getStructureProperty((IStructure)computedColumn, "expression");
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return value == null ? "" : value;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getPageDescription() {
        return Messages.getString((String)"DataSetComputedColumnsPage.description");
    }

    public boolean performOk() {
        if (this.validateAllComputedColumns()) {
            return super.performOk();
        }
        return false;
    }

    private void setPageProperties() {
        boolean computedColumnsExist = false;
        computedColumnsExist = this.computedColumns != null && this.computedColumns.getListValue() != null && this.computedColumns.getListValue().size() > 0;
        this.viewer.getEditButton().setEnabled(computedColumnsExist);
        this.viewer.getDownButton().setEnabled(computedColumnsExist && this.computedColumns.getListValue().size() > 1);
        this.viewer.getUpButton().setEnabled(computedColumnsExist && this.computedColumns.getListValue().size() > 1);
        this.viewer.getRemoveButton().setEnabled(computedColumnsExist);
        this.viewer.getRemoveMenuItem().setEnabled(computedColumnsExist);
        this.viewer.getRemoveAllMenuItem().setEnabled(computedColumnsExist);
        this.validateAllComputedColumns();
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetComputedColumnsPage.ComputedColumns.Tooltip");
    }

    public boolean canLeave() {
        return this.validateAllComputedColumns();
    }

    private boolean validateAllComputedColumns() {
        Iterator iter;
        if (this.computedColumns != null && (iter = this.computedColumns.iterator()) != null) {
            while (iter.hasNext()) {
                Object o = iter.next();
                ComputedColumn computedColumn = null;
                computedColumn = o instanceof ComputedColumnHandle ? (ComputedColumn)((ComputedColumnHandle)o).getStructure() : (ComputedColumn)o;
                if (this.validateSingleColumn(computedColumn)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateSingleColumn(ComputedColumn computedColumn) {
        if (computedColumn.getName() == null || computedColumn.getName().trim().length() == 0) {
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.missingComputedColumnName", (Object[])new Object[]{computedColumn.getName()}), 3);
            return false;
        }
        if (computedColumn.getExpression() == null || computedColumn.getExpression().trim().length() == 0) {
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.missingComputedColumnExpression", (Object[])new Object[]{computedColumn.getName()}), 3);
            return false;
        }
        return true;
    }

    private class ComputedColumnInputDialog
    extends PropertyHandleInputDialog {
        private ComputedColumn structure;

        private ComputedColumnInputDialog(Object structureOrHandle) {
            super(structureOrHandle);
            this.structure = null;
            this.structure = DataSetComputedColumnsPage.this.getStructure(structureOrHandle);
        }

        protected void createCustomControls(Composite parent) {
            this.createTextCell(parent, Utility.findIndex(cellProperties, "name"));
            this.createComboBoxCell(parent, Utility.findIndex(cellProperties, "dataType"));
            this.createExpressionCell(parent, Utility.findIndex(cellProperties, "expression"));
        }

        private void createTextCell(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            Text tx = ControlProvider.createText(parent, Utility.getStructureProperty((IStructure)this.structure, cellProperties[index]));
            tx.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            tx.addModifyListener(new ModifyListener(this, index, tx){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ Text val$tx;
                private final /* synthetic */ ComputedColumnInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$index = val$index;
                    this.val$tx = val$tx;
                }

                public void modifyText(ModifyEvent e) {
                    Utility.setStructureProperty((IStructure)ComputedColumnInputDialog.access$900(this.this$1), DataSetComputedColumnsPage.access$700()[this.val$index], this.val$tx.getText());
                    this.this$1.validateSyntax();
                }
            });
        }

        private void createComboBoxCell(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            Combo cb = ControlProvider.createCombo(parent, 8);
            cb.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            cb.setItems(dataTypeDisplayNames);
            cb.select(Utility.findIndex(cb.getItems(), Utility.getStructureProperty((IStructure)this.structure, cellProperties[index])));
            cb.addSelectionListener((SelectionListener)new SelectionAdapter(this, index, cb){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ Combo val$cb;
                private final /* synthetic */ ComputedColumnInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$index = val$index;
                    this.val$cb = val$cb;
                }

                public void widgetSelected(SelectionEvent e) {
                    Utility.setStructureProperty((IStructure)ComputedColumnInputDialog.access$900(this.this$1), DataSetComputedColumnsPage.access$700()[this.val$index], this.val$cb.getText());
                    this.this$1.validateSyntax();
                }
            });
            if (this.getStructureOrHandle() instanceof ComputedColumn) {
                Utility.setStructureProperty((IStructure)this.structure, cellProperties[index], cb.getText());
            }
        }

        private void createExpressionCell(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            Composite composite = ControlProvider.getDefaultComposite(parent);
            Text tx = ControlProvider.createText(composite, Utility.getStructureProperty((IStructure)this.structure, cellProperties[index]));
            tx.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            tx.addModifyListener(new ModifyListener(this, index, tx){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ Text val$tx;
                private final /* synthetic */ ComputedColumnInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$index = val$index;
                    this.val$tx = val$tx;
                }

                public void modifyText(ModifyEvent e) {
                    Utility.setStructureProperty((IStructure)ComputedColumnInputDialog.access$900(this.this$1), DataSetComputedColumnsPage.access$700()[this.val$index], this.val$tx.getText());
                    this.this$1.validateSyntax();
                }
            });
            SelectionAdapter listener = new SelectionAdapter(this, tx){
                private final /* synthetic */ Text val$tx;
                private final /* synthetic */ ComputedColumnInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$tx = val$tx;
                }

                public void widgetSelected(SelectionEvent event) {
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.val$tx.getText());
                    expressionBuilder.setExpressionProvier(new DataSetExpressionProvider((DesignElementHandle)ComputedColumnInputDialog.access$1100(this.this$1).getContainer().getModel()));
                    if (expressionBuilder.open() == 0) {
                        this.val$tx.setText(expressionBuilder.getResult().trim());
                    }
                }
            };
            ControlProvider.createButton(composite, 8, (SelectionListener)listener);
        }

        protected IStatus validateSemantics(Object structureOrHandle) {
            for (int i = 0; i < cellProperties.length; ++i) {
                if (!cellProperties[i].equals("name") || this.isUniqueColumnName(structureOrHandle, Utility.getStructureProperty((IStructure)this.structure, cellProperties[i]))) continue;
                return new Status(4, "org.eclipse.ui", 0, Messages.getString((String)"DataSetComputedColumnsPage.duplicatedName"), null);
            }
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }

        private final boolean isUniqueColumnName(Object structureOrHandle, String name) {
            ComputedColumn column = DataSetComputedColumnsPage.this.getStructure(structureOrHandle);
            Iterator iter = DataSetComputedColumnsPage.this.computedColumns.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    ComputedColumnHandle handle = (ComputedColumnHandle)iter.next();
                    if (column == handle.getStructure() || !handle.getName().equals(name)) continue;
                    return false;
                }
            }
            return true;
        }

        protected IStatus validateSyntax(Object structureOrHandle) {
            for (int i = 0; i < cellProperties.length; ++i) {
                if (Utility.getStructureProperty((IStructure)this.structure, cellProperties[i]).trim().length() != 0) continue;
                return this.getBlankPropertyStatus(cellLabels[i]);
            }
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }

        protected void rollback() {
            if (DataSetComputedColumnsPage.this.originalStructure != null) {
                for (int i = 0; i < cellProperties.length; ++i) {
                    Utility.setStructureProperty((IStructure)this.structure, cellProperties[i], Utility.getStructureProperty((IStructure)DataSetComputedColumnsPage.this.originalStructure, cellProperties[i]));
                }
                DataSetComputedColumnsPage.this.originalStructure = null;
            }
        }

        protected String getTitle() {
            return super.getTitle() + " " + Messages.getString((String)"DataSetComputedColumnsPage.title.ComputedColumnInputDialog");
        }

        static /* synthetic */ ComputedColumn access$900(ComputedColumnInputDialog x0) {
            return x0.structure;
        }

        static /* synthetic */ DataSetComputedColumnsPage access$1100(ComputedColumnInputDialog x0) {
            return x0.DataSetComputedColumnsPage.this;
        }
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetComputedColumnsPage.this.setPageProperties();
        }
    }
}

