/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IParameterMetaData;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.ParameterComboCellEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.processor.ElementProcessorFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterDialog;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPageContainer;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.adapter.oda.ReportParameterAdapter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DataSetParametersPage
extends AbstractDescriptionPropertyPage
implements Listener {
    private boolean modelChanged = true;
    private PropertyHandle parameters;
    private PropertyHandleTableViewer viewer;
    private DataSetParameter originalStructure = null;
    private DataSetParameter newParameter = null;
    private boolean isDirectionSet = false;
    private boolean isDataTypeSet = false;
    private String parameterName;
    private boolean isOdaParameterStructure = true;
    private boolean isJointDataSet = false;
    private static IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getStructure("DataSetParam").getMember("dataType").getAllowedChoices().getChoices();
    private static String[] directions = new String[]{Messages.getString((String)"label.input"), Messages.getString((String)"label.output"), Messages.getString((String)"label.inputOutput")};
    private static String NAME = "name";
    private static String DATA_TYPE = "parameterDataType";
    private static String INPUT = "input";
    private static String OUTPUT = "output";
    private static String DEFAULT_VALUE = "defaultValue";
    private static String PARAM_NAME = "paramName";
    private static String NULLABLE = "allowNull";
    private static String OPTIONAL = "isOptional";
    private static String DIRECTION = "direction";
    private static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.parameters");
    private static String ERROR_DLG_TITLE = Messages.getString((String)"DataSetParametersPage.ErrorTitle.InvalidInput");
    private static String ERROR_MSG_EMPTY_COLUMN_NAME = Messages.getString((String)"DataSetParametersPage.ErrorMessage.CanootBeNull");
    private static String NONE_DEFAULT_VALUE = Messages.getString((String)"DataSetParametersPage.default.None");
    private static String UNLINKED_REPORT_PARAM = Messages.getString((String)"DataSetParametersPage.reportParam.None");
    private static String[] cellLabels = new String[]{Messages.getString((String)"dataset.editor.title.name"), Messages.getString((String)"dataset.editor.title.dataType"), Messages.getString((String)"dataset.editor.title.direction"), Messages.getString((String)"dataset.editor.title.defaultValue"), Messages.getString((String)"DataSetParameterPage.cell.linkToSalarParameter")};
    private static String[] cellProperties = new String[]{"name", "dataType", DIRECTION, "defaultValue", "paramName"};
    static /* synthetic */ Class class$org$eclipse$birt$report$designer$data$ui$dataset$DataSetParametersPage;

    public void setContainer(IPropertyPageContainer container) {
        super.setContainer(container);
        this.parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
        Iterator it = this.parameters.iterator();
        if (it != null) {
            while (it.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)it.next();
                if (parameter.getPosition() != null && parameter.getPosition() > 0 && parameter.getPosition() <= this.parameters.getListValue().size()) continue;
                MessageDialog.openWarning(null, (String)Messages.getString((String)"dataset.editor.error.title"), (String)Messages.getFormattedString((String)"dataset.editor.warning.correctParameter", (Object[])new Object[]{"aa"}));
            }
        }
        this.refreshPositions();
    }

    public Control createContents(Composite parent) {
        this.isJointDataSet = (DataSetHandle)this.getContainer().getModel() instanceof JointDataSetHandle;
        this.isOdaParameterStructure = (DataSetHandle)this.getContainer().getModel() instanceof OdaDataSetHandle;
        return this.createParameterPageControl(parent);
    }

    private Control createParameterPageControl(Composite parent) {
        this.viewer = new PropertyHandleTableViewer(parent, true, true, true){

            void doRemove() {
                super.doRemove();
                DataSetParametersPage.this.refreshMessage();
            }
        };
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(" ");
        column.setResizable(false);
        column.setWidth(19);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.name"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.dataType"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.direction"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.defaultValue"));
        column.setWidth(100);
        if (this.isOdaParameterStructure) {
            column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
            column.setText(Messages.getString((String)"DataSetParameterPage.cell.linkToSalarParameter"));
            column.setWidth(180);
        }
        this.viewer.getViewer().setContentProvider((IContentProvider)new ParameterViewContentProvider());
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new ParameterViewLableProvider(this.isOdaParameterStructure));
        this.viewer.getViewer().setInput((Object)this.parameters);
        this.addRefreshMenu();
        this.addListeners();
        this.setToolTips();
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        return this.viewer.getControl();
    }

    private void addRefreshMenu() {
        MenuItem itmRefresh = new MenuItem(this.viewer.getMenu(), 0, 0);
        new MenuItem(this.viewer.getMenu(), 2, 1);
        itmRefresh.setText(Messages.getString((String)"parameters.menuItem.refresh"));
        itmRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyHandle handle = (PropertyHandle)DataSetParametersPage.this.viewer.getViewer().getInput();
                try {
                    handle.clearValue();
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
                DataSetParametersPage.this.refreshParameters();
                DataSetParametersPage.this.viewer.getViewer().refresh();
            }
        });
    }

    protected final void setupEditors() {
        String[] dataTypeDisplayNames = new String[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            dataTypeDisplayNames[i] = dataTypes[i].getDisplayName();
        }
        CellEditor[] editors = new CellEditor[6];
        editors[1] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        editors[2] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), dataTypeDisplayNames, 8);
        editors[3] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), this.getDirections(), 8);
        ExpressionCellEditor editor = new ExpressionCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        editors[4] = editor;
        List parameterList = Utility.getAllParameters();
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(UNLINKED_REPORT_PARAM);
        for (int i = 0; i < parameterList.size(); ++i) {
            ReportElementHandle handle = (ReportElementHandle)parameterList.get(i);
            if (!(handle instanceof ScalarParameterHandle)) continue;
            nameList.add(handle.getQualifiedName());
        }
        String[] paramName = new String[nameList.size()];
        for (int i = 0; i < nameList.size(); ++i) {
            paramName[i] = nameList.get(i).toString();
        }
        final ParameterComboCellEditor editor2 = new ParameterComboCellEditor((Composite)this.viewer.getViewer().getTable(), paramName, 8);
        editor2.addScalarParmeterLister(new ScalarParameterListener());
        editors[5] = editor2;
        this.viewer.getViewer().setColumnProperties(new String[]{"", NAME, DATA_TYPE, DIRECTION, DEFAULT_VALUE, PARAM_NAME});
        this.viewer.getViewer().setCellEditors(editors);
        this.viewer.getViewer().setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (DataSetParametersPage.this.isJointDataSet) {
                    return false;
                }
                DataSetParametersPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                if (property.equals(DEFAULT_VALUE) || property.equals(PARAM_NAME) || property.equals(NULLABLE) || property.equals(OPTIONAL)) {
                    Boolean isInput = null;
                    try {
                        if (property.equals(DEFAULT_VALUE)) {
                            if (Utility.getProperty(element, PARAM_NAME) != null) {
                                return false;
                            }
                        } else if (property.equals(PARAM_NAME)) {
                            editor2.setInput(element);
                        }
                        isInput = (Boolean)Utility.getProperty(element, INPUT);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle(ex);
                    }
                    if (isInput == null || !isInput.booleanValue()) {
                        return false;
                    }
                }
                return element != DataSetParametersPage.this.newParameter || property.equals(NAME);
            }

            public Object getValue(Object element, String property) {
                Object value = null;
                try {
                    value = property.equals(DIRECTION) ? new Integer(DataSetParametersPage.this.getDirectionIndex((Boolean)Utility.getProperty(element, INPUT), (Boolean)Utility.getProperty(element, OUTPUT))) : (property.equals(NULLABLE) ? new Boolean(true) : Utility.getProperty(element, property));
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                if (property.equals(OPTIONAL)) {
                    if (value == null) {
                        value = new Boolean(false);
                    }
                    value = (Boolean)value != false ? new Integer(0) : new Integer(1);
                } else if (property.equals(NULLABLE)) {
                    if (value == null) {
                        value = new Boolean(true);
                    }
                    value = (Boolean)value != false ? new Integer(0) : new Integer(1);
                } else if (property.equals(DATA_TYPE)) {
                    value = new Integer(DataSetParametersPage.this.getTypeIndex((String)value));
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                Object actualElement = ((TableItem)element).getData();
                Object finalValue = value;
                String finalProperty = property;
                if (property.equals(DIRECTION)) {
                    int selection = (Integer)finalValue;
                    char ch = Character.toUpperCase(INPUT.charAt(0));
                    StringBuffer sbFinalProperty = new StringBuffer();
                    sbFinalProperty.append("is").append(ch).append(INPUT.substring(1));
                    try {
                        Utility.setProperty(actualElement, sbFinalProperty.toString(), selection == 0 || selection == 2 ? new Boolean(true) : new Boolean(false));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ch = Character.toUpperCase(OUTPUT.charAt(0));
                    sbFinalProperty.setLength(0);
                    sbFinalProperty.append("is").append(ch).append(OUTPUT.substring(1));
                    finalProperty = sbFinalProperty.toString();
                    Object object = finalValue = selection == 1 || selection == 2 ? new Boolean(true) : new Boolean(false);
                    if (selection == 1) {
                        try {
                            Utility.setProperty(actualElement, PARAM_NAME, null);
                            Utility.setProperty(actualElement, DEFAULT_VALUE, null);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (actualElement == DataSetParametersPage.this.newParameter) {
                        DataSetParametersPage.this.isDirectionSet = true;
                    }
                } else if (property.equals(DATA_TYPE)) {
                    int selectedType = (Integer)value;
                    finalValue = selectedType > 0 ? dataTypes[selectedType].getName() : null;
                } else if (property.equals(NAME)) {
                    if (actualElement != DataSetParametersPage.this.newParameter && (finalValue == null || ((String)finalValue).trim().length() == 0)) {
                        ExceptionHandler.openMessageBox(ERROR_DLG_TITLE, ERROR_MSG_EMPTY_COLUMN_NAME, 2);
                        DataSetParametersPage.this.viewer.getViewer().update(actualElement, null);
                        return;
                    }
                    if (!DataSetParametersPage.this.isUniqueName(actualElement, (String)finalValue)) {
                        DataSetParametersPage.this.viewer.getViewer().update(actualElement, null);
                        return;
                    }
                } else if (property.equals(PARAM_NAME) && UNLINKED_REPORT_PARAM.equals(finalValue.toString())) {
                    finalValue = null;
                }
                try {
                    Utility.setProperty(actualElement, finalProperty, finalValue);
                    DataSetParametersPage.this.viewer.getViewer().update(actualElement, null);
                    if (actualElement == DataSetParametersPage.this.newParameter) {
                        DataSetParametersPage.this.isDataTypeSet = true;
                        if (DataSetParametersPage.this.newParameter.getName() != null && DataSetParametersPage.this.newParameter.getName().trim().length() > 0) {
                            DataSetParametersPage.this.parameters.addItem((IStructure)DataSetParametersPage.this.newParameter);
                            DataSetParametersPage.this.clearNewParameter();
                            DataSetParametersPage.this.viewer.getViewer().refresh();
                        }
                    }
                    DataSetParametersPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle(ex);
                }
            }
        });
    }

    private String[] getDirections() {
        boolean supportInput = ((DataSetEditor)this.getContainer()).supportsInParameters();
        boolean supportOutput = ((DataSetEditor)this.getContainer()).supportsOutputParameters();
        String[] directions = supportInput && supportOutput ? new String[]{Messages.getString((String)"label.input"), Messages.getString((String)"label.output"), Messages.getString((String)"label.inputOutput")} : (supportInput ? new String[]{Messages.getString((String)"label.input")} : (supportOutput ? new String[]{Messages.getString((String)"label.output")} : new String[]{Messages.getString((String)"label.input"), Messages.getString((String)"label.output"), Messages.getString((String)"label.inputOutput")}));
        return directions;
    }

    private void addListeners() {
        this.viewer.getNewButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.doNew();
            }
        });
        this.viewer.getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DataSetParametersPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetParametersPage.this.removeSelectedItem();
                    DataSetParametersPage.this.setPageProperties();
                }
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.removeSelectedItem();
                DataSetParametersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.removeSelectedItem();
                DataSetParametersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetParametersPage.this.removeAllItem();
                DataSetParametersPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    private void doNew() {
        Object newParam = null;
        newParam = this.isOdaParameterStructure ? new OdaDataSetParameter() : new DataSetParameter();
        int position = this.viewer.getViewer().getTable().getItemCount();
        newParam.setName(this.getUniqueName());
        newParam.setPosition(new Integer(position + 1));
        this.doEdit(newParam);
    }

    private void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        DataSetParameterHandle handle = (DataSetParameterHandle)this.viewer.getViewer().getTable().getItem(index).getData();
        this.originalStructure = (DataSetParameter)handle.getStructure().copy();
        this.doEdit(handle);
    }

    private void doEdit(Object structureOrHandle) {
        ParameterInputDialog dlg = new ParameterInputDialog(structureOrHandle);
        if (dlg.open() == 0) {
            this.update(dlg.structureHandle);
        }
    }

    private void update(DataSetParameterHandle dataSetParameterHandle) {
        this.viewer.getViewer().update((Object)dataSetParameterHandle, null);
        this.viewer.getViewer().refresh();
        this.refreshMessage();
    }

    private void refreshMessage() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        if (!this.doSaveEmptyParameter(this.parameters)) {
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.noInputParameterDefaultValue", (Object[])new Object[]{this.getNoneValuedParameterName()}), 3);
        }
    }

    private DataSetParameter getStructure(Object structureOrHandle) {
        DataSetParameter structure = null;
        structure = structureOrHandle instanceof DataSetParameter ? (DataSetParameter)structureOrHandle : (DataSetParameter)((DataSetParameterHandle)structureOrHandle).getStructure();
        return structure;
    }

    private void setToolTips() {
        this.viewer.getNewButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.New"));
        this.viewer.getEditButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Edit"));
        this.viewer.getRemoveButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Remove"));
        this.viewer.getUpButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Up"));
        this.viewer.getDownButton().setToolTipText(Messages.getString((String)"DataSetParameterPage.toolTipText.Down"));
    }

    protected final int getDirectionIndex(Boolean isInput, Boolean isOutput) {
        boolean output;
        boolean input = isInput == null ? false : isInput;
        boolean bl = output = isOutput == null ? false : isOutput;
        if (input && output) {
            return 2;
        }
        if (output) {
            return 1;
        }
        return 0;
    }

    protected final String getDirectionDisplayName(boolean isInput, boolean isOutput) {
        if (isInput && isOutput) {
            return directions[2];
        }
        if (isOutput) {
            return directions[1];
        }
        return directions[0];
    }

    private final int getTypeIndex(String dataTypeName) {
        for (int n = 0; n < dataTypes.length; ++n) {
            if (!dataTypes[n].getName().equals(dataTypeName)) continue;
            return n;
        }
        return 0;
    }

    public void pageActivated() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        if (!this.doSaveEmptyParameter(this.parameters)) {
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.noInputParameterDefaultValue", (Object[])new Object[]{this.getNoneValuedParameterName()}), 3);
        }
        if (this.viewer != null) {
            this.viewer.getViewer().refresh();
        }
        this.setPageProperties();
        this.viewer.getViewer().getTable().select(0);
    }

    private void refreshParameters() {
        try {
            DataSetHandle ds = (DataSetHandle)this.getContainer().getModel();
            Collection paramsFromDataSet = null;
            paramsFromDataSet = DataSetProvider.getCurrentInstance().getParametersFromDataSet(ds);
            if (paramsFromDataSet != null) {
                Iterator iter = paramsFromDataSet.iterator();
                while (iter.hasNext()) {
                    IParameterMetaData paramFromDataSet = (IParameterMetaData)iter.next();
                    DataSetParameter parameter = null;
                    parameter = paramFromDataSet.getPosition() > 0 ? this.findParameterByPosition(paramFromDataSet.getPosition()) : this.findParameterByName(paramFromDataSet.getName());
                    if (parameter != null) {
                        DataSetParameter newParameter = this.newParameter(paramFromDataSet);
                        if (this.isSameParameters(parameter, newParameter)) continue;
                        this.parameters.replaceItem((IStructure)parameter, (IStructure)newParameter);
                        continue;
                    }
                    this.parameters.addItem((IStructure)this.newParameter(paramFromDataSet));
                }
                if (this.parameters.getListValue() != null && paramsFromDataSet.size() < this.parameters.getListValue().size()) {
                    int size = this.parameters.getListValue().size();
                    while (size > paramsFromDataSet.size()) {
                        this.parameters.removeItem(size - 1);
                        size = this.parameters.getListValue().size();
                    }
                }
            } else if (this.viewer != null) {
                PropertyHandle handle = (PropertyHandle)this.viewer.getViewer().getInput();
                handle.clearValue();
            }
            this.refreshPositions();
            this.setPageProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private DataSetParameter newParameter(IParameterMetaData paramFromDataSet) {
        Object parameter = null;
        parameter = this.isOdaParameterStructure ? new OdaDataSetParameter() : new DataSetParameter();
        try {
            parameter.setParameterDataType(DataSetParametersPage.toModelDataType(paramFromDataSet.getDataTypeName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        parameter.setDefaultValue(paramFromDataSet.getDefaultInputValue());
        if (paramFromDataSet.isOptional() != null) {
            parameter.setIsOptional(paramFromDataSet.isOptional().booleanValue());
        }
        if (paramFromDataSet.isNullable() != null) {
            parameter.setAllowNull(paramFromDataSet.isNullable().booleanValue());
        }
        if (paramFromDataSet.isInputMode() != null) {
            parameter.setIsInput(paramFromDataSet.isInputMode().booleanValue());
        }
        if (paramFromDataSet.isOutputMode() != null) {
            parameter.setIsOutput(paramFromDataSet.isOutputMode().booleanValue());
        }
        if (paramFromDataSet.isInputMode() == null && paramFromDataSet.isOutputMode() == null || !parameter.isInput() && !parameter.isOutput()) {
            parameter.setIsInput(true);
        }
        parameter.setName(paramFromDataSet.getName());
        if (parameter.getName() == null) {
            parameter.setName(this.getUniqueName());
        }
        return parameter;
    }

    private boolean isSameParameters(DataSetParameter param1, DataSetParameter param2) {
        boolean isSame = false;
        if (param1 == param2) {
            isSame = true;
        } else if (param1 == null || param2 == null) {
            isSame = false;
        } else if (param1.getParameterDataType().equals(param2.getParameterDataType()) && param1.isInput() == param2.isInput() && param1.isOutput() == param2.isOutput()) {
            isSame = true;
        }
        return isSame;
    }

    private static String toModelDataType(String dteDTName) {
        if (dteDTName == null) {
            return null;
        }
        String modelDataType = dteDTName;
        if (dteDTName.equals(DataType.INTEGER_TYPE_NAME)) {
            modelDataType = "integer";
        } else if (dteDTName.equals(DataType.DOUBLE_TYPE_NAME)) {
            modelDataType = "float";
        } else if (dteDTName.equals(DataType.DECIMAL_TYPE_NAME)) {
            modelDataType = "decimal";
        } else if (dteDTName.equals(DataType.STRING_TYPE_NAME)) {
            modelDataType = "string";
        } else if (dteDTName.equals(DataType.DATE_TYPE_NAME)) {
            modelDataType = "dateTime";
        } else if (dteDTName.equals(DataType.BOOLEAN_TYPE_NAME)) {
            modelDataType = "boolean";
        }
        return modelDataType;
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        this.modelChanged = true;
    }

    protected final DataSetParameter findParameterByPosition(int position) {
        Iterator iter;
        if (this.parameters != null && (iter = this.parameters.iterator()) != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (parameter.getPosition() == null || parameter.getPosition() != position) continue;
                return (DataSetParameter)parameter.getStructure();
            }
        }
        return null;
    }

    protected final DataSetParameter findParameterByName(String name) {
        Iterator iter;
        if (this.parameters != null && (iter = this.parameters.iterator()) != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (name == null || !name.equals(parameter.getName())) continue;
                return (DataSetParameter)parameter.getStructure();
            }
        }
        return null;
    }

    protected final void refreshPositions() {
        if (this.parameters != null) {
            int position = 1;
            Iterator iter = this.parameters.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                    parameter.setPosition(new Integer(position++));
                }
            }
        }
    }

    protected final String getUniqueName() {
        int n = 1;
        String prefix = "param";
        StringBuffer buf = new StringBuffer();
        while (buf.length() == 0) {
            Iterator iter;
            buf.append(prefix).append(n++);
            if (this.parameters == null || (iter = this.parameters.iterator()) == null) continue;
            while (iter.hasNext() && buf.length() > 0) {
                DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                if (!buf.toString().equalsIgnoreCase(parameter.getName())) continue;
                buf.setLength(0);
            }
        }
        return buf.toString();
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public boolean performOk() {
        if (this.doSaveEmptyParameter(this.parameters)) {
            this.refreshPositions();
            if (this.modelChanged && this.getContainer() != null && this.getContainer() instanceof DataSetEditor) {
                this.modelChanged = false;
                ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
                ((DataSetEditor)this.getContainer()).updateDataSetDesign("parameters");
            }
            return super.performOk();
        }
        String name = this.getNoneValuedParameterName();
        boolean confirm = MessageDialog.openConfirm(null, (String)Messages.getString((String)"dataset.editor.error.title"), (String)Messages.getFormattedString((String)"dataset.editor.error.validationParameter", (Object[])new Object[]{name}));
        if (confirm) {
            ((DataSetEditor)this.getContainer()).updateDataSetDesign("parameters");
        }
        return confirm;
    }

    private boolean doSaveEmptyParameter(PropertyHandle parameters) {
        if (parameters == null) {
            parameters = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("parameters");
            this.isOdaParameterStructure = (DataSetHandle)this.getContainer().getModel() instanceof OdaDataSetHandle;
        }
        if (parameters != null) {
            Iterator iter = parameters.iterator();
            String paramName = null;
            if (iter != null) {
                while (iter.hasNext()) {
                    DataSetParameterHandle parameter = (DataSetParameterHandle)iter.next();
                    if (this.isOdaParameterStructure) {
                        paramName = ((OdaDataSetParameterHandle)parameter).getParamName();
                    }
                    if (!parameter.isInput() || paramName != null || parameter.getDefaultValue() != null && parameter.getDefaultValue().trim().length() != 0 && !parameter.getDefaultValue().trim().equalsIgnoreCase("null")) continue;
                    this.setNoneValuedParameterName(parameter.getName());
                    return false;
                }
            }
        }
        return true;
    }

    public boolean canLeave() {
        this.refreshPositions();
        if (this.modelChanged && this.getContainer() != null && this.getContainer() instanceof DataSetEditor) {
            this.modelChanged = false;
            ((DataSetEditor)this.getContainer()).updateDataSetDesign("parameters");
        }
        return true;
    }

    public boolean canFinish() {
        this.refreshPositions();
        return this.doSaveEmptyParameter(this.parameters);
    }

    private void clearNewParameter() {
        this.newParameter = null;
        this.isDirectionSet = false;
        this.isDataTypeSet = false;
        this.viewer.getViewer().refresh();
    }

    private void removeSelectedItem() {
        int count;
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        int n = count = this.parameters.getListValue() == null ? 0 : this.parameters.getListValue().size();
        if (index == count) {
            this.clearNewParameter();
            this.viewer.getViewer().refresh();
        }
    }

    private void removeAllItem() {
        this.clearNewParameter();
        this.viewer.getViewer().refresh();
    }

    private boolean isUniqueName(Object dataSetParameter, String name) {
        DataSetParameter parameter = null;
        parameter = dataSetParameter instanceof DataSetParameterHandle ? (DataSetParameter)((DataSetParameterHandle)dataSetParameter).getStructure() : (DataSetParameter)dataSetParameter;
        Iterator iter = this.parameters.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                DataSetParameterHandle handle = (DataSetParameterHandle)iter.next();
                if (parameter == handle.getStructure() || !handle.getName().equals(name)) continue;
                this.getContainer().setMessage(Messages.getString((String)"dataset.editor.error.duplicateParameterName"), 3);
                return false;
            }
        }
        return true;
    }

    private void setPageProperties() {
        boolean parametersExist = false;
        boolean bl = parametersExist = this.parameters != null && this.parameters.getListValue() != null && this.parameters.getListValue().size() > 0;
        if (this.viewer != null) {
            this.viewer.getDownButton().setEnabled(parametersExist && this.parameters.getListValue().size() > 1);
            this.viewer.getUpButton().setEnabled(parametersExist && this.parameters.getListValue().size() > 1);
            this.viewer.getEditButton().setEnabled(parametersExist);
            this.viewer.getRemoveButton().setEnabled(parametersExist && !this.isJointDataSet);
            this.viewer.getRemoveMenuItem().setEnabled(parametersExist && !this.isJointDataSet);
            this.viewer.getRemoveAllMenuItem().setEnabled(parametersExist && !this.isJointDataSet);
        }
        if (!parametersExist) {
            this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        }
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetParametersPage.Filter.Tooltip");
    }

    public String getNoneValuedParameterName() {
        return this.parameterName;
    }

    private void setNoneValuedParameterName(String name) {
        this.parameterName = name;
    }

    private void enableModelChanged() {
        ((DataSetEditor)this.getContainer()).enableLinkedParamChanged();
    }

    private String getTypeDisplayName(String typeName) {
        String displayName = dataTypes[1].getDisplayName();
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!dataTypes[i].getName().equals(typeName)) continue;
            return dataTypes[i].getDisplayName();
        }
        return displayName;
    }

    private String getTypeName(String typeDisplayName) {
        String name = dataTypes[1].getName();
        for (int i = 0; i < dataTypes.length; ++i) {
            if (!dataTypes[i].getDisplayName().equals(typeDisplayName)) continue;
            return dataTypes[i].getName();
        }
        return name;
    }

    private class ParameterInputDialog
    extends PropertyHandleInputDialog {
        private DataSetParameterHandle structureHandle;
        private Composite defaultValueComposite;
        private Composite reportParamComposite;
        private String reportParamName;
        private Text dataSetParamName;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected ParameterInputDialog(Object structureOrHandle) {
            super(structureOrHandle);
            this.structureHandle = null;
            this.defaultValueComposite = null;
            this.reportParamComposite = null;
            this.reportParamName = "";
            this.dataSetParamName = null;
            this.structureHandle = this.getStructureHandle(structureOrHandle);
        }

        protected void createCustomControls(Composite parent) {
            this.createTextCell(parent, Utility.findIndex(cellProperties, "name"));
            this.createComboCellDataType(parent, Utility.findIndex(cellProperties, "dataType"));
            this.createComboCellDirection(parent, Utility.findIndex(cellProperties, DIRECTION));
            this.createExpressionCell(parent, Utility.findIndex(cellProperties, "defaultValue"));
            if (DataSetParametersPage.this.isOdaParameterStructure) {
                this.createComboCellParameter(parent, Utility.findIndex(cellProperties, "paramName"));
            }
        }

        private void createTextCell(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            this.dataSetParamName = ControlProvider.createText(parent, this.structureHandle.getName());
            this.dataSetParamName.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.dataSetParamName.addModifyListener(new ModifyListener(this, index){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$index = val$index;
                }

                public void modifyText(ModifyEvent e) {
                    try {
                        if (ParameterInputDialog.access$4100(this.this$1).getText().trim().length() == 0) {
                            ParameterInputDialog.access$4200(this.this$1, (IStatus)this.this$1.getBlankPropertyStatus(DataSetParametersPage.access$4000()[this.val$index]));
                        } else {
                            ParameterInputDialog.access$3300(this.this$1).setName(ParameterInputDialog.access$4100(this.this$1).getText());
                            this.this$1.validateSyntax();
                        }
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                }
            });
        }

        private void createComboCellDataType(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            Combo cb = ControlProvider.createCombo(parent, 8);
            cb.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            cb.setItems(this.getDataTypeDisplayNames());
            cb.select(Utility.findIndex(cb.getItems(), DataSetParametersPage.this.getTypeDisplayName(this.structureHandle.getParameterDataType())));
            cb.addSelectionListener((SelectionListener)new SelectionAdapter(this, cb){
                private final /* synthetic */ Combo val$cb;
                private final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$cb = val$cb;
                }

                public void widgetSelected(SelectionEvent e) {
                    try {
                        ParameterInputDialog.access$3300(this.this$1).setParameterDataType(DataSetParametersPage.access$4400(ParameterInputDialog.access$4300(this.this$1), this.val$cb.getText()));
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                    this.this$1.validateSyntax();
                }
            });
            if (this.getStructureOrHandle() instanceof DataSetParameter) {
                try {
                    this.structureHandle.setParameterDataType(DataSetParametersPage.this.getTypeName(cb.getText()));
                }
                catch (SemanticException e1) {
                    ExceptionHandler.handle(e1);
                }
            }
        }

        private String[] getDataTypeDisplayNames() {
            String[] dataTypeDisplayNames = new String[dataTypes.length];
            for (int i = 0; i < dataTypes.length; ++i) {
                dataTypeDisplayNames[i] = dataTypes[i].getDisplayName();
            }
            return dataTypeDisplayNames;
        }

        private void createComboCellDirection(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            Combo cb = ControlProvider.createCombo(parent, 8);
            cb.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            cb.setItems(DataSetParametersPage.this.getDirections());
            cb.select(Utility.findIndex(cb.getItems(), DataSetParametersPage.this.getDirectionDisplayName(this.structureHandle.isInput(), this.structureHandle.isOutput())));
            cb.addSelectionListener((SelectionListener)new SelectionAdapter(this, cb){
                private final /* synthetic */ Combo val$cb;
                private final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$cb = val$cb;
                }

                public void widgetSelected(SelectionEvent e) {
                    ParameterInputDialog.access$4600(this.this$1, this.val$cb.getText());
                    this.this$1.validateSyntax();
                }
            });
            if (this.getStructureOrHandle() instanceof DataSetParameter) {
                this.setDirection(cb.getText());
            }
        }

        private void setDirection(String direction) {
            if (direction == null || direction.equals("")) {
                return;
            }
            if (direction.equals(directions[0])) {
                this.structureHandle.setIsInput(true);
                this.structureHandle.setIsOutput(false);
            } else if (direction.equals(directions[1])) {
                this.structureHandle.setIsInput(false);
                this.structureHandle.setIsOutput(true);
            } else if (direction.equals(directions[2])) {
                this.structureHandle.setIsInput(true);
                this.structureHandle.setIsOutput(true);
            }
        }

        private void createExpressionCell(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            this.defaultValueComposite = ControlProvider.getDefaultComposite(parent);
            Text tx = ControlProvider.createText(this.defaultValueComposite, Utility.getNonNullString(this.structureHandle.getDefaultValue()));
            tx.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            tx.addModifyListener(new ModifyListener(this, tx){
                private final /* synthetic */ Text val$tx;
                private final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$tx = val$tx;
                }

                public void modifyText(ModifyEvent e) {
                    if (this.val$tx.isEnabled() && !this.val$tx.getText().equals(ParameterInputDialog.access$3300(this.this$1).getDefaultValue())) {
                        ParameterInputDialog.access$3300(this.this$1).setDefaultValue(this.val$tx.getText());
                        this.this$1.validateSyntax();
                    }
                }
            });
            SelectionAdapter listener = new SelectionAdapter(this, tx){
                private final /* synthetic */ Text val$tx;
                private final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$tx = val$tx;
                }

                public void widgetSelected(SelectionEvent event) {
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.val$tx.getText());
                    expressionBuilder.setExpressionProvier(null);
                    if (expressionBuilder.open() == 0) {
                        this.val$tx.setText(expressionBuilder.getResult().trim());
                    }
                }
            };
            ControlProvider.createButton(this.defaultValueComposite, 8, (SelectionListener)listener);
        }

        private void createComboCellParameter(Composite parent, int index) {
            ControlProvider.createLabel(parent, cellLabels[index]);
            this.reportParamComposite = ControlProvider.getDefaultComposite(parent);
            Combo cb = new Combo(this.reportParamComposite, 8);
            cb.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            cb.setItems(this.getParameterNames());
            cb.select(Utility.findIndex(cb.getItems(), ((OdaDataSetParameterHandle)this.structureHandle).getParamName()));
            cb.addSelectionListener((SelectionListener)new SelectionAdapter(this, cb){
                private final /* synthetic */ Combo val$cb;
                private final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$cb = val$cb;
                }

                public void widgetSelected(SelectionEvent e) {
                    ((OdaDataSetParameterHandle)ParameterInputDialog.access$3300(this.this$1)).setParamName(Utility.findIndex(this.val$cb.getItems(), this.val$cb.getText()) == 0 ? null : this.val$cb.getText());
                    this.this$1.validateSyntax();
                }
            });
            cb.addModifyListener(new ModifyListener(this, cb){
                private final /* synthetic */ Combo val$cb;
                private final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$cb = val$cb;
                }

                public void modifyText(ModifyEvent e) {
                    ((OdaDataSetParameterHandle)ParameterInputDialog.access$3300(this.this$1)).setParamName(Utility.findIndex(this.val$cb.getItems(), this.val$cb.getText()) == 0 ? null : this.val$cb.getText());
                    this.this$1.validateSyntax();
                }
            });
            SelectionAdapter listener = new SelectionAdapter(this, cb){
                private final /* synthetic */ Combo val$cb;
                private final /* synthetic */ ParameterInputDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$cb = val$cb;
                }

                public void widgetSelected(SelectionEvent event) {
                    OdaDataSetParameterHandle dataSetParameterHandle = (OdaDataSetParameterHandle)ParameterInputDialog.access$3300(this.this$1);
                    String originalParamName = dataSetParameterHandle.getParamName();
                    ParameterDialog dialog = null;
                    ScalarParameterHandle handle = Utility.getScalarParameter(this.val$cb.getText());
                    boolean isCreateMode = true;
                    if (handle == null) {
                        handle = (ScalarParameterHandle)ElementProcessorFactory.createProcessor("ScalarParameter").createElement(null);
                        dialog = new ParameterDialog(Messages.getString((String)"ParameterGroupNodeProvider.Dialogue.ParameterNew"));
                        if (dataSetParameterHandle != null) {
                            ReportParameterAdapter adapter = new ReportParameterAdapter();
                            try {
                                adapter.updateLinkedReportParameter(handle, dataSetParameterHandle, ((DataSetEditor)ParameterInputDialog.access$4300(this.this$1).getContainer()).getCurrentDataSetDesign());
                            }
                            catch (SemanticException e) {
                            }
                            catch (OdaException e) {
                                // empty catch block
                            }
                        }
                        isCreateMode = true;
                    } else {
                        dialog = new ParameterDialog(Messages.getString((String)"ParameterNodeProvider.dial.title.editScalar"));
                        isCreateMode = false;
                    }
                    handle.addListener((Listener)ParameterInputDialog.access$4300(this.this$1).new ScalarParameterListener());
                    dialog.setInput(handle);
                    if (dialog.open() == 0) {
                        if (dialog.getResult() instanceof ParameterHandle) {
                            ParameterHandle paramerHandle = (ParameterHandle)dialog.getResult();
                            if (isCreateMode) {
                                SlotHandle parameterSlotHandle = Utility.getReportModuleHandle().getParameters();
                                try {
                                    parameterSlotHandle.add((DesignElementHandle)paramerHandle);
                                    this.val$cb.add(paramerHandle.getQualifiedName());
                                }
                                catch (ContentException e) {
                                    ExceptionHandler.handle(e);
                                }
                                catch (NameException e) {
                                    ExceptionHandler.handle(e);
                                }
                            }
                            this.val$cb.setItems(ParameterInputDialog.access$4800(this.this$1));
                            this.val$cb.select(Utility.findIndex(this.val$cb.getItems(), paramerHandle.getQualifiedName()));
                        }
                    } else {
                        dataSetParameterHandle.setParamName(originalParamName);
                    }
                }
            };
            ControlProvider.createButton(this.reportParamComposite, 8, (SelectionListener)listener);
        }

        private String[] getParameterNames() {
            List parameterList = Utility.getAllParameters();
            ArrayList<String> nameList = new ArrayList<String>();
            nameList.add(UNLINKED_REPORT_PARAM);
            for (int i = 0; i < parameterList.size(); ++i) {
                ReportElementHandle handle = (ReportElementHandle)parameterList.get(i);
                if (!(handle instanceof ScalarParameterHandle)) continue;
                nameList.add(handle.getQualifiedName());
            }
            String[] paramName = new String[nameList.size()];
            for (int i = 0; i < nameList.size(); ++i) {
                paramName[i] = nameList.get(i).toString();
            }
            return paramName;
        }

        protected void rollback() {
            DataSetParameter structure = DataSetParametersPage.this.getStructure(this.getStructureOrHandle());
            if (DataSetParametersPage.this.originalStructure != null) {
                structure.setName(DataSetParametersPage.this.originalStructure.getName());
                structure.setParameterDataType(DataSetParametersPage.this.originalStructure.getParameterDataType());
                structure.setIsInput(DataSetParametersPage.this.originalStructure.isInput());
                structure.setIsOutput(DataSetParametersPage.this.originalStructure.isOutput());
                structure.setDefaultValue(DataSetParametersPage.this.originalStructure.getDefaultValue());
                if (DataSetParametersPage.this.isOdaParameterStructure) {
                    ((OdaDataSetParameter)structure).setParamName(((OdaDataSetParameter)DataSetParametersPage.this.originalStructure).getParamName());
                }
                DataSetParametersPage.this.originalStructure = null;
            } else {
                try {
                    DataSetParametersPage.this.parameters.removeItem((IStructure)structure);
                    DataSetParametersPage.this.viewer.getViewer().refresh();
                }
                catch (PropertyValueException e) {
                    ExceptionHandler.handle(e);
                }
            }
        }

        protected IStatus validateSemantics(Object structureOrHandle) {
            if (!this.isUniqueName()) {
                return new Status(4, "org.eclipse.ui", 0, Messages.getString((String)"dataset.editor.error.duplicateParameterName"), null);
            }
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }

        private boolean isUniqueName() {
            DataSetParameter structure = DataSetParametersPage.this.getStructure(this.getStructureOrHandle());
            Iterator iter = DataSetParametersPage.this.parameters.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    DataSetParameterHandle handle = (DataSetParameterHandle)iter.next();
                    if (structure == handle.getStructure() || !handle.getName().equals(structure.getName())) continue;
                    return false;
                }
            }
            return true;
        }

        protected IStatus validateSyntax(Object structureOrHandle) {
            String paramName;
            if (this.isOutputParameter()) {
                this.enableComposite(this.defaultValueComposite, false);
                Text tx = (Text)this.defaultValueComposite.getChildren()[0];
                if (!tx.getText().equals("")) {
                    tx.setText("");
                }
                if (DataSetParametersPage.this.isOdaParameterStructure) {
                    this.enableComposite(this.reportParamComposite, false);
                }
            } else {
                this.enableComposite(this.defaultValueComposite, true);
                if (DataSetParametersPage.this.isOdaParameterStructure) {
                    this.enableComposite(this.reportParamComposite, true);
                }
            }
            if (DataSetParametersPage.this.isOdaParameterStructure && this.needsCheck(this.reportParamName, paramName = ((OdaDataSetParameterHandle)this.structureHandle).getParamName())) {
                this.reportParamName = paramName;
                Control[] controls = this.defaultValueComposite.getChildren();
                if (!$assertionsDisabled && !(controls[0] instanceof Text)) {
                    throw new AssertionError();
                }
                Text tx = (Text)controls[0];
                if (paramName == null) {
                    for (int i = 0; i < controls.length; ++i) {
                        controls[i].setEnabled(true);
                    }
                    tx.setText(Utility.getNonNullString(this.structureHandle.getDefaultValue()));
                } else {
                    for (int i = 0; i < controls.length; ++i) {
                        controls[i].setEnabled(false);
                    }
                    tx.setText(NONE_DEFAULT_VALUE);
                }
            }
            if (this.structureHandle.getName().trim().length() == 0 || this.dataSetParamName.getText().trim().length() == 0) {
                return this.getBlankPropertyStatus(cellLabels[Utility.findIndex(cellProperties, "name")]);
            }
            return new Status(0, "org.eclipse.ui", 0, "", null);
        }

        private boolean needsCheck(String reportParamName, String paramName) {
            if (!this.reportParamComposite.isEnabled()) {
                return false;
            }
            if (reportParamName == null && paramName == null) {
                return false;
            }
            return reportParamName == null || !reportParamName.equals(paramName);
        }

        private boolean isOutputParameter() {
            return !this.structureHandle.isInput() && this.structureHandle.isOutput();
        }

        private void enableComposite(Composite composite, boolean enable) {
            if (composite.isEnabled() != enable) {
                composite.setEnabled(enable);
                Control[] controls = composite.getChildren();
                for (int i = 0; i < controls.length; ++i) {
                    controls[i].setEnabled(enable);
                }
            }
        }

        private DataSetParameterHandle getStructureHandle(Object structureOrHandle) {
            if (structureOrHandle instanceof DataSetParameterHandle) {
                return (DataSetParameterHandle)structureOrHandle;
            }
            DataSetParameterHandle handle = null;
            try {
                handle = (DataSetParameterHandle)DataSetParametersPage.this.parameters.addItem((IStructure)DataSetParametersPage.this.getStructure(this.getStructureOrHandle()));
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
            if (!$assertionsDisabled && handle == null) {
                throw new AssertionError();
            }
            return handle;
        }

        protected String getTitle() {
            return super.getTitle() + " " + Messages.getString((String)"DataSetParameterPage.title.ParameterInputDialog");
        }

        static /* synthetic */ Text access$4100(ParameterInputDialog x0) {
            return x0.dataSetParamName;
        }

        static /* synthetic */ void access$4200(ParameterInputDialog x0, IStatus x1) {
            x0.updateStatus(x1);
        }

        static /* synthetic */ DataSetParametersPage access$4300(ParameterInputDialog x0) {
            return x0.DataSetParametersPage.this;
        }

        static /* synthetic */ void access$4600(ParameterInputDialog x0, String x1) {
            x0.setDirection(x1);
        }

        static /* synthetic */ String[] access$4800(ParameterInputDialog x0) {
            return x0.getParameterNames();
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$designer$data$ui$dataset$DataSetParametersPage == null ? (class$org$eclipse$birt$report$designer$data$ui$dataset$DataSetParametersPage = DataSetParametersPage.class$("org.eclipse.birt.report.designer.data.ui.dataset.DataSetParametersPage")) : class$org$eclipse$birt$report$designer$data$ui$dataset$DataSetParametersPage).desiredAssertionStatus();
        }
    }

    private class ParameterViewLableProvider
    implements ITableLabelProvider {
        boolean isOdaUsed = true;

        public ParameterViewLableProvider(boolean isOdaUsed) {
            this.isOdaUsed = isOdaUsed;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String value = null;
            DataSetParameter metaData = null;
            metaData = element instanceof DataSetParameter ? (DataSetParameter)element : (DataSetParameter)((DataSetParameterHandle)element).getStructure();
            if (metaData != DataSetParametersPage.this.newParameter) {
                value = this.isOdaUsed ? this.getOdaParametersValue((OdaDataSetParameter)metaData, columnIndex) : this.getParametersValue(metaData, columnIndex);
            } else if (columnIndex == 1) {
                value = Messages.getString((String)"DataSetParametersPage.Prompt.new");
            }
            if (value == null) {
                value = "";
            }
            return value;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        private String getParametersValue(DataSetParameter parameter, int columnIndex) {
            String value = null;
            switch (columnIndex) {
                case 0: {
                    if (parameter.getPosition() == null) break;
                    value = parameter.getPosition().toString();
                    break;
                }
                case 1: {
                    value = parameter.getName();
                    break;
                }
                case 2: {
                    if (parameter == DataSetParametersPage.this.newParameter && !DataSetParametersPage.this.isDataTypeSet) break;
                    value = DataSetParametersPage.this.getTypeDisplayName(parameter.getParameterDataType());
                    break;
                }
                case 3: {
                    if (parameter == DataSetParametersPage.this.newParameter && !DataSetParametersPage.this.isDirectionSet) break;
                    value = DataSetParametersPage.this.getDirectionDisplayName(parameter.isInput(), parameter.isOutput());
                    break;
                }
                case 4: {
                    value = parameter.getDefaultValue();
                }
            }
            return value;
        }

        private String getOdaParametersValue(OdaDataSetParameter parameter, int columnIndex) {
            String value = null;
            switch (columnIndex) {
                case 0: {
                    if (parameter.getPosition() == null) break;
                    value = parameter.getPosition().toString();
                    break;
                }
                case 1: {
                    value = parameter.getName();
                    break;
                }
                case 2: {
                    if (parameter == DataSetParametersPage.this.newParameter && !DataSetParametersPage.this.isDataTypeSet) break;
                    value = DataSetParametersPage.this.getTypeDisplayName(parameter.getParameterDataType());
                    break;
                }
                case 3: {
                    if (parameter == DataSetParametersPage.this.newParameter && !DataSetParametersPage.this.isDirectionSet) break;
                    value = DataSetParametersPage.this.getDirectionDisplayName(parameter.isInput(), parameter.isOutput());
                    break;
                }
                case 4: {
                    if (parameter.getParamName() == null || parameter.getParamName().trim().length() == 0) {
                        value = parameter.getDefaultValue();
                        break;
                    }
                    value = NONE_DEFAULT_VALUE;
                    break;
                }
                case 5: {
                    if (parameter == DataSetParametersPage.this.newParameter || (value = parameter.getParamName()) != null && value.trim().length() != 0) break;
                    value = UNLINKED_REPORT_PARAM;
                }
            }
            return value;
        }
    }

    private class ParameterViewContentProvider
    implements IStructuredContentProvider {
        private ParameterViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null || !(inputElement instanceof PropertyHandle)) {
                return new Object[0];
            }
            Iterator iter = ((PropertyHandle)inputElement).iterator();
            ArrayList params = new ArrayList(10);
            if (iter != null) {
                while (iter.hasNext()) {
                    params.add(iter.next());
                }
            }
            DataSetParametersPage.this.refreshPositions();
            return params.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ScalarParameterListener
    implements Listener {
        private ScalarParameterListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            DataSetParametersPage.this.modelChanged = true;
            DataSetParametersPage.this.enableModelChanged();
        }
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetParametersPage.this.setPageProperties();
        }
    }
}

