/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetTableAction;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetTableActionFactory;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.properties.AbstractPropertyPage;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ResultSetPreviewPage
extends AbstractPropertyPage
implements Listener {
    private TableViewer resultSetTableViewer = null;
    private transient Table resultSetTable = null;
    private boolean modelChanged = true;
    private boolean needsUpdateUI = true;
    private int columnCount = -1;
    private List recordList = null;
    private List errorList = null;
    private String[] columnBindingNames;
    private int previousMaxRow = -1;

    public Control createPageControl(Composite parent) {
        this.resultSetTable = new Table(parent, 65538);
        this.resultSetTable.setHeaderVisible(true);
        this.resultSetTable.setLinesVisible(true);
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        this.resultSetTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    MenuManager menuManager = new MenuManager();
                    ResultSetTableAction copyAction = ResultSetTableActionFactory.createResultSetTableAction(ResultSetPreviewPage.this.resultSetTable, 1);
                    ResultSetTableAction selectAllAction = ResultSetTableActionFactory.createResultSetTableAction(ResultSetPreviewPage.this.resultSetTable, 2);
                    menuManager.add((IAction)copyAction);
                    menuManager.add((IAction)selectAllAction);
                    menuManager.update();
                    copyAction.update();
                    selectAllAction.update();
                    Menu contextMenu = menuManager.createContextMenu((Control)ResultSetPreviewPage.this.resultSetTable);
                    contextMenu.setEnabled(true);
                    contextMenu.setVisible(true);
                }
            }
        });
        this.createResultSetTableViewer();
        return this.resultSetTable;
    }

    private void createResultSetTableViewer() {
        this.resultSetTableViewer = new TableViewer(this.resultSetTable);
        this.resultSetTableViewer.setSorter(null);
        this.resultSetTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.resultSetTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((String[])element)[columnIndex];
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    public void pageActivated() {
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.preview"), 0);
        if (this.modelChanged) {
            this.modelChanged = false;
            new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ResultSetPreviewPage.this.runUpdateResults();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void runUpdateResults() {
        if (this.resultSetTable != null && !this.resultSetTable.isDisposed()) {
            ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader parentLoader = oldContextLoader;
            if (parentLoader == null) {
                parentLoader = this.getClass().getClassLoader();
            }
            ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader(parentLoader);
            Thread.currentThread().setContextClassLoader(newContextLoader);
            this.clearResultSetTable();
            try {
                DataSessionContext context = new DataSessionContext(3, ((DataSetHandle)this.getContainer().getModel()).getModuleHandle());
                DataRequestSession session = DataRequestSession.newSession((DataSessionContext)context);
                HashMap<String, Integer> appContext = new HashMap<String, Integer>();
                appContext.put(DataEngine.MEMORY_DATA_SET_CACHE, new Integer(this.getMaxRowPreference()));
                context.setAppContext(appContext);
                this.updateResultsProcess(this.executeProcess(session));
                session.shutdown();
            }
            catch (BirtException e) {
                ExceptionHandler.handle(e);
            }
            this.updateResultSetTableUI();
            Thread.currentThread().setContextClassLoader(oldContextLoader);
        }
    }

    protected final void clearResultSetTable() {
        TableColumn[] columns = this.resultSetTable.getColumns();
        for (int n = 0; n < columns.length; ++n) {
            columns[n].dispose();
        }
        this.resultSetTable.removeAll();
    }

    private IQueryResults executeProcess(DataRequestSession session) {
        this.errorList = new ArrayList();
        try {
            IQueryResults resultSet = DataSetProvider.getCurrentInstance().execute(((DataSetEditor)this.getContainer()).getHandle(), session);
            if (resultSet != null) {
                IResultMetaData metaData = resultSet.getResultMetaData();
                this.columnCount = metaData.getColumnCount();
                QueryDefinition query = new QueryDefinition((BaseQueryDefinition)resultSet.getPreparedQuery().getReportQueryDefn());
                query.setDataSetName(((DataSetEditor)this.getContainer()).getHandle().getQualifiedName());
                int maxRow = this.getMaxRowPreference();
                query.setMaxRows(maxRow);
                PropertyHandle handle = ((DataSetEditor)this.getContainer()).getHandle().getPropertyHandle("parameters");
                if (handle != null) {
                    Iterator paramIter = handle.iterator();
                    while (paramIter.hasNext()) {
                        DataSetParameterHandle paramDefn = (DataSetParameterHandle)paramIter.next();
                        if (!paramDefn.isInput()) continue;
                        String defaultValue = null;
                        defaultValue = paramDefn instanceof OdaDataSetParameterHandle && ((OdaDataSetParameterHandle)paramDefn).getParamName() != null ? ExpressionUtil.createJSParameterExpression((String)((OdaDataSetParameterHandle)paramDefn).getParamName()) : paramDefn.getDefaultValue();
                        if (defaultValue == null) continue;
                        InputParameterBinding binding = new InputParameterBinding(paramDefn.getName(), (IBaseExpression)new ScriptExpression(defaultValue));
                        query.addInputParamBinding(binding);
                    }
                }
                this.columnBindingNames = new String[this.columnCount];
                ScriptExpression[] expressions = new ScriptExpression[this.columnCount];
                for (int n = 0; n < this.columnCount; ++n) {
                    this.columnBindingNames[n] = metaData.getColumnName(n + 1);
                    expressions[n] = new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)this.columnBindingNames[n]));
                    query.addResultSetExpression(this.columnBindingNames[n], (IBaseExpression)expressions[n]);
                }
                boolean clearCache = false;
                if (maxRow != this.previousMaxRow) {
                    this.previousMaxRow = maxRow;
                    clearCache = true;
                }
                return DataSetProvider.getCurrentInstance().execute(((DataSetEditor)this.getContainer()).getHandle(), query, true, true, clearCache, session);
            }
        }
        catch (BirtException e) {
            this.errorList.add(e);
            return null;
        }
        return null;
    }

    private int getMaxRowPreference() {
        int maxRow;
        Preferences preferences = ReportPlugin.getDefault().getPluginPreferences();
        if (preferences.contains("user_maxrow")) {
            maxRow = preferences.getInt("user_maxrow");
        } else {
            maxRow = 500;
            preferences.setValue("user_maxrow", maxRow);
        }
        return maxRow;
    }

    private void updateResultsProcess(final IQueryResults resultSet) {
        this.needsUpdateUI = true;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", -1);
                ResultSetPreviewPage.this.populateRecords(resultSet);
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()){

                protected void cancelPressed() {
                    super.cancelPressed();
                    ResultSetPreviewPage.this.needsUpdateUI = false;
                    try {
                        resultSet.close();
                    }
                    catch (BirtException birtException) {
                        // empty catch block
                    }
                }
            }.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e);
        }
        catch (InterruptedException e) {
            ExceptionHandler.handle(e);
        }
    }

    private void populateRecords(IQueryResults actualResultSet) {
        try {
            if (actualResultSet != null) {
                this.recordList = new ArrayList();
                IResultIterator iter = actualResultSet.getResultIterator();
                while (iter.next() && this.columnCount > 0) {
                    String[] record = new String[this.columnCount];
                    for (int n = 0; n < record.length; ++n) {
                        record[n] = iter.getString(this.columnBindingNames[n]);
                    }
                    this.recordList.add(record);
                }
                actualResultSet.close();
            }
        }
        catch (BirtException e) {
            this.errorList.add(e);
        }
    }

    private void updateResultSetTableUI() {
        if (!this.needsUpdateUI) {
            return;
        }
        if (!this.errorList.isEmpty()) {
            ExceptionHandler.handle((Exception)this.errorList.get(0));
        } else {
            this.createColumns();
            this.insertRecords();
        }
    }

    private void createColumns() {
        DataSetViewData[] columnsModel = ((DataSetEditor)this.getContainer()).getCurrentItemModel();
        TableColumn column = null;
        TableLayout layout = new TableLayout();
        for (int n = 0; n < this.columnCount; ++n) {
            column = new TableColumn(this.resultSetTable, 16384);
            column.setText(this.getColumnDisplayName(columnsModel, n));
            column.setResizable(true);
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(120, true));
            this.addColumnSortListener(column, n);
            column.pack();
        }
        this.resultSetTable.setLayout((Layout)layout);
        this.resultSetTable.layout(true);
    }

    private void insertRecords() {
        this.resultSetTableViewer.setInput((Object)this.recordList);
    }

    private String getColumnDisplayName(DataSetViewData[] columnsModel, int index) {
        if (columnsModel == null || columnsModel.length == 0 || index < 0 || index > columnsModel.length) {
            return "";
        }
        return columnsModel[index].getDisplayName();
    }

    private void addColumnSortListener(TableColumn column, final int index) {
        column.addSelectionListener(new SelectionListener(){
            private boolean asc = false;

            public void widgetSelected(SelectionEvent e) {
                ResultSetPreviewPage.this.sort(index, this.asc);
                this.asc = !this.asc;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void sort(final int columnIndex, final boolean asc) {
        this.resultSetTable.setSortColumn(this.resultSetTable.getColumn(columnIndex));
        this.resultSetTable.setSortDirection(asc ? 1024 : 128);
        try {
            this.resultSetTableViewer.setSorter(new ViewerSorter(new RuleBasedCollator(((RuleBasedCollator)Collator.getInstance()).getRules()){

                public int compare(String source, String target) {
                    int result = 0;
                    result = super.compare(source, target);
                    if (!asc) {
                        return result;
                    }
                    return result *= -1;
                }
            }){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    e1 = ((String[])e1)[columnIndex] == null ? "" : ((String[])e1)[columnIndex];
                    e2 = ((String[])e2)[columnIndex] == null ? "" : ((String[])e2)[columnIndex];
                    return super.compare(viewer, e1, e2);
                }
            });
        }
        catch (ParseException e) {
            ExceptionHandler.handle(e);
        }
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (focus.equals(this.getContainer().getModel()) || ((DataSetEditor)this.getContainer()).modelChanged()) {
            this.modelChanged = true;
        }
    }

    public boolean performCancel() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performCancel();
    }

    public boolean performOk() {
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
        return super.performOk();
    }

    public String getToolTip() {
        return Messages.getString((String)"dataset.resultset.preview.tooltip");
    }
}

