/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.property;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.birt.report.designer.data.ui.property.PropertyContentProvider;
import org.eclipse.birt.report.designer.data.ui.property.PropertyLabelProvider;
import org.eclipse.birt.report.designer.data.ui.property.PropertyNode;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPageContainer;
import org.eclipse.jface.dialogs.DialogMessageArea;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractPropertyDialog
extends BaseDialog
implements IPropertyPageContainer {
    private transient Object modelObject = null;
    protected transient PropertyNode rootNode = null;
    private transient StackLayout propertyPaneLayout = null;
    private transient Composite propertyPane = null;
    private transient PropertyNode currentNode = null;
    private transient boolean processSelection = true;
    private transient Label titleImage = null;
    protected TreeViewer viewer = null;
    private DialogMessageArea messageArea = null;
    private String nodeId;
    protected boolean showPage = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractPropertyDialog(Shell parentShell, Object model) {
        super(parentShell, "");
        this.setModel(model);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.propertyPaneLayout = new StackLayout();
        this.rootNode = new PropertyNode("org.eclipse.birt.report.designer.ui.dialogs.properties.propertydialog.rootnode");
    }

    public void setModel(Object model) {
        this.modelObject = model;
    }

    public final Object getModel() {
        return this.modelObject;
    }

    public final void addNodeTo(String path, PropertyNode node) {
        node.setContainer(this);
        if (path == null || path.trim().equals("/")) {
            this.rootNode.add(node);
        } else {
            PropertyNode parentNode = this.getNode(path);
            if (parentNode != null) {
                parentNode.add(node);
            }
        }
    }

    public final void addPageTo(String path, String nodeId, String nodeLabel, Image nodeImage, IPropertyPage page) {
        PropertyNode node = new PropertyNode(nodeId, nodeLabel, nodeImage, page);
        this.addNodeTo(path, node);
    }

    private final PropertyNode getNode(String path) {
        PropertyNode currentNode = null;
        if (path != null) {
            path = path.trim();
            currentNode = this.rootNode;
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                if ((currentNode = currentNode.getSubNode(tokenizer.nextToken())) != null) continue;
                return null;
            }
        }
        return currentNode;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        SashForm sashForm = new SashForm(composite, 0);
        sashForm.setOrientation(256);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer((Composite)sashForm);
        this.createPropertyPane((Composite)sashForm);
        sashForm.setWeights(new int[]{20, 80});
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(768));
        this.initTreeSelection();
        return composite;
    }

    private void initTreeSelection() {
        PropertyNode node = this.getNode(this.getDeafultNode());
        if (node != null) {
            StructuredSelection select = new StructuredSelection((Object)node);
            this.viewer.setSelection((ISelection)select);
        } else if (this.viewer.getTree().getItems().length > 0) {
            TreeItem firstNode = this.viewer.getTree().getItems()[0];
            StructuredSelection select = new StructuredSelection(firstNode.getData());
            this.viewer.setSelection((ISelection)select);
        }
    }

    private final Control createTreeViewer(Composite parent) {
        this.viewer = new TreeViewer(parent);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertyNode selectedNode = (PropertyNode)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (AbstractPropertyDialog.this.processSelection) {
                    BusyIndicator.showWhile((Display)AbstractPropertyDialog.this.getShell().getDisplay(), (Runnable)new Runnable(this, selectedNode){
                        private final /* synthetic */ PropertyNode val$selectedNode;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$selectedNode = val$selectedNode;
                        }

                        public void run() {
                            1.access$100(this.this$1).showSelectionPage(this.val$selectedNode);
                        }
                    });
                }
                AbstractPropertyDialog.this.processSelection = true;
            }

            static /* synthetic */ AbstractPropertyDialog access$100(1 x0) {
                return x0.AbstractPropertyDialog.this;
            }
        });
        this.viewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == AbstractPropertyDialog.this.viewer.getTree()) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = AbstractPropertyDialog.this.viewer.getTree().getItem(pt);
                    if (item == null) {
                        AbstractPropertyDialog.this.viewer.getTree().setToolTipText("");
                    } else {
                        String text = null;
                        if (item.getData() instanceof PropertyNode) {
                            text = ((PropertyNode)item.getData()).getPage().getToolTip();
                        }
                        AbstractPropertyDialog.this.viewer.getTree().setToolTipText(text);
                    }
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new PropertyContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider());
        this.viewer.setInput((Object)this.rootNode);
        return this.viewer.getTree();
    }

    public void showSelectionPage(PropertyNode selectedNode) {
        this.showPage = this.showPage(selectedNode);
        if (!this.showPage) {
            this.processSelection = false;
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.currentNode));
        }
    }

    private final Composite createPropertyPane(Composite parent) {
        Composite propertyContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        propertyContainer.setLayout((Layout)layout);
        Composite titleComposite = new Composite(propertyContainer, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        titleComposite.setLayout((Layout)layout);
        GridData titleLayoutData = new GridData(768);
        titleLayoutData.horizontalIndent = 7;
        titleComposite.setLayoutData((Object)titleLayoutData);
        if (this.isTitleVisible()) {
            this.createTitleArea(titleComposite);
            Label separator = new Label(propertyContainer, 258);
            separator.setLayoutData((Object)new GridData(768));
        }
        GridData data = new GridData(1808);
        this.propertyPane = new Composite(propertyContainer, 0);
        this.propertyPane.setLayout((Layout)this.propertyPaneLayout);
        this.propertyPane.setLayoutData((Object)data);
        return propertyContainer;
    }

    public Composite createTitleArea(Composite parent) {
        Composite messageComposite = new Composite(parent, 0);
        GridData data = new GridData(768);
        messageComposite.setLayoutData((Object)data);
        FormLayout messageLayout = new FormLayout();
        messageComposite.setLayout((Layout)messageLayout);
        this.messageArea = new DialogMessageArea();
        this.messageArea.createContents(messageComposite);
        this.titleImage = new Label(messageComposite, 16384);
        FormData imageData = new FormData();
        imageData.right = new FormAttachment(100);
        imageData.top = new FormAttachment(0);
        imageData.bottom = new FormAttachment(100);
        this.titleImage.setLayoutData((Object)imageData);
        FormData messageData = new FormData();
        messageData.left = new FormAttachment(0, 0);
        messageData.right = new FormAttachment((Control)this.titleImage, 0);
        messageData.bottom = new FormAttachment((Control)this.titleImage, 0, 1024);
        messageData.top = new FormAttachment(0, 0);
        this.messageArea.setTitleLayoutData((Object)messageData);
        this.messageArea.setMessageLayoutData((Object)messageData);
        return messageComposite;
    }

    private final boolean showPage(PropertyNode node) {
        if (!(this.currentNode == null || node != this.currentNode && this.currentNode.getPage().canLeave())) {
            return false;
        }
        if (!node.isPageControlCreated()) {
            Control control = node.createPageControl(this.propertyPane);
            if (!$assertionsDisabled && control == null) {
                throw new AssertionError((Object)("Control has not been created for node " + node.getId()));
            }
        }
        this.currentNode = node;
        this.propertyPaneLayout.topControl = node.getPageControl();
        node.getPage().pageActivated();
        this.propertyPane.layout();
        return true;
    }

    protected Composite getPropertyPane() {
        return this.propertyPane;
    }

    protected final void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.okPressed();
                break;
            }
            case 1: {
                this.cancelPressed();
                break;
            }
            case 17: {
                this.performHelp();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    public abstract boolean performOk();

    public abstract boolean performCancel();

    private final void performHelp() {
        if (this.currentNode != null) {
            this.currentNode.getPage().performHelp();
        }
    }

    protected final void cancelPressed() {
        if (this.rootNode.hasSubNodes()) {
            PropertyNode[] nodes = this.rootNode.getSubNodes();
            for (int n = 0; n < nodes.length; ++n) {
                if (this.cancelPressed(nodes[n])) continue;
                return;
            }
        }
        if (this.performCancel()) {
            super.cancelPressed();
        }
    }

    private final boolean cancelPressed(PropertyNode node) {
        if (node.getPage().performCancel()) {
            if (node.hasSubNodes()) {
                PropertyNode[] nodes = node.getSubNodes();
                for (int n = 0; n < nodes.length; ++n) {
                    if (this.cancelPressed(nodes[n])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void okPressed() {
        if (this.rootNode.hasSubNodes()) {
            PropertyNode[] nodes = this.rootNode.getSubNodes();
            for (int n = 0; n < nodes.length; ++n) {
                if (this.okPressed(nodes[n])) continue;
                return;
            }
        }
        if (this.performOk()) {
            super.okPressed();
        }
    }

    private final boolean okPressed(PropertyNode node) {
        if (node.getPage().performOk()) {
            if (node.hasSubNodes()) {
                PropertyNode[] nodes = node.getSubNodes();
                for (int n = 0; n < nodes.length; ++n) {
                    if (this.okPressed(nodes[n])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void handleShellCloseEvent() {
        this.cancelPressed();
    }

    protected Point getInitialSize() {
        return new Point(800, 500);
    }

    protected boolean isTitleVisible() {
        return true;
    }

    public final void setMessage(String message, int messageType) {
        if (this.messageArea != null) {
            if (messageType != 0) {
                this.titleImage.setVisible(false);
            } else {
                this.titleImage.setVisible(true);
            }
            this.messageArea.updateText(message, messageType);
        }
    }

    public final void setMessage(String message) {
        this.setMessage(message, 0);
    }

    protected void setDefaultNode(String attribute) {
        this.nodeId = attribute;
    }

    protected String getDeafultNode() {
        return this.nodeId;
    }

    protected PropertyNode getCurrentNode() {
        return this.currentNode;
    }

    static {
        $assertionsDisabled = !AbstractPropertyDialog.class.desiredAssertionStatus();
    }
}

