/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.property;

import org.eclipse.birt.report.designer.data.ui.property.PropertyNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public final class PropertyContentProvider
implements ITreeContentProvider {
    private transient PropertyNode rootNode = null;

    public Object[] getChildren(Object parentElement) {
        PropertyNode node = (PropertyNode)parentElement;
        return node.getSubNodes();
    }

    public Object getParent(Object element) {
        return this.findParent(this.rootNode, ((PropertyNode)element).getId());
    }

    public boolean hasChildren(Object element) {
        return ((PropertyNode)element).hasSubNodes();
    }

    public Object[] getElements(Object inputElement) {
        if (((PropertyNode)inputElement).hasSubNodes()) {
            return ((PropertyNode)inputElement).getSubNodes();
        }
        return new PropertyNode[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.rootNode = (PropertyNode)newInput;
    }

    private PropertyNode findParent(PropertyNode startNode, String childId) {
        if (startNode == null || childId == null) {
            return null;
        }
        if (childId.trim().equals("/")) {
            return null;
        }
        PropertyNode found = startNode.getSubNode(childId);
        if (found != null) {
            return startNode;
        }
        if (startNode.hasSubNodes()) {
            PropertyNode[] children = startNode.getSubNodes();
            for (int n = 0; n < children.length; ++n) {
                found = this.findParent(children[n], childId);
                if (found == null) continue;
                return found;
            }
        }
        return found;
    }
}

