/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.property;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPageContainer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class PropertyNode {
    private transient ArrayList subNodes = null;
    private transient String id = null;
    private transient String nodeLabel = null;
    private transient Image nodeImage = null;
    private transient IPropertyPage page = null;
    private transient Control pageControl = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertyNode(String nodeId) {
        this.id = nodeId;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final void setNodeImage(Image labelImage) {
        this.nodeImage = labelImage;
    }

    public final void setNodeLabel(String labelText) {
        this.nodeLabel = labelText;
    }

    public final void setPage(IPropertyPage page) {
        if (!$assertionsDisabled && page == null) {
            throw new AssertionError((Object)" page is null");
        }
        this.page = page;
    }

    public PropertyNode(String nodeId, String label) {
        this(nodeId);
        this.nodeLabel = label;
    }

    public PropertyNode(String nodeId, String label, Image image) {
        this(nodeId, label);
        this.nodeImage = image;
    }

    public PropertyNode(String nodeId, String label, Image image, IPropertyPage page) {
        this(nodeId, label, image);
        if (!$assertionsDisabled && page == null) {
            throw new AssertionError((Object)" page is null");
        }
        this.page = page;
    }

    public final String getId() {
        return this.id;
    }

    public final String getNodeLabel() {
        if (this.nodeLabel == null) {
            return this.page.getName();
        }
        return this.nodeLabel;
    }

    public final Image getNodeImage() {
        return this.nodeImage;
    }

    public final IPropertyPage getPage() {
        return this.page;
    }

    public final void add(PropertyNode node) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError((Object)"Null node cannot be added");
        }
        if (this.subNodes == null) {
            this.subNodes = new ArrayList(5);
        }
        this.subNodes.add(node);
    }

    public final PropertyNode remove(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError((Object)"Null id passed");
        }
        if (this.subNodes == null) {
            return null;
        }
        for (int n = 0; n < this.subNodes.size(); ++n) {
            PropertyNode subNode = (PropertyNode)this.subNodes.get(n);
            if (!subNode.getId().equals(id)) continue;
            if (this.subNodes.remove(subNode)) {
                return subNode;
            }
            return null;
        }
        return null;
    }

    public final PropertyNode getSubNode(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError((Object)"Null id passed");
        }
        if (this.subNodes == null) {
            return null;
        }
        Iterator iter = this.subNodes.iterator();
        while (iter.hasNext()) {
            PropertyNode subNode = (PropertyNode)iter.next();
            if (!subNode.getId().equals(id)) continue;
            return subNode;
        }
        return null;
    }

    public final PropertyNode[] getSubNodes() {
        if (this.subNodes == null) {
            return null;
        }
        return this.subNodes.toArray(new PropertyNode[0]);
    }

    public final Control createPageControl(Composite parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError((Object)"parent composite is null");
        }
        this.pageControl = this.page.createPageControl(parent);
        if (!$assertionsDisabled && this.pageControl == null) {
            throw new AssertionError((Object)"The page returned a null control");
        }
        return this.pageControl;
    }

    public final Control getPageControl() {
        return this.pageControl;
    }

    public final boolean isPageControlCreated() {
        return this.pageControl != null;
    }

    public final boolean hasSubNodes() {
        return this.subNodes != null && this.subNodes.size() > 0;
    }

    public final void setContainer(IPropertyPageContainer container) {
        if (!$assertionsDisabled && this.page == null) {
            throw new AssertionError((Object)"There is no page present");
        }
        this.page.setContainer(container);
    }

    static {
        $assertionsDisabled = !PropertyNode.class.desiredAssertionStatus();
    }
}

